/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.corebase.utils;

import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.inlong.tubemq.corebase.Message;
import org.apache.inlong.tubemq.corebase.MessageExt;
import org.apache.inlong.tubemq.corebase.cluster.BrokerInfo;
import org.apache.inlong.tubemq.corebase.cluster.Partition;
import org.apache.inlong.tubemq.corebase.cluster.SubscribeInfo;
import org.apache.inlong.tubemq.corebase.cluster.TopicInfo;
import org.apache.inlong.tubemq.corebase.protobuf.generated.ClientBroker;
import org.apache.inlong.tubemq.corebase.utils.CheckSum;
import org.apache.inlong.tubemq.corebase.utils.MessageFlagUtils;
import org.apache.inlong.tubemq.corebase.utils.TStringUtils;
import org.apache.inlong.tubemq.corebase.utils.Tuple2;

public class DataConverterUtil {
    public static List<SubscribeInfo> convertSubInfo(List<String> strSubInfoList) {
        ArrayList<SubscribeInfo> subInfoList = new ArrayList<SubscribeInfo>();
        if (strSubInfoList != null) {
            for (String strSubInfo : strSubInfoList) {
                if (!TStringUtils.isNotBlank(strSubInfo)) continue;
                SubscribeInfo subInfo = new SubscribeInfo(strSubInfo);
                subInfoList.add(subInfo);
            }
        }
        return subInfoList;
    }

    public static List<String> formatSubInfo(List<SubscribeInfo> subInfoList) {
        ArrayList<String> strSubInfoList = new ArrayList<String>();
        if (subInfoList != null && !subInfoList.isEmpty()) {
            for (SubscribeInfo subInfo : subInfoList) {
                if (subInfo == null) continue;
                strSubInfoList.add(subInfo.toString());
            }
        }
        return strSubInfoList;
    }

    public static List<Partition> convertPartitionInfo(List<String> strPartInfoList) {
        ArrayList<Partition> partList = new ArrayList<Partition>();
        if (strPartInfoList != null) {
            for (String partInfo : strPartInfoList) {
                if (partInfo == null) continue;
                partList.add(new Partition(partInfo));
            }
        }
        return partList;
    }

    public static Tuple2<Map<String, Integer>, List<TopicInfo>> convertTopicInfo(Map<Integer, BrokerInfo> brokerInfoMap, List<String> strTopicInfos) {
        ArrayList<TopicInfo> topicList = new ArrayList<TopicInfo>();
        ConcurrentHashMap<String, Integer> topicMaxSizeInBMap = new ConcurrentHashMap<String, Integer>();
        if (strTopicInfos == null || strTopicInfos.isEmpty()) {
            return new Tuple2<Map<String, Integer>, List<TopicInfo>>(topicMaxSizeInBMap, topicList);
        }
        for (String info : strTopicInfos) {
            String[] strTopicInfoSet;
            if (info == null || info.isEmpty()) continue;
            info = info.trim();
            String[] strInfo = info.split("#", -1);
            for (String s : strTopicInfoSet = strInfo[1].split(",")) {
                String[] strTopicInfo = s.split(":");
                BrokerInfo brokerInfo = brokerInfoMap.get(Integer.parseInt(strTopicInfo[0]));
                if (brokerInfo == null) continue;
                topicList.add(new TopicInfo(brokerInfo, strInfo[0], Integer.parseInt(strTopicInfo[1]), Integer.parseInt(strTopicInfo[2]), true, true));
            }
            if (strInfo.length == 2 || TStringUtils.isEmpty(strInfo[2])) continue;
            try {
                topicMaxSizeInBMap.put(strInfo[0], Integer.parseInt(strInfo[2]));
            }
            catch (Throwable throwable) {}
        }
        return new Tuple2<Map<String, Integer>, List<TopicInfo>>(topicMaxSizeInBMap, topicList);
    }

    public static Map<Integer, BrokerInfo> convertBrokerInfo(List<String> strBrokerInfos, boolean enableTLS) {
        ConcurrentHashMap<Integer, BrokerInfo> brokerInfoMap = new ConcurrentHashMap<Integer, BrokerInfo>();
        if (strBrokerInfos != null) {
            int brokerPort = enableTLS ? 8124 : 8123;
            for (String info : strBrokerInfos) {
                if (info == null) continue;
                BrokerInfo brokerInfo = new BrokerInfo(info, brokerPort);
                brokerInfoMap.put(brokerInfo.getBrokerId(), brokerInfo);
            }
        }
        return brokerInfoMap;
    }

    public static Map<String, TreeSet<String>> convertTopicConditions(List<String> strTopicConditions) {
        HashMap<String, TreeSet<String>> topicConditions = new HashMap<String, TreeSet<String>>();
        if (strTopicConditions == null || strTopicConditions.isEmpty()) {
            return topicConditions;
        }
        for (String topicCond : strTopicConditions) {
            String[] strInfo;
            if (TStringUtils.isBlank(topicCond) || TStringUtils.isBlank((strInfo = topicCond.split("#"))[0]) || TStringUtils.isBlank(strInfo[1])) continue;
            String topicName = strInfo[0].trim();
            String[] strCondInfo = strInfo[1].split(",");
            TreeSet conditionSet = topicConditions.computeIfAbsent(topicName, k -> new TreeSet());
            for (String cond : strCondInfo) {
                if (!TStringUtils.isNotBlank(cond)) continue;
                conditionSet.add(cond.trim());
            }
        }
        return topicConditions;
    }

    public static List<Message> convertMessage(String topicName, List<ClientBroker.TransferedMessage> transferedMessageList) {
        if (transferedMessageList == null || transferedMessageList.isEmpty()) {
            return new ArrayList<Message>();
        }
        ArrayList<Message> messageList = new ArrayList<Message>(transferedMessageList.size());
        for (ClientBroker.TransferedMessage trsMessage : transferedMessageList) {
            int flag = trsMessage.getFlag();
            int dataCheckSum = trsMessage.getCheckSum();
            ByteBuffer payloadData = ByteBuffer.allocate(trsMessage.getPayLoadData().size());
            payloadData.put(trsMessage.getPayLoadData().toByteArray());
            payloadData.flip();
            int payloadDataLen = payloadData.array().length;
            int currentChecksum = CheckSum.crc32(payloadData.array());
            if (dataCheckSum != currentChecksum) continue;
            int readPos = 0;
            String attribute = null;
            if (MessageFlagUtils.hasAttribute(flag)) {
                if (payloadDataLen < 4) continue;
                int attrLen = payloadData.getInt(0);
                readPos += 4;
                if (attrLen > (payloadDataLen -= 4)) continue;
                if (attrLen > 0) {
                    byte[] attrData = new byte[attrLen];
                    System.arraycopy(payloadData.array(), readPos, attrData, 0, attrLen);
                    try {
                        attribute = new String(attrData, "UTF-8");
                    }
                    catch (UnsupportedEncodingException e) {
                        throw new RuntimeException(e);
                    }
                    readPos += attrLen;
                    payloadDataLen -= attrLen;
                }
            }
            byte[] payload = new byte[payloadDataLen];
            System.arraycopy(payloadData.array(), readPos, payload, 0, payloadDataLen);
            messageList.add(new MessageExt(trsMessage.getMessageId(), topicName, payload, attribute, flag));
        }
        return messageList;
    }
}

