/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.corebase.cluster;

import java.io.Serializable;
import org.apache.inlong.tubemq.corebase.cluster.BrokerInfo;

public class Partition
implements Comparable<Partition>,
Serializable {
    private static final long serialVersionUID = 7587964123917870096L;
    private final BrokerInfo broker;
    private final String topic;
    private final int partitionId;
    private String partitionKey;
    private String partitionFullStr;
    private String partitionTLSFullStr;
    private int retries = 0;
    private long delayTimeStamp = -2L;

    public Partition(BrokerInfo broker, String topic, int partitionId) {
        this.broker = broker;
        this.topic = topic;
        this.partitionId = partitionId;
        this.builderPartitionStr();
    }

    public Partition(String strPartInfo) {
        this.broker = new BrokerInfo(strPartInfo.split("#")[0]);
        String strInfo = strPartInfo.split("#")[1];
        this.topic = strInfo.split(":")[0];
        this.partitionId = Integer.parseInt(strInfo.split(":")[1]);
        this.builderPartitionStr();
    }

    public Partition(BrokerInfo broker, String partStr) {
        this.broker = broker;
        this.topic = partStr.split(":")[0];
        this.partitionId = Integer.parseInt(partStr.split(":")[1]);
        this.builderPartitionStr();
    }

    public BrokerInfo getBroker() {
        return this.broker;
    }

    public int getBrokerId() {
        return this.broker.getBrokerId();
    }

    public String getHost() {
        return this.broker.getHost();
    }

    public int getPort() {
        return this.broker.getPort();
    }

    public String getPartitionKey() {
        return this.partitionKey;
    }

    public String getTopic() {
        return this.topic;
    }

    public int getPartitionId() {
        return this.partitionId;
    }

    public void increRetries(int retries) {
        this.retries += retries;
        if (this.retries > 3) {
            this.delayTimeStamp = System.currentTimeMillis() + 3000L;
            this.retries = 0;
        }
    }

    public void resetRetries() {
        this.retries = 0;
        this.delayTimeStamp = 0L;
    }

    public int getRetries() {
        return this.retries;
    }

    public long getDelayTimeStamp() {
        return this.delayTimeStamp;
    }

    public void setDelayTimeStamp(long dltTime) {
        this.delayTimeStamp = System.currentTimeMillis() + dltTime;
    }

    @Override
    public int compareTo(Partition other) {
        if (this.broker.getBrokerId() != other.broker.getBrokerId()) {
            return this.broker.getBrokerId() > other.broker.getBrokerId() ? 1 : -1;
        }
        if (!this.broker.getHost().equals(other.broker.getHost())) {
            return this.broker.getHost().compareTo(other.broker.getHost());
        }
        if (!this.topic.equals(other.topic)) {
            return this.topic.compareTo(other.topic);
        }
        if (this.partitionId != other.partitionId) {
            return this.partitionId > other.partitionId ? 1 : -1;
        }
        return 0;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.broker == null ? 0 : this.broker.hashCode());
        result = 31 * result + this.partitionId;
        result = 31 * result + (this.topic == null ? 0 : this.topic.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Partition other = (Partition)obj;
        if (this.broker == null) {
            if (other.broker != null) {
                return false;
            }
        } else {
            if (this.broker.getBrokerId() != other.broker.getBrokerId()) {
                return false;
            }
            if (!this.broker.getHost().equals(other.broker.getHost())) {
                return false;
            }
        }
        if (this.partitionId != other.partitionId) {
            return false;
        }
        return !(this.topic == null ? other.topic != null : !this.topic.equals(other.topic));
    }

    private void builderPartitionStr() {
        StringBuilder sBuilder = new StringBuilder(256);
        this.partitionKey = sBuilder.append(this.broker.getBrokerId()).append(":").append(this.topic).append(":").append(this.partitionId).toString();
        sBuilder.delete(0, sBuilder.length());
        this.partitionFullStr = sBuilder.append(this.broker.toString()).append("#").append(this.topic).append(":").append(this.partitionId).toString();
        sBuilder.delete(0, sBuilder.length());
        this.partitionTLSFullStr = sBuilder.append(this.broker.getFullTLSInfo()).append("#").append(this.topic).append(":").append(this.partitionId).toString();
    }

    public String toString() {
        return this.partitionFullStr;
    }

    public String getPartitionFullStr(boolean overTLS) {
        if (overTLS) {
            return this.partitionTLSFullStr;
        }
        return this.partitionFullStr;
    }
}

