/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.protocol.transformation.function;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonTypeName;
import org.apache.inlong.sort.protocol.transformation.FilterFunction;
import org.apache.inlong.sort.protocol.transformation.FunctionParam;
import org.apache.inlong.sort.protocol.transformation.LogicOperator;
import org.apache.inlong.sort.protocol.transformation.MultiValueCompareOperator;

@JsonTypeName(value="multiValueFilter")
public class MultiValueFilterFunction
extends FilterFunction
implements Serializable {
    @JsonProperty(value="source")
    private FunctionParam source;
    @JsonProperty(value="targets")
    private List<FunctionParam> targets;
    @JsonProperty(value="compareOperator")
    private MultiValueCompareOperator compareOperator;

    @JsonCreator
    public MultiValueFilterFunction(@JsonProperty(value="source") FunctionParam source, @JsonProperty(value="targets") List<FunctionParam> targets, @JsonProperty(value="compareOperator") MultiValueCompareOperator compareOperator, @JsonProperty(value="logicOperator") LogicOperator logicOperator) {
        this.source = (FunctionParam)Preconditions.checkNotNull((Object)source, (Object)"source is null");
        this.targets = (List)Preconditions.checkNotNull(targets, (Object)"targets is null");
        Preconditions.checkState((!targets.isEmpty() ? 1 : 0) != 0, (Object)"targets is empty");
        this.compareOperator = (MultiValueCompareOperator)Preconditions.checkNotNull((Object)compareOperator, (Object)"compareOperator is null");
        this.logicOperator = (LogicOperator)Preconditions.checkNotNull((Object)logicOperator, (Object)"logicOperator is null");
    }

    @Override
    public String format() {
        String targetStr = StringUtils.join((Iterable)this.targets.stream().map(FunctionParam::format).collect(Collectors.toList()), (String)",");
        return String.format("%s %s %s (%s)", this.logicOperator.format(), this.source.format(), this.compareOperator.format(), targetStr);
    }

    @Override
    public List<FunctionParam> getParams() {
        List<FunctionParam> params = Arrays.asList(this.logicOperator, this.source, this.compareOperator);
        params.addAll(this.targets);
        return params;
    }

    @Override
    public String getName() {
        return "multiValueFilter";
    }

    public FunctionParam getSource() {
        return this.source;
    }

    public List<FunctionParam> getTargets() {
        return this.targets;
    }

    public MultiValueCompareOperator getCompareOperator() {
        return this.compareOperator;
    }

    public void setSource(FunctionParam source) {
        this.source = source;
    }

    public void setTargets(List<FunctionParam> targets) {
        this.targets = targets;
    }

    public void setCompareOperator(MultiValueCompareOperator compareOperator) {
        this.compareOperator = compareOperator;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MultiValueFilterFunction)) {
            return false;
        }
        MultiValueFilterFunction other = (MultiValueFilterFunction)o;
        if (!other.canEqual(this)) {
            return false;
        }
        FunctionParam this$source = this.getSource();
        FunctionParam other$source = other.getSource();
        if (this$source == null ? other$source != null : !this$source.equals(other$source)) {
            return false;
        }
        List<FunctionParam> this$targets = this.getTargets();
        List<FunctionParam> other$targets = other.getTargets();
        if (this$targets == null ? other$targets != null : !((Object)this$targets).equals(other$targets)) {
            return false;
        }
        MultiValueCompareOperator this$compareOperator = this.getCompareOperator();
        MultiValueCompareOperator other$compareOperator = other.getCompareOperator();
        return !(this$compareOperator == null ? other$compareOperator != null : !this$compareOperator.equals(other$compareOperator));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof MultiValueFilterFunction;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        FunctionParam $source = this.getSource();
        result = result * 59 + ($source == null ? 43 : $source.hashCode());
        List<FunctionParam> $targets = this.getTargets();
        result = result * 59 + ($targets == null ? 43 : ((Object)$targets).hashCode());
        MultiValueCompareOperator $compareOperator = this.getCompareOperator();
        result = result * 59 + ($compareOperator == null ? 43 : $compareOperator.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "MultiValueFilterFunction(source=" + this.getSource() + ", targets=" + this.getTargets() + ", compareOperator=" + this.getCompareOperator() + ")";
    }

    public MultiValueFilterFunction() {
    }
}

