/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.protocol.node.format;

import java.util.HashMap;
import java.util.Map;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonIgnore;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonTypeName;
import org.apache.inlong.sort.protocol.node.format.Format;

@JsonTypeName(value="jsonFormat")
public class JsonFormat
implements Format {
    private static final long serialVersionUID = 1L;
    private static final String IDENTIFIER = "json";
    @JsonProperty(value="failOnMissingField", defaultValue="false")
    private Boolean failOnMissingField;
    @JsonProperty(value="ignoreParseErrors", defaultValue="true")
    private Boolean ignoreParseErrors;
    @JsonProperty(value="timestampFormatStandard", defaultValue="SQL")
    private String timestampFormatStandard;
    @JsonProperty(value="mapNullKeyMode", defaultValue="DROP")
    private String mapNullKeyMode;
    @JsonProperty(value="mapNullKeyLiteral", defaultValue="null")
    private String mapNullKeyLiteral;
    @JsonProperty(value="encodeDecimalAsPlainNumber", defaultValue="true")
    private Boolean encodeDecimalAsPlainNumber;

    @JsonCreator
    public JsonFormat(@JsonProperty(value="failOnMissingField", defaultValue="false") Boolean failOnMissingField, @JsonProperty(value="ignoreParseErrors", defaultValue="true") Boolean ignoreParseErrors, @JsonProperty(value="timestampFormatStandard", defaultValue="SQL") String timestampFormatStandard, @JsonProperty(value="mapNullKeyMode", defaultValue="DROP") String mapNullKeyMode, @JsonProperty(value="mapNullKeyLiteral", defaultValue="null") String mapNullKeyLiteral, @JsonProperty(value="encodeDecimalAsPlainNumber", defaultValue="true") Boolean encodeDecimalAsPlainNumber) {
        this.failOnMissingField = failOnMissingField;
        this.ignoreParseErrors = ignoreParseErrors;
        this.timestampFormatStandard = timestampFormatStandard;
        this.mapNullKeyMode = mapNullKeyMode;
        this.mapNullKeyLiteral = mapNullKeyLiteral;
        this.encodeDecimalAsPlainNumber = encodeDecimalAsPlainNumber;
    }

    @JsonCreator
    public JsonFormat() {
        this(false, true, "SQL", "DROP", "null", true);
    }

    @Override
    @JsonIgnore
    public String getFormat() {
        return IDENTIFIER;
    }

    @Override
    public String identifier() {
        return IDENTIFIER;
    }

    @Override
    public Map<String, String> generateOptions() {
        HashMap<String, String> options = new HashMap<String, String>(16);
        options.put("format", this.getFormat());
        if (this.failOnMissingField != null) {
            String failOnMissingField = this.failOnMissingField.toString();
            options.put("json.fail-on-missing-field", failOnMissingField);
        }
        if (this.ignoreParseErrors != null) {
            String ignoreParseErrors = this.ignoreParseErrors.toString();
            options.put("json.ignore-parse-errors", ignoreParseErrors);
        }
        options.put("json.timestamp-format.standard", this.timestampFormatStandard);
        options.put("json.map-null-key.mode", this.mapNullKeyMode);
        options.put("json.map-null-key.literal", this.mapNullKeyLiteral);
        if (this.encodeDecimalAsPlainNumber != null) {
            String encodeDecimalAsPlainNumber = this.encodeDecimalAsPlainNumber.toString();
            options.put("json.encode.decimal-as-plain-number", encodeDecimalAsPlainNumber);
        }
        return options;
    }

    public Boolean getFailOnMissingField() {
        return this.failOnMissingField;
    }

    public Boolean getIgnoreParseErrors() {
        return this.ignoreParseErrors;
    }

    public String getTimestampFormatStandard() {
        return this.timestampFormatStandard;
    }

    public String getMapNullKeyMode() {
        return this.mapNullKeyMode;
    }

    public String getMapNullKeyLiteral() {
        return this.mapNullKeyLiteral;
    }

    public Boolean getEncodeDecimalAsPlainNumber() {
        return this.encodeDecimalAsPlainNumber;
    }

    public void setFailOnMissingField(Boolean failOnMissingField) {
        this.failOnMissingField = failOnMissingField;
    }

    public void setIgnoreParseErrors(Boolean ignoreParseErrors) {
        this.ignoreParseErrors = ignoreParseErrors;
    }

    public void setTimestampFormatStandard(String timestampFormatStandard) {
        this.timestampFormatStandard = timestampFormatStandard;
    }

    public void setMapNullKeyMode(String mapNullKeyMode) {
        this.mapNullKeyMode = mapNullKeyMode;
    }

    public void setMapNullKeyLiteral(String mapNullKeyLiteral) {
        this.mapNullKeyLiteral = mapNullKeyLiteral;
    }

    public void setEncodeDecimalAsPlainNumber(Boolean encodeDecimalAsPlainNumber) {
        this.encodeDecimalAsPlainNumber = encodeDecimalAsPlainNumber;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JsonFormat)) {
            return false;
        }
        JsonFormat other = (JsonFormat)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$failOnMissingField = this.getFailOnMissingField();
        Boolean other$failOnMissingField = other.getFailOnMissingField();
        if (this$failOnMissingField == null ? other$failOnMissingField != null : !((Object)this$failOnMissingField).equals(other$failOnMissingField)) {
            return false;
        }
        Boolean this$ignoreParseErrors = this.getIgnoreParseErrors();
        Boolean other$ignoreParseErrors = other.getIgnoreParseErrors();
        if (this$ignoreParseErrors == null ? other$ignoreParseErrors != null : !((Object)this$ignoreParseErrors).equals(other$ignoreParseErrors)) {
            return false;
        }
        Boolean this$encodeDecimalAsPlainNumber = this.getEncodeDecimalAsPlainNumber();
        Boolean other$encodeDecimalAsPlainNumber = other.getEncodeDecimalAsPlainNumber();
        if (this$encodeDecimalAsPlainNumber == null ? other$encodeDecimalAsPlainNumber != null : !((Object)this$encodeDecimalAsPlainNumber).equals(other$encodeDecimalAsPlainNumber)) {
            return false;
        }
        String this$timestampFormatStandard = this.getTimestampFormatStandard();
        String other$timestampFormatStandard = other.getTimestampFormatStandard();
        if (this$timestampFormatStandard == null ? other$timestampFormatStandard != null : !this$timestampFormatStandard.equals(other$timestampFormatStandard)) {
            return false;
        }
        String this$mapNullKeyMode = this.getMapNullKeyMode();
        String other$mapNullKeyMode = other.getMapNullKeyMode();
        if (this$mapNullKeyMode == null ? other$mapNullKeyMode != null : !this$mapNullKeyMode.equals(other$mapNullKeyMode)) {
            return false;
        }
        String this$mapNullKeyLiteral = this.getMapNullKeyLiteral();
        String other$mapNullKeyLiteral = other.getMapNullKeyLiteral();
        return !(this$mapNullKeyLiteral == null ? other$mapNullKeyLiteral != null : !this$mapNullKeyLiteral.equals(other$mapNullKeyLiteral));
    }

    protected boolean canEqual(Object other) {
        return other instanceof JsonFormat;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $failOnMissingField = this.getFailOnMissingField();
        result = result * 59 + ($failOnMissingField == null ? 43 : ((Object)$failOnMissingField).hashCode());
        Boolean $ignoreParseErrors = this.getIgnoreParseErrors();
        result = result * 59 + ($ignoreParseErrors == null ? 43 : ((Object)$ignoreParseErrors).hashCode());
        Boolean $encodeDecimalAsPlainNumber = this.getEncodeDecimalAsPlainNumber();
        result = result * 59 + ($encodeDecimalAsPlainNumber == null ? 43 : ((Object)$encodeDecimalAsPlainNumber).hashCode());
        String $timestampFormatStandard = this.getTimestampFormatStandard();
        result = result * 59 + ($timestampFormatStandard == null ? 43 : $timestampFormatStandard.hashCode());
        String $mapNullKeyMode = this.getMapNullKeyMode();
        result = result * 59 + ($mapNullKeyMode == null ? 43 : $mapNullKeyMode.hashCode());
        String $mapNullKeyLiteral = this.getMapNullKeyLiteral();
        result = result * 59 + ($mapNullKeyLiteral == null ? 43 : $mapNullKeyLiteral.hashCode());
        return result;
    }

    public String toString() {
        return "JsonFormat(failOnMissingField=" + this.getFailOnMissingField() + ", ignoreParseErrors=" + this.getIgnoreParseErrors() + ", timestampFormatStandard=" + this.getTimestampFormatStandard() + ", mapNullKeyMode=" + this.getMapNullKeyMode() + ", mapNullKeyLiteral=" + this.getMapNullKeyLiteral() + ", encodeDecimalAsPlainNumber=" + this.getEncodeDecimalAsPlainNumber() + ")";
    }
}

