/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.protocol.node.extract;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonTypeName;
import org.apache.inlong.sort.protocol.FieldInfo;
import org.apache.inlong.sort.protocol.node.ExtractNode;

@JsonTypeName(value="fileSystemExtract")
public class FileSystemExtractNode
extends ExtractNode
implements Serializable {
    private static final long serialVersionUID = 1944524675510533454L;
    private static final String sourceMonitorInterval = "source.monitor-interval";
    @JsonProperty(value="format")
    @Nonnull
    private String format;
    @JsonProperty(value="path")
    @Nonnull
    private String path;
    @JsonProperty(value="name")
    private String name;

    @JsonCreator
    public FileSystemExtractNode(@JsonProperty(value="id") String id, @JsonProperty(value="name") String name, @JsonProperty(value="fields") List<FieldInfo> fields, @Nonnull @JsonProperty(value="path") String path, @Nonnull @JsonProperty(value="format") String format, @JsonProperty(value="properties") Map<String, String> properties) {
        super(id, name, fields, null, properties);
        this.format = (String)Preconditions.checkNotNull((Object)format, (Object)"format type is null");
        this.path = (String)Preconditions.checkNotNull((Object)path, (Object)"path is null");
        this.name = name;
    }

    @Override
    public Map<String, String> tableOptions() {
        Map<String, String> map = super.tableOptions();
        map.put("connector", "filesystem");
        map.put("path", this.path);
        map.put("format", this.format);
        if (null == this.getProperties() || !this.getProperties().containsKey(sourceMonitorInterval)) {
            map.put(sourceMonitorInterval, Duration.ofMinutes(1L).toString());
        }
        return map;
    }

    @Override
    public String genTableName() {
        return "node_" + super.getId() + "_" + this.name;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FileSystemExtractNode)) {
            return false;
        }
        FileSystemExtractNode other = (FileSystemExtractNode)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$format = this.getFormat();
        String other$format = other.getFormat();
        if (this$format == null ? other$format != null : !this$format.equals(other$format)) {
            return false;
        }
        String this$path = this.getPath();
        String other$path = other.getPath();
        if (this$path == null ? other$path != null : !this$path.equals(other$path)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        return !(this$name == null ? other$name != null : !this$name.equals(other$name));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof FileSystemExtractNode;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $format = this.getFormat();
        result = result * 59 + ($format == null ? 43 : $format.hashCode());
        String $path = this.getPath();
        result = result * 59 + ($path == null ? 43 : $path.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        return result;
    }

    @Nonnull
    public String getFormat() {
        return this.format;
    }

    @Nonnull
    public String getPath() {
        return this.path;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setFormat(@Nonnull String format) {
        if (format == null) {
            throw new NullPointerException("format is marked non-null but is null");
        }
        this.format = format;
    }

    public void setPath(@Nonnull String path) {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        this.path = path;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String toString() {
        return "FileSystemExtractNode(format=" + this.getFormat() + ", path=" + this.getPath() + ", name=" + this.getName() + ")";
    }
}

