/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sort.configuration;

import java.time.Duration;
import org.apache.inlong.sort.configuration.ConfigOption;
import org.apache.inlong.sort.configuration.ConfigOptions;

public class Constants {
    public static final long UNKNOWN_DATAFLOW_ID = -1L;
    public static final String SOURCE_TYPE_TUBE = "tubemq";
    public static final String SOURCE_TYPE_PULSAR = "pulsar";
    public static final String SOURCE_TYPE_TDMQ_PULSAR = "tdmq_pulsar";
    public static final String SINK_TYPE_CLICKHOUSE = "clickhouse";
    public static final String SINK_TYPE_DORIS = "doris";
    public static final String SINK_TYPE_HIVE = "hive";
    public static final String SINK_TYPE_ICEBERG = "iceberg";
    public static final String SINK_TYPE_KAFKA = "kafka";
    public static final String SINK_TYPE_HBASE = "hbase";
    public static final String SINK_TYPE_ES = "elasticsearch";
    public static final String METRIC_DATA_OUTPUT_TAG_ID = "metric_data_side_output";
    public static final int METRIC_AUDIT_ID_FOR_INPUT = 7;
    public static final int METRIC_AUDIT_ID_FOR_OUTPUT = 8;
    public static final String INLONG_GROUP_ID = "inlong.group.id";
    public static final String HIVE_SINK_PREFIX = "hive.sink.";
    public static final String HIVE_SINK_ORC_PREFIX = "hive.sink.orc.";
    public static final String GROUP_ID = "groupId";
    public static final String STREAM_ID = "streamId";
    public static final String NODE_ID = "nodeId";
    public static final String SOURCE_UID = "source_uid";
    public static final String DESERIALIZATION_SCHEMA_UID = "deserialization_schema_uid";
    public static final String TRANSFORMATION_UID = "transformation_uid";
    public static final String SINK_UID = "sink_uid";
    public static final String DATA_TIME_FIELD = "dt";
    public static final String PULSAR_SOURCE_PREFIX = "pulsar.source.";
    public static final String PIPELINE_NAME = "pipeline.name";
    public static final String TABLE_EXEC_SINK_UPSERT_MATERIALIZE = "table.exec.sink.upsert-materialize";
    public static final ConfigOption<String> UPSERT_MATERIALIZE = ConfigOptions.key("table.exec.sink.upsert-materialize").defaultValue("AUTO").withDescription("Because of the disorder of ChangeLog data caused by Shuffle in distributed system, the data received by Sink may not be the order of global upsert. So add upsert materialize operator before upsert sink. It receives the upstream changelog records and generate an upsert view for the downstream.\nBy default, the materialize operator will be added when a distributed disorder occurs on unique keys. You can also choose no materialization(NONE) or force materialization(FORCE).");
    public static final String TABLE_EXEC_SINK_NOT_NULL_ENFORCER = "table.exec.sink.not-null-enforcer";
    public static final ConfigOption<String> NOT_NULL_ENFORCER = ConfigOptions.key("table.exec.sink.not-null-enforcer").defaultValue("ERROR").withDescription("Determines how Flink enforces NOT NULL column constraints when inserting null values.\nPossible values:\n\"ERROR\": Throw a runtime exception when writing null values into NOT NULL column.\n\"DROP\": Drop records silently if a null value would have to be inserted into a NOT NULL column.");
    public static final ConfigOption<String> CLUSTER_ID = ConfigOptions.key("cluster-id").noDefaultValue().withDescription("The ID of the cluster, used to separate multiple clusters.");
    public static final ConfigOption<String> JOB_NAME = ConfigOptions.key("job.name").defaultValue("InLong-Sort-Job").withDescription("The job name of this job");
    public static final ConfigOption<String> ZOOKEEPER_QUORUM = ConfigOptions.key("zookeeper.quorum").noDefaultValue().withDescription("The ZooKeeper quorum to use");
    public static final ConfigOption<String> ZOOKEEPER_ROOT = ConfigOptions.key("zookeeper.path.root").defaultValue("/inlong-sort").withDescription("The root path in ZooKeeper.");
    public static final ConfigOption<Integer> ETL_RECORD_SERIALIZATION_BUFFER_SIZE = ConfigOptions.key("etl.record.serialization.buffer.size").defaultValue(1024);
    public static final ConfigOption<String> SOURCE_TYPE = ConfigOptions.key("source.type").noDefaultValue().withDescription("The type of source, currently only 'tubemq' is supported");
    public static final ConfigOption<String> SINK_TYPE = ConfigOptions.key("sink.type").noDefaultValue().withDescription("The type of sink, currently only 'clickhouse' and 'iceberg' are supported");
    public static final ConfigOption<Integer> SOURCE_PARALLELISM = ConfigOptions.key("source.parallelism").defaultValue(1);
    public static final ConfigOption<Integer> DESERIALIZATION_PARALLELISM = ConfigOptions.key("deserialization.parallelism").defaultValue(1);
    public static final ConfigOption<Integer> TRANSFORMATION_PARALLELISM = ConfigOptions.key("transformation.parallelism").defaultValue(1);
    public static final ConfigOption<Integer> SINK_PARALLELISM = ConfigOptions.key("sink.parallelism").defaultValue(1);
    public static final ConfigOption<Integer> COMMITTER_PARALLELISM = ConfigOptions.key("committer.parallelism").defaultValue(1);
    public static final ConfigOption<String> TUBE_MASTER_ADDRESS = ConfigOptions.key("tubemq.master.address").noDefaultValue().withDescription("The address of tubeMQ master.");
    public static final ConfigOption<String> TUBE_SESSION_KEY = ConfigOptions.key("tubemq.session.key").defaultValue("inlong-sort").withDescription("The session key of tubeMQ consumer.");
    public static final ConfigOption<Boolean> TUBE_BOOTSTRAP_FROM_MAX = ConfigOptions.key("tubemq.bootstrap.from.max").defaultValue(false).withDescription("Consume tubeMQ from max offset.");
    public static final ConfigOption<String> TUBE_MESSAGE_NOT_FOUND_WAIT_PERIOD = ConfigOptions.key("tubemq.message.not.found.wait.period").defaultValue("350ms").withDescription("The time of waiting period if tubeMQ broker return message not found.");
    public static final ConfigOption<Long> TUBE_SUBSCRIBE_RETRY_TIMEOUT = ConfigOptions.key("tubemq.subscribe.retry.timeout").defaultValue(300000L).withDescription("The time of subscribing tubeMQ timeout, in millisecond");
    public static final ConfigOption<Integer> SOURCE_EVENT_QUEUE_CAPACITY = ConfigOptions.key("source.event.queue.capacity").defaultValue(1024);
    public static final ConfigOption<Integer> ZOOKEEPER_SESSION_TIMEOUT = ConfigOptions.key("zookeeper.client.session-timeout").defaultValue(60000).withDescription("Defines the session timeout for the ZooKeeper session in ms.");
    public static final ConfigOption<Integer> ZOOKEEPER_CONNECTION_TIMEOUT = ConfigOptions.key("zookeeper.client.connection-timeout").defaultValue(15000).withDescription("Defines the connection timeout for ZooKeeper in ms.");
    public static final ConfigOption<Integer> ZOOKEEPER_RETRY_WAIT = ConfigOptions.key("zookeeper.client.retry-wait").defaultValue(5000).withDescription("Defines the pause between consecutive retries in ms.");
    public static final ConfigOption<Integer> ZOOKEEPER_MAX_RETRY_ATTEMPTS = ConfigOptions.key("zookeeper.client.max-retry-attempts").defaultValue(3).withDescription("Defines the number of connection retries before the client gives up.");
    public static final ConfigOption<String> ZOOKEEPER_CLIENT_ACL = ConfigOptions.key("zookeeper.client.acl").defaultValue("open").withDescription("Defines the ACL (open|creator) to be configured on ZK node. The configuration value can be set to \u201ccreator\u201d if the ZooKeeper server configuration has the \u201cauthProvider\u201d property mapped to use SASLAuthenticationProvider and the cluster is configured to run in secure mode (Kerberos).");
    public static final ConfigOption<Boolean> ZOOKEEPER_SASL_DISABLE = ConfigOptions.key("zookeeper.sasl.disable").defaultValue(false);
    public static final ConfigOption<Boolean> SINK_FIELD_TYPE_STRING_NULLABLE = ConfigOptions.key("sink.field.type.string.nullable").defaultValue(false).withDescription("The default value of string is empty string.");
    public static final ConfigOption<Boolean> SINK_FIELD_TYPE_INT_NULLABLE = ConfigOptions.key("sink.field.type.int.nullable").defaultValue(true);
    public static final ConfigOption<Boolean> SINK_FIELD_TYPE_SHORT_NULLABLE = ConfigOptions.key("sink.field.type.short.nullable").defaultValue(true);
    public static final ConfigOption<Boolean> SINK_FIELD_TYPE_LONG_NULLABLE = ConfigOptions.key("sink.field.type.long.nullable").defaultValue(true);
    public static final ConfigOption<Integer> SINK_KAFKA_PRODUCER_POOL_SIZE = ConfigOptions.key("sink.kafka.producer.pool.size").defaultValue(5);
    public static final ConfigOption<Integer> SINK_HIVE_COMMITTED_PARTITIONS_CACHE_SIZE = ConfigOptions.key("sink.hive.committed.partitions.cache.size").defaultValue(1024);
    public static final ConfigOption<Long> SINK_HIVE_ROLLING_POLICY_FILE_SIZE = ConfigOptions.key("sink.hive.rolling-policy.file-size").defaultValue(0x8000000L).withDescription("The maximum part file size before rolling.");
    public static final ConfigOption<Long> SINK_HIVE_ROLLING_POLICY_ROLLOVER_INTERVAL = ConfigOptions.key("sink.hive.rolling-policy.rollover-interval").defaultValue(Duration.ofMinutes(30L).toMillis()).withDescription("The maximum time duration a part file can stay open before rolling (by default long enough to avoid too many small files). The frequency at which this is checked is controlled by the 'sink.rolling-policy.check-interval' option.");
    public static final ConfigOption<Long> SINK_HIVE_ROLLING_POLICY_CHECK_INTERVAL = ConfigOptions.key("sink.hive.rolling-policy.check-interval").defaultValue(Duration.ofMinutes(1L).toMillis()).withDescription("The interval for checking time based rolling policies. This controls the frequency to check whether a part file should rollover based on 'sink.rolling-policy.rollover-interval'.");
    public static final ConfigOption<Integer> SINK_HIVE_TEXT_BUFFER_SIZE = ConfigOptions.key("sink.hive.text.buffer.size").defaultValue(262144).withDescription("Buffer size of Hive/THive sink text format (with compression or not), default size is 256KB");
    public static final ConfigOption<Integer> CHECKPOINT_INTERVAL_MS = ConfigOptions.key("checkpoint.interval").defaultValue(600000).withDescription("The interval between tow checkpoints");
    public static final ConfigOption<Integer> MIN_PAUSE_BETWEEN_CHECKPOINTS_MS = ConfigOptions.key("min.pause.between.checkpoints.ms").defaultValue(500);
    public static final ConfigOption<Integer> CHECKPOINT_TIMEOUT_MS = ConfigOptions.key("checkpoint.timeout.ms").defaultValue(600000);
    public static final ConfigOption<String> RUNTIME_EXECUTION_MODE = ConfigOptions.key("runtime.execution.mode").defaultValue("stream").withDescription("The runtime execution mode of Flink, including stream and batch, default is stream");
    public static final ConfigOption<String> SOURCE_BOUNDARY_TYPE = ConfigOptions.key("source.boundary.type").defaultValue("time").withDescription("The type of source boundary");
    public static final ConfigOption<String> SOURCE_LOWER_BOUNDARY = ConfigOptions.key("source.lower.boundary").defaultValue("0").withDescription("The lower bound of source");
    public static final ConfigOption<String> SOURCE_UPPER_BOUNDARY = ConfigOptions.key("source.upper.boundary").defaultValue("0").withDescription("The upper bound of source");
    public static final ConfigOption<Boolean> METRICS_ENABLE_OUTPUT = ConfigOptions.key("metrics.enable.output").defaultValue(true);
    public static final ConfigOption<Integer> METRICS_TIMESTAMP_WATERMARK_ASSIGNER_PARALLELISM = ConfigOptions.key("metrics.timestamp.watermark.assigner.parallelism").defaultValue(1);
    public static final ConfigOption<Integer> METRICS_AGGREGATOR_PARALLELISM = ConfigOptions.key("metrics.aggregator.parallelism").defaultValue(1);
    public static final ConfigOption<Integer> METRICS_SINK_PARALLELISM = ConfigOptions.key("metrics.sink.parallelism").defaultValue(1).withDeprecatedKeys("metrics.mysql.sink.parallelism");
    public static final String METRICS_TIMESTAMP_AND_WATERMARK_ASSIGNER_UID = "metrics_timestamp_and_watermark_assigner_uid";
    public static final String METRICS_AGGREGATOR_UID = "metrics_aggregator_uid";
    public static final String METRICS_SINK_UID = "metrics_sink_uid";
    public static final ConfigOption<Integer> METRICS_AGGREGATOR_WINDOW_SIZE = ConfigOptions.key("metrics.aggregator.window.size").defaultValue(5).withDescription("minutes");
    public static final ConfigOption<String> METRICS_LABELS = ConfigOptions.key("inlong.metric.labels").noDefaultValue().withDescription("INLONG metric labels, format is 'key1=value1&key2=value2',default is 'groupId=xxx&streamId=xxx&nodeId=xxx'");
    public static final ConfigOption<String> METRICS_AUDIT_PROXY_HOSTS = ConfigOptions.key("metrics.audit.proxy.hosts").noDefaultValue().withDescription("Audit proxy host address for reporting audit metrics. \ne.g. 127.0.0.1:10081,0.0.0.1:10081");
    public static final ConfigOption<String> DATAFLOW_INFO_FILE = ConfigOptions.key("dataflow.info.file").noDefaultValue().withDescription("The file which contains dataflow info for a single tenant job");
    public static final ConfigOption<Boolean> JOB_ORDERLY_OUTPUT = ConfigOptions.key("job.orderly.output").defaultValue(false).withDescription("Whether to ensure orderly output or not");
    public static final ConfigOption<Integer> ORC_SINK_BATCH_SIZE = ConfigOptions.key("hive.sink.orc.row.batch.size").defaultValue(64);
    public static final String CHDFS_CONFIG_PREFIX = "fs.ofs.";
    public static final ConfigOption<Boolean> DATASYNC = ConfigOptions.key("datasync").defaultValue(false).withDescription("Whether to datasync or not");
    public static final ConfigOption<String> GROUP_INFO_FILE = ConfigOptions.key("group.info.file").noDefaultValue().withDescription("The file which contains group info for a single tenant job");
    public static final ConfigOption<String> SQL_SCRIPT_FILE = ConfigOptions.key("sql.script.file").noDefaultValue().withDescription("The file which is sql script and contains multi statement");
    public static final ConfigOption<Boolean> ENABLE_LOG_REPORT = ConfigOptions.key("enable.log.report").defaultValue(false).withDescription("Whether to enable openTelemetry log report or not");

    public static enum CompressionType {
        NONE,
        GZIP,
        LZO;

    }
}

