/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.agent.core;

import io.netty.util.concurrent.DefaultThreadFactory;
import java.util.concurrent.ThreadFactory;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.agent.common.AbstractDaemon;
import org.apache.inlong.agent.conf.AgentConfiguration;
import org.apache.inlong.agent.constant.CommonConstants;
import org.apache.inlong.agent.core.AgentManager;
import org.apache.inlong.agent.core.AgentStatusManager;
import org.apache.inlong.agent.core.FileStaticManager;
import org.apache.inlong.agent.core.task.MemoryManager;
import org.apache.inlong.agent.utils.AgentUtils;
import org.apache.inlong.agent.utils.HttpManager;
import org.apache.inlong.agent.utils.ThreadUtils;
import org.apache.inlong.common.enums.ComponentTypeEnum;
import org.apache.inlong.common.enums.NodeSrvStatus;
import org.apache.inlong.common.heartbeat.AbstractHeartbeatManager;
import org.apache.inlong.common.heartbeat.HeartbeatMsg;
import org.apache.inlong.sdk.dataproxy.common.ProcessResult;
import org.apache.inlong.sdk.dataproxy.exception.ProxySdkException;
import org.apache.inlong.sdk.dataproxy.sender.tcp.InLongTcpMsgSender;
import org.apache.inlong.sdk.dataproxy.sender.tcp.TcpMsgSender;
import org.apache.inlong.sdk.dataproxy.sender.tcp.TcpMsgSenderConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HeartbeatManager
extends AbstractDaemon
implements AbstractHeartbeatManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(HeartbeatManager.class);
    public static final int PRINT_MEMORY_PERMIT_INTERVAL_SECOND = 60;
    public static final int HEARTBEAT_INTERVAL_SECOND = 60;
    public static final String INLONG_AGENT_SYSTEM = "inlong_agent_system";
    private static HeartbeatManager heartbeatManager = null;
    private final AgentConfiguration conf = AgentConfiguration.getAgentConf();
    private final HttpManager httpManager = new HttpManager(this.conf);
    private final String baseManagerUrl = this.httpManager.getBaseUrl();
    private final String reportHeartbeatUrl = this.buildReportHeartbeatUrl(this.baseManagerUrl);
    private TcpMsgSender sender;

    private HeartbeatManager(AgentManager agentManager) {
        this.createMessageSender();
        AgentStatusManager.init(agentManager);
        FileStaticManager.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static HeartbeatManager getInstance(AgentManager agentManager) {
        if (heartbeatManager != null) return heartbeatManager;
        Class<HeartbeatManager> clazz = HeartbeatManager.class;
        synchronized (HeartbeatManager.class) {
            if (heartbeatManager != null) return heartbeatManager;
            heartbeatManager = new HeartbeatManager(agentManager);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return heartbeatManager;
        }
    }

    public static HeartbeatManager getInstance() {
        if (heartbeatManager == null) {
            throw new RuntimeException("HeartbeatManager has not been initialized by agentManager");
        }
        return heartbeatManager;
    }

    public void start() throws Exception {
        this.submitWorker(this.heartbeatReportThread());
        this.submitWorker(this.printMemoryPermitThread());
    }

    private Runnable printMemoryPermitThread() {
        return () -> {
            Thread.currentThread().setName("heartBeat-printMemoryPermit");
            while (this.isRunnable()) {
                MemoryManager.getInstance().printAll();
                AgentUtils.silenceSleepInSeconds((long)60L);
            }
        };
    }

    private Runnable heartbeatReportThread() {
        return () -> {
            Thread.currentThread().setName("heartBeat-heartbeatReportThread");
            while (this.isRunnable()) {
                try {
                    HeartbeatMsg heartbeatMsg = this.buildHeartbeatMsg();
                    this.reportHeartbeat(heartbeatMsg);
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug(" {} report heartbeat to manager", (Object)heartbeatMsg);
                    }
                    if (this.sender == null) {
                        this.createMessageSender();
                    }
                    AgentStatusManager.sendStatusMsg(this.sender);
                    FileStaticManager.sendStaticMsg(this.sender);
                }
                catch (Throwable e) {
                    LOGGER.error("interrupted while report heartbeat", e);
                    ThreadUtils.threadThrowableHandler((Thread)Thread.currentThread(), (Throwable)e);
                }
                finally {
                    AgentUtils.silenceSleepInSeconds((long)60L);
                }
            }
        };
    }

    public void stop() throws Exception {
        this.waitForTerminate();
    }

    public void reportHeartbeat(HeartbeatMsg heartbeat) {
        this.httpManager.doSentPost(this.reportHeartbeatUrl, (Object)heartbeat);
    }

    private HeartbeatMsg buildHeartbeatMsg() {
        String agentIp = this.conf.get("agent.local.ip");
        String clusterName = this.conf.get("agent.cluster.name");
        String clusterTag = this.conf.get("agent.cluster.tag");
        String inCharges = this.conf.get("agent.cluster.inCharges");
        String nodeGroup = this.conf.get("agent.node.group");
        HeartbeatMsg heartbeatMsg = new HeartbeatMsg();
        heartbeatMsg.setIp(agentIp);
        heartbeatMsg.setComponentType(ComponentTypeEnum.Agent.getType());
        heartbeatMsg.setReportTime(Long.valueOf(System.currentTimeMillis()));
        if (StringUtils.isNotBlank((CharSequence)clusterName)) {
            heartbeatMsg.setClusterName(clusterName);
        }
        if (StringUtils.isNotBlank((CharSequence)clusterTag)) {
            heartbeatMsg.setClusterTag(clusterTag);
        }
        if (StringUtils.isNotBlank((CharSequence)inCharges)) {
            heartbeatMsg.setInCharges(inCharges);
        }
        if (StringUtils.isNotBlank((CharSequence)nodeGroup)) {
            heartbeatMsg.setNodeGroup(nodeGroup);
        }
        return heartbeatMsg;
    }

    private HeartbeatMsg buildDeadHeartbeatMsg() {
        HeartbeatMsg heartbeatMsg = new HeartbeatMsg();
        heartbeatMsg.setNodeSrvStatus(NodeSrvStatus.SERVICE_UNINSTALL);
        heartbeatMsg.setInCharges(this.conf.get("agent.cluster.inCharges"));
        heartbeatMsg.setIp(AgentUtils.fetchLocalIp());
        heartbeatMsg.setComponentType(ComponentTypeEnum.Agent.getType());
        heartbeatMsg.setClusterName(this.conf.get("agent.cluster.name"));
        heartbeatMsg.setClusterTag(this.conf.get("agent.cluster.tag"));
        return heartbeatMsg;
    }

    private String buildReportHeartbeatUrl(String baseUrl) {
        return baseUrl + this.conf.get("heartbeat.http.path", "/heartbeat/report");
    }

    private void createMessageSender() {
        String managerAddr = this.conf.get("agent.manager.addr");
        String authSecretId = this.conf.get("agent.manager.auth.secretId");
        String authSecretKey = this.conf.get("agent.manager.auth.secretKey");
        try {
            TcpMsgSenderConfig proxyClientConfig = new TcpMsgSenderConfig(managerAddr, INLONG_AGENT_SYSTEM, authSecretId, authSecretKey);
            proxyClientConfig.setMaxInFlightSizeInKb(204800);
            proxyClientConfig.setAliveConnections(10);
            proxyClientConfig.setNettyWorkerThreadNum(CommonConstants.DEFAULT_PROXY_CLIENT_IO_THREAD_NUM);
            proxyClientConfig.setRequestTimeoutMs(30000L);
            DefaultThreadFactory SHARED_FACTORY = new DefaultThreadFactory("agent-sender-manager-heartbeat", Thread.currentThread().isDaemon());
            this.sender = new InLongTcpMsgSender(proxyClientConfig, (ThreadFactory)SHARED_FACTORY);
            ProcessResult procResult = new ProcessResult();
            if (!this.sender.start(procResult)) {
                this.sender.close();
                throw new ProxySdkException("Sender start failure, " + procResult);
            }
        }
        catch (Throwable ex) {
            LOGGER.error("heartbeat manager create sdk failed: ", ex);
        }
    }
}

