/*
 * Decompiled with CFR 0.152.
 */
package org.apache.toree.communication.socket;

import java.io.Serializable;
import java.util.Collection;
import org.apache.toree.communication.socket.Bind;
import org.apache.toree.communication.socket.Connect;
import org.apache.toree.communication.socket.Identity;
import org.apache.toree.communication.socket.Linger;
import org.apache.toree.communication.socket.SocketOption;
import org.apache.toree.communication.socket.SocketRunnable;
import org.apache.toree.communication.socket.SocketType;
import org.apache.toree.communication.socket.Subscribe;
import org.apache.toree.utils.LogLike;
import org.slf4j.Logger;
import org.zeromq.ZMQ;
import org.zeromq.ZMsg;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\u00055d\u0001\u0002\r\u001a\u0001\u0011B\u0001\"\u000e\u0001\u0003\u0006\u0004%IA\u000e\u0005\t\u000b\u0002\u0011\t\u0011)A\u0005o!Aa\t\u0001BC\u0002\u0013%q\t\u0003\u0005L\u0001\t\u0005\t\u0015!\u0003I\u0011!a\u0005A!b\u0001\n\u0013i\u0005\u0002C5\u0001\u0005\u0003\u0005\u000b\u0011\u0002(\t\u0011)\u0004!Q1A\u0005\n-D\u0001B\u001d\u0001\u0003\u0002\u0003\u0006I\u0001\u001c\u0005\u0006g\u0002!\t\u0001\u001e\u0005\bu\u0002\u0001\r\u0011\"\u0003|\u0011!y\b\u00011A\u0005\n\u0005\u0005\u0001bBA\u0004\u0001\u0001\u0006K\u0001 \u0005\t\u0003#\u0001\u0001\u0019!C\u0005w\"I\u00111\u0003\u0001A\u0002\u0013%\u0011Q\u0003\u0005\b\u00033\u0001\u0001\u0015)\u0003}\u0011\u0019\ti\u0002\u0001C!w\"9\u0011q\u0004\u0001\u0005\u0012\u0005\u0005\u0002bBA\u0017\u0001\u0011E\u0011q\u0006\u0005\b\u0003g\u0001A\u0011CA\u001b\u0011%\t\u0019\u0005AI\u0001\n#\t)\u0005C\u0004\u0002\\\u0001!\t\"!\u0018\t\u000f\u0005\u001d\u0004\u0001\"\u0011\u0002j!9\u00111\u000e\u0001\u0005B\u0005%$\u0001\u0006.fe>l\u0015kU8dW\u0016$(+\u001e8oC\ndWM\u0003\u0002\u001b7\u000511o\\2lKRT!\u0001H\u000f\u0002\u001b\r|W.\\;oS\u000e\fG/[8o\u0015\tqr$A\u0003u_J,WM\u0003\u0002!C\u00051\u0011\r]1dQ\u0016T\u0011AI\u0001\u0004_J<7\u0001A\n\u0004\u0001\u0015z\u0003c\u0001\u0014(S5\t\u0011$\u0003\u0002)3\tq1k\\2lKR\u0014VO\u001c8bE2,\u0007C\u0001\u0016.\u001b\u0005Y#B\u0001\u0017\"\u0003\u0019QXM]8nc&\u0011af\u000b\u0002\u000556\u001bx\r\u0005\u00021g5\t\u0011G\u0003\u00023;\u0005)Q\u000f^5mg&\u0011A'\r\u0002\b\u0019><G*[6f\u0003\u001d\u0019wN\u001c;fqR,\u0012a\u000e\t\u0003q\ts!!\u000f!\u000f\u0005izdBA\u001e?\u001b\u0005a$BA\u001f$\u0003\u0019a$o\\8u}%\t!%\u0003\u0002-C%\u0011\u0011iK\u0001\u000456\u000b\u0016BA\"E\u0005\u001d\u0019uN\u001c;fqRT!!Q\u0016\u0002\u0011\r|g\u000e^3yi\u0002\n!b]8dW\u0016$H+\u001f9f+\u0005A\u0005C\u0001\u0014J\u0013\tQ\u0015D\u0001\u0006T_\u000e\\W\r\u001e+za\u0016\f1b]8dW\u0016$H+\u001f9fA\u00051\u0012N\u001c2pk:$W*Z:tC\u001e,7)\u00197mE\u0006\u001c7.F\u0001O!\ry%\u000bV\u0007\u0002!*\t\u0011+A\u0003tG\u0006d\u0017-\u0003\u0002T!\n1q\n\u001d;j_:\u0004BaT+XM&\u0011a\u000b\u0015\u0002\n\rVt7\r^5p]F\u00022\u0001W/a\u001d\tI6L\u0004\u0002<5&\t\u0011+\u0003\u0002]!\u00069\u0001/Y2lC\u001e,\u0017B\u00010`\u0005\r\u0019V-\u001d\u0006\u00039B\u00032aT1d\u0013\t\u0011\u0007KA\u0003BeJ\f\u0017\u0010\u0005\u0002PI&\u0011Q\r\u0015\u0002\u0005\u0005f$X\r\u0005\u0002PO&\u0011\u0001\u000e\u0015\u0002\u0005+:LG/A\fj]\n|WO\u001c3NKN\u001c\u0018mZ3DC2d'-Y2lA\u0005i1o\\2lKR|\u0005\u000f^5p]N,\u0012\u0001\u001c\t\u0004\u001f6|\u0017B\u00018Q\u0005)a$/\u001a9fCR,GM\u0010\t\u0003MAL!!]\r\u0003\u0019M{7m[3u\u001fB$\u0018n\u001c8\u0002\u001dM|7m[3u\u001fB$\u0018n\u001c8tA\u00051A(\u001b8jiz\"R!\u001e<xqf\u0004\"A\n\u0001\t\u000bUJ\u0001\u0019A\u001c\t\u000b\u0019K\u0001\u0019\u0001%\t\u000b1K\u0001\u0019\u0001(\t\u000b)L\u0001\u0019\u00017\u0002\u00139|Go\u00117pg\u0016$W#\u0001?\u0011\u0005=k\u0018B\u0001@Q\u0005\u001d\u0011un\u001c7fC:\fQB\\8u\u00072|7/\u001a3`I\u0015\fHc\u00014\u0002\u0004!A\u0011QA\u0006\u0002\u0002\u0003\u0007A0A\u0002yIE\n!B\\8u\u00072|7/\u001a3!Q\ra\u00111\u0002\t\u0004\u001f\u00065\u0011bAA\b!\nAao\u001c7bi&dW-A\u0007`SN\u0004&o\\2fgNLgnZ\u0001\u0012?&\u001c\bK]8dKN\u001c\u0018N\\4`I\u0015\fHc\u00014\u0002\u0018!A\u0011Q\u0001\b\u0002\u0002\u0003\u0007A0\u0001\b`SN\u0004&o\\2fgNLgn\u001a\u0011)\u0007=\tY!\u0001\u0007jgB\u0013xnY3tg&tw-\u0001\bqe>\u001cWm]:PaRLwN\\:\u0015\u0007\u0019\f\u0019\u0003\u0003\u0004\u001b#\u0001\u0007\u0011Q\u0005\t\u0005\u0003O\tIC\u0004\u0002+\u0001&\u0019\u00111\u0006#\u0003\rM{7m[3u\u0003i\u0001(o\\2fgNtU\r\u001f;PkR\u0014w.\u001e8e\u001b\u0016\u001c8/Y4f)\ra\u0018\u0011\u0007\u0005\u00075I\u0001\r!!\n\u00023A\u0014xnY3tg:+\u0007\u0010^%oE>,h\u000eZ'fgN\fw-\u001a\u000b\u0006M\u0006]\u0012\u0011\b\u0005\u00075M\u0001\r!!\n\t\u0013\u0005m2\u0003%AA\u0002\u0005u\u0012!\u00024mC\u001e\u001c\bcA(\u0002@%\u0019\u0011\u0011\t)\u0003\u0007%sG/A\u0012qe>\u001cWm]:OKb$\u0018J\u001c2pk:$W*Z:tC\u001e,G\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\u0005\u001d#\u0006BA\u001f\u0003\u0013Z#!a\u0013\u0011\t\u00055\u0013qK\u0007\u0003\u0003\u001fRA!!\u0015\u0002T\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003+\u0002\u0016AC1o]>$\u0018\r^5p]&!\u0011\u0011LA(\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\r]\u0016<(,\\9T_\u000e\\W\r\u001e\u000b\u0007\u0003K\ty&!\u001a\t\u000f\u0005\u0005T\u00031\u0001\u0002d\u0005Q!0\\9D_:$X\r\u001f;\u0011\u0007\u0005\u001d\"\t\u0003\u0004G+\u0001\u0007\u0011QH\u0001\u0004eVtG#\u00014\u0002\u000b\rdwn]3")
public class ZeroMQSocketRunnable
extends SocketRunnable<ZMsg>
implements LogLike {
    private final ZMQ.Context context;
    private final SocketType socketType;
    private final Option<Function1<Seq<byte[]>, BoxedUnit>> inboundMessageCallback;
    private final Seq<SocketOption> socketOptions;
    private volatile boolean notClosed;
    private volatile boolean _isProcessing;
    private final String loggerName;
    private final Logger logger;

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    @Override
    public Logger logger() {
        return this.logger;
    }

    @Override
    public void org$apache$toree$utils$LogLike$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    @Override
    public void org$apache$toree$utils$LogLike$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    private ZMQ.Context context() {
        return this.context;
    }

    private SocketType socketType() {
        return this.socketType;
    }

    private Option<Function1<Seq<byte[]>, BoxedUnit>> inboundMessageCallback() {
        return this.inboundMessageCallback;
    }

    private Seq<SocketOption> socketOptions() {
        return this.socketOptions;
    }

    private boolean notClosed() {
        return this.notClosed;
    }

    private void notClosed_$eq(boolean x$1) {
        this.notClosed = x$1;
    }

    private boolean _isProcessing() {
        return this._isProcessing;
    }

    private void _isProcessing_$eq(boolean x$1) {
        this._isProcessing = x$1;
    }

    @Override
    public boolean isProcessing() {
        return this._isProcessing();
    }

    public void processOptions(ZMQ.Socket socket) {
        String socketOptionsString = ((TraversableOnce)this.socketOptions().map((Function1 & Serializable & scala.Serializable)x$1 -> new StringBuilder(3).append("\n- ").append(x$1.toString()).toString(), Seq$.MODULE$.canBuildFrom())).mkString("");
        this.logger().trace(new StringBuilder(32).append("Processing options for socket ").append(this.socketType()).append(": ").append(socketOptionsString).toString());
        Tuple2 tuple2 = this.socketOptions().partition((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ZeroMQSocketRunnable.$anonfun$processOptions$2(x0$1)));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Seq connectionOptions = (Seq)tuple2._1();
        Seq otherOptions = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)connectionOptions, (Object)otherOptions);
        Tuple2 tuple23 = tuple22;
        Seq connectionOptions2 = (Seq)tuple23._1();
        Seq otherOptions2 = (Seq)tuple23._2();
        otherOptions2.foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Boolean bl;
            SocketOption socketOption = x0$2;
            if (socketOption instanceof Linger) {
                Linger linger = (Linger)socketOption;
                int milliseconds = linger.milliseconds();
                bl = BoxesRunTime.boxToBoolean((boolean)socket.setLinger(milliseconds));
            } else if (socketOption instanceof Subscribe) {
                Subscribe subscribe = (Subscribe)socketOption;
                byte[] topic = subscribe.topic();
                bl = BoxesRunTime.boxToBoolean((boolean)socket.subscribe(topic));
            } else if (socketOption instanceof Identity) {
                Identity identity = (Identity)socketOption;
                byte[] identity2 = identity.identity();
                bl = BoxesRunTime.boxToBoolean((boolean)socket.setIdentity(identity2));
            } else {
                this.logger().warn(new StringBuilder(16).append("Unknown option: ").append(socketOption).toString());
                bl = BoxedUnit.UNIT;
            }
            return bl;
        });
        connectionOptions2.foreach((Function1 & Serializable & scala.Serializable)x0$3 -> {
            Boolean bl;
            SocketOption socketOption = x0$3;
            if (socketOption instanceof Bind) {
                Bind bind2 = (Bind)socketOption;
                String address = bind2.address();
                bl = BoxesRunTime.boxToBoolean((boolean)socket.bind(address));
            } else if (socketOption instanceof Connect) {
                Connect connect = (Connect)socketOption;
                String address = connect.address();
                bl = BoxesRunTime.boxToBoolean((boolean)socket.connect(address));
            } else {
                this.logger().warn(new StringBuilder(27).append("Unknown connection option: ").append(socketOption).toString());
                bl = BoxedUnit.UNIT;
            }
            return bl;
        });
        this._isProcessing_$eq(true);
    }

    public boolean processNextOutboundMessage(ZMQ.Socket socket) {
        Option message = Option$.MODULE$.apply(this.outboundMessages().poll());
        message.foreach((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.send(socket)));
        return message.nonEmpty();
    }

    public void processNextInboundMessage(ZMQ.Socket socket, int flags) {
        Option$.MODULE$.apply((Object)ZMsg.recvMsg(socket, flags)).foreach((Function1 & Serializable & scala.Serializable)zMsg -> {
            ZeroMQSocketRunnable.$anonfun$processNextInboundMessage$1(this, zMsg);
            return BoxedUnit.UNIT;
        });
    }

    public int processNextInboundMessage$default$2() {
        return 1;
    }

    public ZMQ.Socket newZmqSocket(ZMQ.Context zmqContext, int socketType) {
        return zmqContext.socket(socketType);
    }

    @Override
    public void run() {
        ZMQ.Socket socket = this.newZmqSocket(this.context(), this.socketType().type());
        try {
            try {
                this.processOptions(socket);
                while (this.notClosed()) {
                    Try$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> this.processNextOutboundMessage(socket)).failed().foreach((Function1 & Serializable & scala.Serializable)x$5 -> {
                        ZeroMQSocketRunnable.$anonfun$run$2(this, x$5);
                        return BoxedUnit.UNIT;
                    });
                    Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.processNextInboundMessage(socket, this.processNextInboundMessage$default$2())).failed().foreach((Function1 & Serializable & scala.Serializable)e -> {
                        ZeroMQSocketRunnable.$anonfun$run$4(this, e);
                        return BoxedUnit.UNIT;
                    });
                    Thread.sleep(1L);
                }
            }
            catch (Exception ex) {
                this.logger().error("Unexpected exception in 0mq socket runnable!", ex);
            }
        }
        finally {
            try {
                socket.close();
            }
            catch (Exception ex) {
                Function1 & Serializable & scala.Serializable cfr_ignored_0 = (Function1 & Serializable & scala.Serializable)x$6 -> {
                    ZeroMQSocketRunnable.$anonfun$run$5(this, x$6);
                    return BoxedUnit.UNIT;
                };
            }
        }
    }

    @Override
    public void close() {
        Predef$.MODULE$.assert(this._isProcessing() && this.notClosed(), (Function0 & Serializable & scala.Serializable)() -> "Runnable is not processing or is closed!");
        this._isProcessing_$eq(false);
        this.notClosed_$eq(false);
    }

    public static final /* synthetic */ boolean $anonfun$new$1(SocketOption x0$1) {
        SocketOption socketOption = x0$1;
        boolean bl = socketOption instanceof Bind ? true : socketOption instanceof Connect;
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$processOptions$2(SocketOption x0$1) {
        SocketOption socketOption = x0$1;
        boolean bl = socketOption instanceof Bind ? true : socketOption instanceof Connect;
        boolean bl2 = bl;
        return bl2;
    }

    public static final /* synthetic */ void $anonfun$processNextInboundMessage$1(ZeroMQSocketRunnable $this, ZMsg zMsg) {
        $this.inboundMessageCallback().foreach((Function1 & Serializable & scala.Serializable)x$4 -> {
            x$4.apply(((TraversableOnce)JavaConverters$.MODULE$.collectionAsScalaIterableConverter((Collection)zMsg).asScala()).toSeq().map((Function1 & Serializable & scala.Serializable)zFrame -> zFrame.getData(), Seq$.MODULE$.canBuildFrom()));
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$run$2(ZeroMQSocketRunnable $this, Throwable x$5) {
        $this.logger().error("Failed to send next outgoing message!", x$5);
    }

    public static final /* synthetic */ void $anonfun$run$4(ZeroMQSocketRunnable $this, Throwable e) {
        Throwable throwable2 = e;
        if (throwable2 instanceof IllegalStateException) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            $this.logger().error("Failed to retrieve next incoming message!", e);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public static final /* synthetic */ void $anonfun$run$5(ZeroMQSocketRunnable $this, Throwable x$6) {
        $this.logger().error("Failed to close socket!", x$6);
    }

    public ZeroMQSocketRunnable(ZMQ.Context context, SocketType socketType, Option<Function1<Seq<byte[]>, BoxedUnit>> inboundMessageCallback, Seq<SocketOption> socketOptions) {
        this.context = context;
        this.socketType = socketType;
        this.inboundMessageCallback = inboundMessageCallback;
        this.socketOptions = socketOptions;
        super(inboundMessageCallback);
        LogLike.$init$(this);
        Predef$.MODULE$.require(socketOptions.count((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ZeroMQSocketRunnable.$anonfun$new$1(x0$1))) == 1, (Function0 & Serializable & scala.Serializable)() -> "ZeroMQ socket needs exactly one bind or connect!");
        this.notClosed = true;
        this._isProcessing = false;
    }
}

