/*
 * Decompiled with CFR 0.152.
 */
package zmq.io.coder;

import java.nio.ByteBuffer;
import zmq.Msg;
import zmq.io.coder.IDecoder;
import zmq.util.Errno;
import zmq.util.ValueReference;

public abstract class DecoderBase
implements IDecoder {
    private ByteBuffer readPos = null;
    private boolean zeroCopy;
    private int toRead = 0;
    private int bufsize;
    private ByteBuffer buf;
    private IDecoder.Step next = null;
    private final Errno errno;

    public DecoderBase(Errno errno, int bufsize) {
        this.bufsize = bufsize;
        assert (bufsize > 0);
        this.buf = ByteBuffer.allocateDirect(bufsize);
        this.errno = errno;
    }

    @Override
    public ByteBuffer getBuffer() {
        if (this.toRead >= this.bufsize) {
            this.zeroCopy = true;
            return this.readPos.duplicate();
        }
        this.zeroCopy = false;
        this.buf.clear();
        return this.buf;
    }

    @Override
    public IDecoder.Step.Result decode(ByteBuffer data, int size2, ValueReference<Integer> processed) {
        processed.set(0);
        if (this.zeroCopy) {
            assert (size2 <= this.toRead);
            this.readPos.position(this.readPos.position() + size2);
            this.toRead -= size2;
            processed.set(size2);
            while (this.readPos.remaining() == 0) {
                IDecoder.Step.Result result2 = this.next.apply();
                if (result2 == IDecoder.Step.Result.MORE_DATA) continue;
                return result2;
            }
            return IDecoder.Step.Result.MORE_DATA;
        }
        while (processed.get() < size2) {
            int toCopy = Math.min(this.toRead, size2 - processed.get());
            int limit2 = data.limit();
            data.limit(data.position() + toCopy);
            this.readPos.put(data);
            data.limit(limit2);
            this.toRead -= toCopy;
            processed.set(processed.get() + toCopy);
            while (this.readPos.remaining() == 0) {
                IDecoder.Step.Result result3 = this.next.apply();
                if (result3 == IDecoder.Step.Result.MORE_DATA) continue;
                return result3;
            }
        }
        return IDecoder.Step.Result.MORE_DATA;
    }

    protected void nextStep(Msg msg, IDecoder.Step next2) {
        this.nextStep(msg.buf(), next2);
    }

    @Deprecated
    protected void nextStep(byte[] buf, int toRead, IDecoder.Step next2) {
        this.readPos = ByteBuffer.wrap(buf);
        this.readPos.limit(toRead);
        this.toRead = toRead;
        this.next = next2;
    }

    protected void nextStep(ByteBuffer buf, IDecoder.Step next2) {
        this.readPos = buf;
        this.toRead = buf.remaining();
        this.next = next2;
    }

    protected void errno(int err2) {
        this.errno.set(err2);
    }

    public int errno() {
        return this.errno.get();
    }

    @Override
    public void destroy() {
    }
}

