/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.objenesis.instantiator.sun;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.springframework.objenesis.ObjenesisException;
import org.springframework.objenesis.instantiator.ObjectInstantiator;
import org.springframework.objenesis.instantiator.annotations.Instantiator;
import org.springframework.objenesis.instantiator.annotations.Typology;
import org.springframework.objenesis.instantiator.util.ClassDefinitionUtils;
import org.springframework.objenesis.instantiator.util.ClassUtils;

@Instantiator(value=Typology.STANDARD)
public class MagicInstantiator<T>
implements ObjectInstantiator<T> {
    private static final String MAGIC_ACCESSOR = MagicInstantiator.getMagicClass();
    private static final int INDEX_CLASS_THIS = 1;
    private static final int INDEX_CLASS_SUPERCLASS = 2;
    private static final int INDEX_UTF8_CONSTRUCTOR_NAME = 3;
    private static final int INDEX_UTF8_CONSTRUCTOR_DESC = 4;
    private static final int INDEX_UTF8_CODE_ATTRIBUTE = 5;
    private static final int INDEX_UTF8_INSTANTIATOR_CLASS = 7;
    private static final int INDEX_UTF8_SUPERCLASS = 8;
    private static final int INDEX_CLASS_INTERFACE = 9;
    private static final int INDEX_UTF8_INTERFACE = 10;
    private static final int INDEX_UTF8_NEWINSTANCE_NAME = 11;
    private static final int INDEX_UTF8_NEWINSTANCE_DESC = 12;
    private static final int INDEX_METHODREF_OBJECT_CONSTRUCTOR = 13;
    private static final int INDEX_CLASS_OBJECT = 14;
    private static final int INDEX_UTF8_OBJECT = 15;
    private static final int INDEX_NAMEANDTYPE_DEFAULT_CONSTRUCTOR = 16;
    private static final int INDEX_CLASS_TYPE = 17;
    private static final int INDEX_UTF8_TYPE = 18;
    private static final int CONSTANT_POOL_COUNT = 19;
    private static final byte[] CONSTRUCTOR_CODE = new byte[]{42, -73, 0, 13, -79};
    private static final int CONSTRUCTOR_CODE_ATTRIBUTE_LENGTH = 12 + CONSTRUCTOR_CODE.length;
    private static final byte[] NEWINSTANCE_CODE = new byte[]{-69, 0, 17, 89, -73, 0, 13, -80};
    private static final int NEWINSTANCE_CODE_ATTRIBUTE_LENGTH = 12 + NEWINSTANCE_CODE.length;
    private static final String CONSTRUCTOR_NAME = "<init>";
    private static final String CONSTRUCTOR_DESC = "()V";
    private final ObjectInstantiator<T> instantiator;

    public MagicInstantiator(Class<T> type) {
        this.instantiator = this.newInstantiatorOf(type);
    }

    public ObjectInstantiator<T> getInstantiator() {
        return this.instantiator;
    }

    private ObjectInstantiator<T> newInstantiatorOf(Class<T> type) {
        String suffix = type.getSimpleName();
        String className = this.getClass().getName() + "$$$" + suffix;
        Class clazz = ClassUtils.getExistingClass(this.getClass().getClassLoader(), className);
        if (clazz == null) {
            byte[] classBytes = this.writeExtendingClass(type, className);
            try {
                clazz = ClassDefinitionUtils.defineClass(className, classBytes, type, this.getClass().getClassLoader());
            }
            catch (Exception e) {
                throw new ObjenesisException(e);
            }
        }
        return (ObjectInstantiator)ClassUtils.newInstance(clazz);
    }

    private byte[] writeExtendingClass(Class<?> type, String className) {
        String clazz = ClassUtils.classNameToInternalClassName(className);
        ByteArrayOutputStream bIn = new ByteArrayOutputStream(1000);
        try (DataOutputStream in2 = new DataOutputStream(bIn);){
            in2.write(ClassDefinitionUtils.MAGIC);
            in2.write(ClassDefinitionUtils.VERSION);
            in2.writeShort(19);
            in2.writeByte(7);
            in2.writeShort(7);
            in2.writeByte(7);
            in2.writeShort(8);
            in2.writeByte(1);
            in2.writeUTF(CONSTRUCTOR_NAME);
            in2.writeByte(1);
            in2.writeUTF(CONSTRUCTOR_DESC);
            in2.writeByte(1);
            in2.writeUTF("Code");
            in2.writeByte(1);
            in2.writeUTF("L" + clazz + ";");
            in2.writeByte(1);
            in2.writeUTF(clazz);
            in2.writeByte(1);
            in2.writeUTF(MAGIC_ACCESSOR);
            in2.writeByte(7);
            in2.writeShort(10);
            in2.writeByte(1);
            in2.writeUTF(ObjectInstantiator.class.getName().replace('.', '/'));
            in2.writeByte(1);
            in2.writeUTF("newInstance");
            in2.writeByte(1);
            in2.writeUTF("()Ljava/lang/Object;");
            in2.writeByte(10);
            in2.writeShort(14);
            in2.writeShort(16);
            in2.writeByte(7);
            in2.writeShort(15);
            in2.writeByte(1);
            in2.writeUTF("java/lang/Object");
            in2.writeByte(12);
            in2.writeShort(3);
            in2.writeShort(4);
            in2.writeByte(7);
            in2.writeShort(18);
            in2.writeByte(1);
            in2.writeUTF(ClassUtils.classNameToInternalClassName(type.getName()));
            in2.writeShort(49);
            in2.writeShort(1);
            in2.writeShort(2);
            in2.writeShort(1);
            in2.writeShort(9);
            in2.writeShort(0);
            in2.writeShort(2);
            in2.writeShort(1);
            in2.writeShort(3);
            in2.writeShort(4);
            in2.writeShort(1);
            in2.writeShort(5);
            in2.writeInt(CONSTRUCTOR_CODE_ATTRIBUTE_LENGTH);
            in2.writeShort(0);
            in2.writeShort(1);
            in2.writeInt(CONSTRUCTOR_CODE.length);
            in2.write(CONSTRUCTOR_CODE);
            in2.writeShort(0);
            in2.writeShort(0);
            in2.writeShort(1);
            in2.writeShort(11);
            in2.writeShort(12);
            in2.writeShort(1);
            in2.writeShort(5);
            in2.writeInt(NEWINSTANCE_CODE_ATTRIBUTE_LENGTH);
            in2.writeShort(2);
            in2.writeShort(1);
            in2.writeInt(NEWINSTANCE_CODE.length);
            in2.write(NEWINSTANCE_CODE);
            in2.writeShort(0);
            in2.writeShort(0);
            in2.writeShort(0);
        }
        catch (IOException e) {
            throw new ObjenesisException(e);
        }
        return bIn.toByteArray();
    }

    @Override
    public T newInstance() {
        return this.instantiator.newInstance();
    }

    private static String getMagicClass() {
        try {
            Class.forName("sun.reflect.MagicAccessorImpl", false, MagicInstantiator.class.getClassLoader());
            return "sun/reflect/MagicAccessorImpl";
        }
        catch (ClassNotFoundException e) {
            return "jdk/internal/reflect/MagicAccessorImpl";
        }
    }
}

