/*
 * Decompiled with CFR 0.152.
 */
package org.joda.convert;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.joda.convert.ReflectionStringConverter;

final class MethodsStringConverter<T>
extends ReflectionStringConverter<T> {
    private final Method fromString;

    MethodsStringConverter(Class<T> cls, Method toString2, Method fromString2) {
        super(cls, toString2);
        if (!Modifier.isStatic(fromString2.getModifiers())) {
            throw new IllegalStateException("FromString method must be static: " + fromString2);
        }
        if (fromString2.getParameterTypes().length != 1) {
            throw new IllegalStateException("FromString method must have one parameter: " + fromString2);
        }
        Class<?> param = fromString2.getParameterTypes()[0];
        if (param != String.class && param != CharSequence.class) {
            throw new IllegalStateException("FromString method must take a String or CharSequence: " + fromString2);
        }
        if (!fromString2.getReturnType().isAssignableFrom(cls) && !cls.isAssignableFrom(fromString2.getReturnType())) {
            throw new IllegalStateException("FromString method must return specified class or a supertype: " + fromString2);
        }
        this.fromString = fromString2;
    }

    @Override
    public T convertFromString(Class<? extends T> cls, String str) {
        try {
            return cls.cast(this.fromString.invoke(null, str));
        }
        catch (IllegalAccessException ex) {
            throw new IllegalStateException("Method is not accessible: " + this.fromString);
        }
        catch (InvocationTargetException ex) {
            if (ex.getCause() instanceof RuntimeException) {
                throw (RuntimeException)ex.getCause();
            }
            throw new RuntimeException(ex.getMessage(), ex.getCause());
        }
    }
}

