/*
 * Decompiled with CFR 0.152.
 */
package akka.dispatch.forkjoin;

import akka.dispatch.forkjoin.CountedCompleter;
import akka.dispatch.forkjoin.ForkJoinTask;
import akka.dispatch.forkjoin.ForkJoinWorkerThread;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.TimeUnit;
import sun.misc.Unsafe;

public class ForkJoinPool
extends AbstractExecutorService {
    public static final ForkJoinWorkerThreadFactory defaultForkJoinWorkerThreadFactory;
    static final ThreadLocal<Submitter> submitters;
    private static final RuntimePermission modifyThreadPermission;
    static final ForkJoinPool common;
    static final int commonParallelism;
    private static int poolNumberSequence;
    private static final long IDLE_TIMEOUT = 2000000000L;
    private static final long FAST_IDLE_TIMEOUT = 200000000L;
    private static final long TIMEOUT_SLOP = 2000000L;
    private static final int MAX_HELP = 64;
    private static final int SEED_INCREMENT = 1640531527;
    private static final int AC_SHIFT = 48;
    private static final int TC_SHIFT = 32;
    private static final int ST_SHIFT = 31;
    private static final int EC_SHIFT = 16;
    private static final int SMASK = 65535;
    private static final int MAX_CAP = Short.MAX_VALUE;
    private static final int EVENMASK = 65534;
    private static final int SQMASK = 126;
    private static final int SHORT_SIGN = 32768;
    private static final int INT_SIGN = Integer.MIN_VALUE;
    private static final long STOP_BIT = 0x80000000L;
    private static final long AC_MASK = -281474976710656L;
    private static final long TC_MASK = 0xFFFF00000000L;
    private static final long TC_UNIT = 0x100000000L;
    private static final long AC_UNIT = 0x1000000000000L;
    private static final int UAC_SHIFT = 16;
    private static final int UTC_SHIFT = 0;
    private static final int UAC_MASK = -65536;
    private static final int UTC_MASK = 65535;
    private static final int UAC_UNIT = 65536;
    private static final int UTC_UNIT = 1;
    private static final int E_MASK = Integer.MAX_VALUE;
    private static final int E_SEQ = 65536;
    private static final int SHUTDOWN = Integer.MIN_VALUE;
    private static final int PL_LOCK = 2;
    private static final int PL_SIGNAL = 1;
    private static final int PL_SPINS;
    static final int LIFO_QUEUE = 0;
    static final int FIFO_QUEUE = 1;
    static final int SHARED_QUEUE = -1;
    private static final int MIN_SCAN = 511;
    private static final int MAX_SCAN = 131071;
    volatile long pad00;
    volatile long pad01;
    volatile long pad02;
    volatile long pad03;
    volatile long pad04;
    volatile long pad05;
    volatile long pad06;
    volatile long stealCount;
    volatile long ctl;
    volatile int plock;
    volatile int indexSeed;
    final int config;
    WorkQueue[] workQueues;
    final ForkJoinWorkerThreadFactory factory;
    final Thread.UncaughtExceptionHandler ueh;
    final String workerNamePrefix;
    volatile Object pad10;
    volatile Object pad11;
    volatile Object pad12;
    volatile Object pad13;
    volatile Object pad14;
    volatile Object pad15;
    volatile Object pad16;
    volatile Object pad17;
    volatile Object pad18;
    volatile Object pad19;
    volatile Object pad1a;
    volatile Object pad1b;
    private static final Unsafe U;
    private static final long CTL;
    private static final long PARKBLOCKER;
    private static final int ABASE;
    private static final int ASHIFT;
    private static final long STEALCOUNT;
    private static final long PLOCK;
    private static final long INDEXSEED;
    private static final long QLOCK;

    private static void checkPermission() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(modifyThreadPermission);
        }
    }

    private static final synchronized int nextPoolId() {
        return ++poolNumberSequence;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int acquirePlock() {
        int n = PL_SPINS;
        int n2 = 0;
        int n3;
        int n4;
        while (((n4 = this.plock) & 2) != 0 || !U.compareAndSwapInt(this, PLOCK, n4, n3 = n4 + 2)) {
            Object object;
            if (n2 == 0) {
                WorkQueue workQueue;
                object = Thread.currentThread();
                if (object instanceof ForkJoinWorkerThread && (workQueue = ((ForkJoinWorkerThread)object).workQueue) != null) {
                    n2 = workQueue.seed;
                    continue;
                }
                Submitter submitter = submitters.get();
                if (submitter != null) {
                    n2 = submitter.seed;
                    continue;
                }
                n2 = 1;
                continue;
            }
            if (n >= 0) {
                n2 ^= n2 << 1;
                n2 ^= n2 >>> 3;
                if ((n2 ^= n2 << 10) < 0) continue;
                --n;
                continue;
            }
            if (!U.compareAndSwapInt(this, PLOCK, n4, n4 | 1)) continue;
            object = this;
            synchronized (object) {
                if ((this.plock & 1) != 0) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        try {
                            Thread.currentThread().interrupt();
                        }
                        catch (SecurityException securityException) {}
                    }
                } else {
                    this.notifyAll();
                }
            }
        }
        return n3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releasePlock(int n) {
        this.plock = n;
        ForkJoinPool forkJoinPool = this;
        synchronized (forkJoinPool) {
            this.notifyAll();
        }
    }

    private void tryAddWorker() {
        long l;
        int n;
        while ((n = (int)((l = this.ctl) >>> 32)) < 0 && (n & 0x8000) != 0 && (int)l == 0) {
            long l2 = (long)(n + 1 & 0xFFFF | n + 65536 & 0xFFFF0000) << 32;
            if (!U.compareAndSwapLong(this, CTL, l, l2)) continue;
            Throwable throwable2 = null;
            ForkJoinWorkerThread forkJoinWorkerThread = null;
            try {
                ForkJoinWorkerThreadFactory forkJoinWorkerThreadFactory = this.factory;
                if (forkJoinWorkerThreadFactory != null && (forkJoinWorkerThread = forkJoinWorkerThreadFactory.newThread(this)) != null) {
                    forkJoinWorkerThread.start();
                    break;
                }
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
            }
            this.deregisterWorker(forkJoinWorkerThread, throwable2);
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final WorkQueue registerWorker(ForkJoinWorkerThread forkJoinWorkerThread) {
        int n;
        forkJoinWorkerThread.setDaemon(true);
        Thread.UncaughtExceptionHandler uncaughtExceptionHandler = this.ueh;
        if (uncaughtExceptionHandler != null) {
            forkJoinWorkerThread.setUncaughtExceptionHandler(uncaughtExceptionHandler);
        }
        do {
            n = this.indexSeed;
        } while (!U.compareAndSwapInt(this, INDEXSEED, n, n += 1640531527) || n == 0);
        WorkQueue workQueue = new WorkQueue(this, forkJoinWorkerThread, this.config >>> 16, n);
        int n2 = this.plock;
        if ((n2 & 2) != 0 || !U.compareAndSwapInt(this, PLOCK, n2, n2 += 2)) {
            n2 = this.acquirePlock();
        }
        int n3 = n2 & Integer.MIN_VALUE | n2 + 2 & Integer.MAX_VALUE;
        try {
            WorkQueue[] workQueueArray = this.workQueues;
            if (this.workQueues != null) {
                int n4 = workQueueArray.length;
                int n5 = n4 - 1;
                int n6 = n << 1 | 1;
                if (workQueueArray[n6 &= n5] != null) {
                    int n7;
                    int n8 = 0;
                    int n9 = n7 = n4 <= 4 ? 2 : (n4 >>> 1 & 0xFFFE) + 2;
                    while (workQueueArray[n6 = n6 + n7 & n5] != null) {
                        if (++n8 < n4) continue;
                        this.workQueues = workQueueArray = Arrays.copyOf(workQueueArray, n4 <<= 1);
                        n5 = n4 - 1;
                        n8 = 0;
                    }
                }
                workQueue.eventCount = workQueue.poolIndex = n6;
                workQueueArray[n6] = workQueue;
            }
        }
        finally {
            if (!U.compareAndSwapInt(this, PLOCK, n2, n3)) {
                this.releasePlock(n3);
            }
        }
        forkJoinWorkerThread.setName(this.workerNamePrefix.concat(Integer.toString(workQueue.poolIndex)));
        return workQueue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void deregisterWorker(ForkJoinWorkerThread forkJoinWorkerThread, Throwable throwable2) {
        long l;
        int n;
        int n2;
        WorkQueue workQueue = null;
        if (forkJoinWorkerThread != null && (workQueue = forkJoinWorkerThread.workQueue) != null) {
            long l2;
            workQueue.qlock = -1;
            long l3 = workQueue.nsteals;
            while (!U.compareAndSwapLong(this, STEALCOUNT, l2 = this.stealCount, l2 + l3)) {
            }
            int n3 = this.plock;
            if ((n3 & 2) != 0 || !U.compareAndSwapInt(this, PLOCK, n3, n3 += 2)) {
                n3 = this.acquirePlock();
            }
            n2 = n3 & Integer.MIN_VALUE | n3 + 2 & Integer.MAX_VALUE;
            try {
                n = workQueue.poolIndex;
                WorkQueue[] workQueueArray = this.workQueues;
                if (workQueueArray != null && n >= 0 && n < workQueueArray.length && workQueueArray[n] == workQueue) {
                    workQueueArray[n] = null;
                }
            }
            finally {
                if (!U.compareAndSwapInt(this, PLOCK, n3, n2)) {
                    this.releasePlock(n2);
                }
            }
        }
        while (!U.compareAndSwapLong(this, CTL, l = this.ctl, l - 0x1000000000000L & 0xFFFF000000000000L | l - 0x100000000L & 0xFFFF00000000L | l & 0xFFFFFFFFL)) {
        }
        if (!this.tryTerminate(false, false) && workQueue != null && workQueue.array != null) {
            int n4;
            workQueue.cancelAll();
            while ((n2 = (int)((l = this.ctl) >>> 32)) < 0 && (n4 = (int)l) >= 0) {
                if (n4 > 0) {
                    WorkQueue workQueue2;
                    WorkQueue[] workQueueArray = this.workQueues;
                    if (this.workQueues == null || (n = n4 & 0xFFFF) >= workQueueArray.length || (workQueue2 = workQueueArray[n]) == null) break;
                    long l4 = (long)(workQueue2.nextWait & Integer.MAX_VALUE) | (long)(n2 + 65536) << 32;
                    if (workQueue2.eventCount != (n4 | Integer.MIN_VALUE)) break;
                    if (!U.compareAndSwapLong(this, CTL, l, l4)) continue;
                    workQueue2.eventCount = n4 + 65536 & Integer.MAX_VALUE;
                    Thread thread = workQueue2.parker;
                    if (thread == null) break;
                    U.unpark(thread);
                    break;
                }
                if ((short)n2 >= 0) break;
                this.tryAddWorker();
                break;
            }
        }
        if (throwable2 == null) {
            ForkJoinTask.helpExpungeStaleExceptions();
        } else {
            ForkJoinTask.rethrow(throwable2);
        }
    }

    final void externalPush(ForkJoinTask<?> forkJoinTask) {
        Submitter submitter = submitters.get();
        if (submitter != null && this.plock > 0) {
            WorkQueue workQueue;
            int n;
            WorkQueue[] workQueueArray = this.workQueues;
            if (this.workQueues != null && (n = workQueueArray.length - 1) >= 0 && (workQueue = workQueueArray[n & submitter.seed & 0x7E]) != null && U.compareAndSwapInt(workQueue, QLOCK, 0, 1)) {
                int n2;
                int n3;
                int n4 = workQueue.base;
                int n5 = workQueue.top;
                ForkJoinTask<?>[] forkJoinTaskArray = workQueue.array;
                if (workQueue.array != null && (n3 = forkJoinTaskArray.length) > (n2 = n5 + 1 - n4)) {
                    int n6 = ((n3 - 1 & n5) << ASHIFT) + ABASE;
                    U.putOrderedObject(forkJoinTaskArray, n6, forkJoinTask);
                    workQueue.top = n5 + 1;
                    workQueue.qlock = 0;
                    if (n2 <= 2) {
                        this.signalWork(workQueue);
                    }
                    return;
                }
                workQueue.qlock = 0;
            }
        }
        this.fullExternalPush(forkJoinTask);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fullExternalPush(ForkJoinTask<?> forkJoinTask) {
        int n = 0;
        Submitter submitter = submitters.get();
        while (true) {
            int n2;
            int n3;
            int n4;
            int n5;
            WorkQueue[] workQueueArray;
            int n6;
            block23: {
                block22: {
                    if (submitter == null) {
                        n = this.indexSeed;
                        if (!U.compareAndSwapInt(this, INDEXSEED, n, n += 1640531527) || n == 0) continue;
                        submitter = new Submitter(n);
                        submitters.set(submitter);
                        continue;
                    }
                    if (n == 0) {
                        n = submitter.seed;
                        n ^= n << 13;
                        n ^= n >>> 17;
                        submitter.seed = n ^ n << 5;
                        continue;
                    }
                    n6 = this.plock;
                    if (n6 < 0) {
                        throw new RejectedExecutionException();
                    }
                    if (n6 == 0) break block22;
                    workQueueArray = this.workQueues;
                    if (this.workQueues != null && (n5 = workQueueArray.length - 1) >= 0) break block23;
                }
                n3 = (n4 = this.config & 0xFFFF) > 1 ? n4 - 1 : 1;
                n3 |= n3 >>> 1;
                n3 |= n3 >>> 2;
                n3 |= n3 >>> 4;
                n3 |= n3 >>> 8;
                n3 |= n3 >>> 16;
                n3 = n3 + 1 << 1;
                workQueueArray = this.workQueues;
                WorkQueue[] workQueueArray2 = this.workQueues == null || workQueueArray.length == 0 ? new WorkQueue[n3] : null;
                n6 = this.plock;
                if ((n6 & 2) != 0 || !U.compareAndSwapInt(this, PLOCK, n6, n6 += 2)) {
                    n6 = this.acquirePlock();
                }
                workQueueArray = this.workQueues;
                if ((this.workQueues == null || workQueueArray.length == 0) && workQueueArray2 != null) {
                    this.workQueues = workQueueArray2;
                }
                if (U.compareAndSwapInt(this, PLOCK, n6, n2 = n6 & Integer.MIN_VALUE | n6 + 2 & Integer.MAX_VALUE)) continue;
                this.releasePlock(n2);
                continue;
            }
            int n7 = n & n5 & 0x7E;
            WorkQueue workQueue = workQueueArray[n7];
            if (workQueue != null) {
                if (workQueue.qlock == 0 && U.compareAndSwapInt(workQueue, QLOCK, 0, 1)) {
                    ForkJoinTask<?>[] forkJoinTaskArray = workQueue.array;
                    n3 = workQueue.top;
                    boolean bl = false;
                    try {
                        if (forkJoinTaskArray != null && forkJoinTaskArray.length > n3 + 1 - workQueue.base || (forkJoinTaskArray = workQueue.growArray()) != null) {
                            n2 = ((forkJoinTaskArray.length - 1 & n3) << ASHIFT) + ABASE;
                            U.putOrderedObject(forkJoinTaskArray, n2, forkJoinTask);
                            workQueue.top = n3 + 1;
                            bl = true;
                        }
                    }
                    finally {
                        workQueue.qlock = 0;
                    }
                    if (bl) {
                        this.signalWork(workQueue);
                        return;
                    }
                }
                n = 0;
                continue;
            }
            n6 = this.plock;
            if ((n6 & 2) == 0) {
                workQueue = new WorkQueue(this, null, -1, n);
                n6 = this.plock;
                if ((n6 & 2) != 0 || !U.compareAndSwapInt(this, PLOCK, n6, n6 += 2)) {
                    n6 = this.acquirePlock();
                }
                workQueueArray = this.workQueues;
                if (this.workQueues != null && n7 < workQueueArray.length && workQueueArray[n7] == null) {
                    workQueueArray[n7] = workQueue;
                }
                if (U.compareAndSwapInt(this, PLOCK, n6, n4 = n6 & Integer.MIN_VALUE | n6 + 2 & Integer.MAX_VALUE)) continue;
                this.releasePlock(n4);
                continue;
            }
            n = 0;
        }
    }

    final void incrementActiveCount() {
        long l;
        while (!U.compareAndSwapLong(this, CTL, l = this.ctl, l + 0x1000000000000L)) {
        }
    }

    final void signalWork(WorkQueue workQueue) {
        long l;
        int n;
        int n2 = workQueue.poolIndex;
        while ((n = (int)((l = this.ctl) >>> 32)) < 0) {
            int n3 = (int)l;
            if (n3 > 0) {
                WorkQueue workQueue2;
                int n4;
                WorkQueue[] workQueueArray = this.workQueues;
                if (this.workQueues == null || workQueueArray.length <= (n4 = n3 & 0xFFFF) || (workQueue2 = workQueueArray[n4]) == null || workQueue2.eventCount != (n3 | Integer.MIN_VALUE)) break;
                long l2 = (long)(workQueue2.nextWait & Integer.MAX_VALUE) | (long)(n + 65536) << 32;
                if (U.compareAndSwapLong(this, CTL, l, l2)) {
                    workQueue2.hint = n2;
                    workQueue2.eventCount = n3 + 65536 & Integer.MAX_VALUE;
                    Thread thread = workQueue2.parker;
                    if (thread == null) break;
                    U.unpark(thread);
                    break;
                }
                if (workQueue.top - workQueue.base > 0) continue;
                break;
            }
            if ((short)n >= 0) break;
            this.tryAddWorker();
            break;
        }
    }

    final void runWorker(WorkQueue workQueue) {
        workQueue.growArray();
        do {
            workQueue.runTask(this.scan(workQueue));
        } while (workQueue.qlock >= 0);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final ForkJoinTask<?> scan(WorkQueue workQueue) {
        int n;
        int n2;
        int n3 = this.plock;
        if (workQueue == null) return null;
        WorkQueue[] workQueueArray = this.workQueues;
        if (this.workQueues == null || (n2 = workQueueArray.length - 1) < 0) return null;
        int n4 = workQueue.eventCount;
        int n5 = workQueue.seed;
        n5 ^= n5 << 13;
        n5 ^= n5 >>> 17;
        n5 ^= n5 << 5;
        workQueue.seed = n5;
        workQueue.hint = -1;
        int n6 = (n2 + n2 + 1 | 0x1FF) & 0x1FFFF;
        do {
            WorkQueue workQueue2;
            if ((workQueue2 = workQueueArray[n5 + n6 & n2]) == null || (n = workQueue2.base) - workQueue2.top >= 0) continue;
            ForkJoinTask<?>[] forkJoinTaskArray = workQueue2.array;
            if (workQueue2.array == null) continue;
            int n7 = ((forkJoinTaskArray.length - 1 & n) << ASHIFT) + ABASE;
            ForkJoinTask forkJoinTask = (ForkJoinTask)U.getObjectVolatile(forkJoinTaskArray, n7);
            if (workQueue2.base == n && n4 >= 0 && forkJoinTask != null && U.compareAndSwapObject(forkJoinTaskArray, n7, forkJoinTask, null)) {
                workQueue2.base = n + 1;
                if (workQueue2.base - workQueue2.top >= 0) return forkJoinTask;
                this.signalWork(workQueue2);
                return forkJoinTask;
            }
            if (n4 >= 0 && n6 >= n2 || (int)(this.ctl >> 48) > 0) continue;
            workQueue.hint = n5 + n6 & n2;
            break;
        } while (--n6 >= 0);
        n = workQueue.nsteals;
        if (n != 0) {
            long l = this.stealCount;
            if (!U.compareAndSwapLong(this, STEALCOUNT, l, l + (long)n)) return null;
            workQueue.nsteals = 0;
            return null;
        } else {
            if (this.plock != n3) return null;
            long l = this.ctl;
            int n8 = (int)l;
            if (n8 < 0) {
                workQueue.qlock = -1;
                return null;
            } else {
                WorkQueue workQueue3;
                int n9;
                int n10;
                int n11;
                int n12;
                WorkQueue workQueue4;
                int n13 = workQueue.hint;
                if (n13 < 0) {
                    if (n4 >= 0) {
                        long l2 = (long)n4 | l - 0x1000000000000L & 0xFFFFFFFF00000000L;
                        workQueue.nextWait = n8;
                        workQueue.eventCount = n4 | Integer.MIN_VALUE;
                        if (this.ctl != l || !U.compareAndSwapLong(this, CTL, l, l2)) {
                            workQueue.eventCount = n4;
                        } else if ((int)(l >> 48) == 1 - (this.config & 0xFFFF)) {
                            this.idleAwaitWork(workQueue, l2, l);
                        }
                    } else if (workQueue.eventCount < 0 && this.ctl == l) {
                        Thread thread = Thread.currentThread();
                        Thread.interrupted();
                        U.putObject(thread, PARKBLOCKER, this);
                        workQueue.parker = thread;
                        if (workQueue.eventCount < 0) {
                            U.park(false, 0L);
                        }
                        workQueue.parker = null;
                        U.putObject(thread, PARKBLOCKER, null);
                    }
                }
                if (n13 < 0 && (n13 = workQueue.hint) < 0) return null;
                workQueueArray = this.workQueues;
                if (this.workQueues == null || n13 >= workQueueArray.length || (workQueue4 = workQueueArray[n13]) == null) return null;
                int n14 = (this.config & 0xFFFF) - 1;
                while (((n12 = (n11 = workQueue.eventCount < 0 ? 0 : -1) - workQueue4.base + workQueue4.top) > n14 || (n14 = n12) > 0) && (n10 = (int)((l = this.ctl) >>> 32)) < 0 && (n8 = (int)l) > 0 && n2 >= (n9 = n8 & 0xFFFF) && (workQueue3 = workQueueArray[n9]) != null) {
                    long l3 = (long)(workQueue3.nextWait & Integer.MAX_VALUE) | (long)(n10 + 65536) << 32;
                    if (workQueue3.eventCount != (n8 | Integer.MIN_VALUE) || !U.compareAndSwapLong(this, CTL, l, l3)) return null;
                    workQueue3.hint = n13;
                    workQueue3.eventCount = n8 + 65536 & Integer.MAX_VALUE;
                    Thread thread = workQueue3.parker;
                    if (thread != null) {
                        U.unpark(thread);
                    }
                    if (--n14 > 0) continue;
                    return null;
                }
            }
        }
        return null;
    }

    private void idleAwaitWork(WorkQueue workQueue, long l, long l2) {
        if (workQueue != null && workQueue.eventCount < 0 && !this.tryTerminate(false, false) && (int)l2 != 0 && this.ctl == l) {
            short s = -((short)(l >>> 32));
            long l3 = s < 0 ? 200000000L : (long)(s + 1) * 2000000000L;
            long l4 = System.nanoTime() + l3 - 2000000L;
            Thread thread = Thread.currentThread();
            while (this.ctl == l) {
                Thread.interrupted();
                U.putObject(thread, PARKBLOCKER, this);
                workQueue.parker = thread;
                if (this.ctl == l) {
                    U.park(false, l3);
                }
                workQueue.parker = null;
                U.putObject(thread, PARKBLOCKER, null);
                if (this.ctl != l) break;
                if (l4 - System.nanoTime() > 0L || !U.compareAndSwapLong(this, CTL, l, l2)) continue;
                workQueue.eventCount = workQueue.eventCount + 65536 | Integer.MAX_VALUE;
                workQueue.hint = -1;
                workQueue.qlock = -1;
                break;
            }
        }
    }

    private void helpSignal(ForkJoinTask<?> forkJoinTask, int n) {
        int n2;
        if (forkJoinTask != null && forkJoinTask.status >= 0 && (n2 = (int)(this.ctl >>> 32)) < 0 && n2 >> 16 < 0) {
            int n3;
            WorkQueue[] workQueueArray = this.workQueues;
            if (this.workQueues != null && (n3 = workQueueArray.length - 1) >= 0) {
                int n4 = n;
                block0: for (int i = n3; i >= 0; --i) {
                    WorkQueue workQueue = workQueueArray[n4++ & n3];
                    int n5 = n3;
                    while (forkJoinTask.status >= 0) {
                        WorkQueue workQueue2;
                        int n6;
                        int n7;
                        int n8;
                        if (workQueue == null || (n8 = -workQueue.base + workQueue.top) <= n5 && (n5 = n8) <= 0) continue block0;
                        long l = this.ctl;
                        n2 = (int)(l >>> 32);
                        if (n2 >= 0 || (n7 = (int)l) <= 0 || n3 < (n6 = n7 & 0xFFFF) || (workQueue2 = workQueueArray[n6]) == null) break block0;
                        long l2 = (long)(workQueue2.nextWait & Integer.MAX_VALUE) | (long)(n2 + 65536) << 32;
                        if (workQueue2.eventCount != (n7 | Integer.MIN_VALUE)) break block0;
                        if (!U.compareAndSwapLong(this, CTL, l, l2)) continue;
                        workQueue2.eventCount = n7 + 65536 & Integer.MAX_VALUE;
                        Thread thread = workQueue2.parker;
                        if (thread != null) {
                            U.unpark(thread);
                        }
                        if (--n5 > 0) continue;
                        continue block0;
                    }
                    break block0;
                }
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private int tryHelpStealer(WorkQueue var1_1, ForkJoinTask<?> var2_2) {
        var3_3 = 0;
        var4_4 = 0;
        if (var1_1 != null && var2_2 != null) {
            block0: while (true) {
                var5_5 = var2_2;
                var6_6 = var1_1;
                while (true) {
                    block9: {
                        block8: {
                            if ((var10_10 = var2_2.status) < 0) {
                                var3_3 = var10_10;
                                break block0;
                            }
                            var8_8 = this.workQueues;
                            if (this.workQueues == null || (var9_9 = var8_8.length - 1) <= 0) break block0;
                            var11_11 = (var6_6.hint | 1) & var9_9;
                            var7_7 = var8_8[var11_11];
                            if (var7_7 == null || var7_7.currentSteal != var5_5) {
                                var12_12 = var11_11;
                                do {
                                    if (((var11_11 = var11_11 + 2 & var9_9) & 15) == 1 && (var5_5.status < 0 || var6_6.currentJoin != var5_5)) continue block0;
                                    var7_7 = var8_8[var11_11];
                                    if (var7_7 == null || var7_7.currentSteal != var5_5) continue;
                                    var6_6.hint = var11_11;
                                    break block8;
                                } while (var11_11 != var12_12);
                                break block0;
                            }
                        }
                        while (true) {
                            if (var5_5.status < 0) continue block0;
                            var13_14 = var7_7.base;
                            if (var13_14 - var7_7.top >= 0) break block9;
                            var12_13 = var7_7.array;
                            if (var7_7.array == null) break block9;
                            var14_15 = ((var12_13.length - 1 & var13_14) << ForkJoinPool.ASHIFT) + ForkJoinPool.ABASE;
                            var15_17 = (ForkJoinTask)ForkJoinPool.U.getObjectVolatile(var12_13, var14_15);
                            if (var5_5.status < 0 || var6_6.currentJoin != var5_5 || var7_7.currentSteal != var5_5) continue block0;
                            var3_3 = 1;
                            if (var15_17 != null && var7_7.base == var13_14 && ForkJoinPool.U.compareAndSwapObject(var12_13, var14_15, var15_17, null)) {
                                var7_7.base = var13_14 + 1;
                                var1_1.runSubtask(var15_17);
                                continue;
                            }
                            if (var7_7.base == var13_14 && ++var4_4 == 64) break;
                        }
                        break block0;
                    }
                    var14_16 = var7_7.currentJoin;
                    if (var5_5.status >= 0 && var6_6.currentJoin == var5_5 && var7_7.currentSteal == var5_5) ** break;
                    continue block0;
                    if (var14_16 == null || ++var4_4 == 64) break block0;
                    var5_5 = var14_16;
                    var6_6 = var7_7;
                }
                break;
            }
        }
        return var3_3;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int helpComplete(ForkJoinTask<?> forkJoinTask, int n) {
        int n2;
        int n3;
        if (forkJoinTask == null) return 0;
        WorkQueue[] workQueueArray = this.workQueues;
        if (this.workQueues == null || (n3 = workQueueArray.length - 1) < 0) return 0;
        int n4 = n2 = 1;
        int n5;
        while ((n5 = forkJoinTask.status) >= 0) {
            WorkQueue workQueue = workQueueArray[n2 & n3];
            if (workQueue != null && workQueue.pollAndExecCC(forkJoinTask)) {
                int n6;
                n4 = n2;
                if (n != -1 || (n6 = (int)(this.ctl >>> 32)) < 0 && n6 >> 16 < 0) continue;
                return 0;
            }
            if ((n2 = n2 + 2 & n3) == n4) return 0;
        }
        return n5;
    }

    final boolean tryCompensate() {
        long l;
        int n;
        int n2 = this.config & 0xFFFF;
        WorkQueue[] workQueueArray = this.workQueues;
        if (this.workQueues != null && (n = (int)(l = this.ctl)) >= 0) {
            WorkQueue workQueue;
            int n3;
            if (n != 0 && (n3 = n & 0xFFFF) < workQueueArray.length && (workQueue = workQueueArray[n3]) != null && workQueue.eventCount == (n | Integer.MIN_VALUE)) {
                long l2 = (long)(workQueue.nextWait & Integer.MAX_VALUE) | l & 0xFFFFFFFF00000000L;
                if (U.compareAndSwapLong(this, CTL, l, l2)) {
                    workQueue.eventCount = n + 65536 & Integer.MAX_VALUE;
                    Thread thread = workQueue.parker;
                    if (thread != null) {
                        U.unpark(thread);
                    }
                    return true;
                }
            } else {
                long l3;
                short s = (short)(l >>> 32);
                if (s >= 0 && (int)(l >> 48) + n2 > 1) {
                    long l4 = l - 0x1000000000000L & 0xFFFF000000000000L | l & 0xFFFFFFFFFFFFL;
                    if (U.compareAndSwapLong(this, CTL, l, l4)) {
                        return true;
                    }
                } else if (s + n2 < Short.MAX_VALUE && U.compareAndSwapLong(this, CTL, l, l3 = l + 0x100000000L & 0xFFFF00000000L | l & 0xFFFF0000FFFFFFFFL)) {
                    Throwable throwable2 = null;
                    ForkJoinWorkerThread forkJoinWorkerThread = null;
                    try {
                        ForkJoinWorkerThreadFactory forkJoinWorkerThreadFactory = this.factory;
                        if (forkJoinWorkerThreadFactory != null && (forkJoinWorkerThread = forkJoinWorkerThreadFactory.newThread(this)) != null) {
                            forkJoinWorkerThread.start();
                            return true;
                        }
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                    }
                    this.deregisterWorker(forkJoinWorkerThread, throwable2);
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final int awaitJoin(WorkQueue workQueue, ForkJoinTask<?> forkJoinTask) {
        int n = 0;
        if (workQueue != null && forkJoinTask != null && (n = forkJoinTask.status) >= 0) {
            ForkJoinTask<?> forkJoinTask2 = workQueue.currentJoin;
            workQueue.currentJoin = forkJoinTask;
            while ((n = forkJoinTask.status) >= 0 && !workQueue.isEmpty() && workQueue.tryRemoveAndExec(forkJoinTask)) {
            }
            if (n >= 0 && (n = forkJoinTask.status) >= 0) {
                this.helpSignal(forkJoinTask, workQueue.poolIndex);
                n = forkJoinTask.status;
                if (n >= 0 && forkJoinTask instanceof CountedCompleter) {
                    n = this.helpComplete(forkJoinTask, 0);
                }
            }
            while (n >= 0 && (n = forkJoinTask.status) >= 0) {
                long l;
                if (workQueue.isEmpty() && (n = this.tryHelpStealer(workQueue, forkJoinTask)) != 0 || (n = forkJoinTask.status) < 0) continue;
                this.helpSignal(forkJoinTask, workQueue.poolIndex);
                n = forkJoinTask.status;
                if (n < 0 || !this.tryCompensate()) continue;
                if (forkJoinTask.trySetSignal() && (n = forkJoinTask.status) >= 0) {
                    ForkJoinTask<?> forkJoinTask3 = forkJoinTask;
                    synchronized (forkJoinTask3) {
                        if (forkJoinTask.status >= 0) {
                            try {
                                forkJoinTask.wait();
                            }
                            catch (InterruptedException interruptedException) {}
                        } else {
                            forkJoinTask.notifyAll();
                        }
                    }
                }
                while (!U.compareAndSwapLong(this, CTL, l = this.ctl, l + 0x1000000000000L)) {
                }
            }
            workQueue.currentJoin = forkJoinTask2;
        }
        return n;
    }

    final void helpJoinOnce(WorkQueue workQueue, ForkJoinTask<?> forkJoinTask) {
        int n;
        if (workQueue != null && forkJoinTask != null && (n = forkJoinTask.status) >= 0) {
            ForkJoinTask<?> forkJoinTask2 = workQueue.currentJoin;
            workQueue.currentJoin = forkJoinTask;
            while ((n = forkJoinTask.status) >= 0 && !workQueue.isEmpty() && workQueue.tryRemoveAndExec(forkJoinTask)) {
            }
            if (n >= 0 && (n = forkJoinTask.status) >= 0) {
                this.helpSignal(forkJoinTask, workQueue.poolIndex);
                n = forkJoinTask.status;
                if (n >= 0 && forkJoinTask instanceof CountedCompleter) {
                    n = this.helpComplete(forkJoinTask, 0);
                }
            }
            if (n >= 0 && workQueue.isEmpty()) {
                while (forkJoinTask.status >= 0 && this.tryHelpStealer(workQueue, forkJoinTask) > 0) {
                }
            }
            workQueue.currentJoin = forkJoinTask2;
        }
    }

    private WorkQueue findNonEmptyStealQueue(int n) {
        int n2;
        do {
            int n3;
            n2 = this.plock;
            WorkQueue[] workQueueArray = this.workQueues;
            if (this.workQueues == null || (n3 = workQueueArray.length - 1) < 0) continue;
            for (int i = n3 + 1 << 2; i >= 0; --i) {
                WorkQueue workQueue = workQueueArray[(n + i << 1 | 1) & n3];
                if (workQueue == null || workQueue.base - workQueue.top >= 0) continue;
                return workQueue;
            }
        } while (this.plock != n2);
        return null;
    }

    final void helpQuiescePool(WorkQueue workQueue) {
        boolean bl = true;
        while (true) {
            long l;
            ForkJoinTask<?> forkJoinTask;
            if ((forkJoinTask = workQueue.nextLocalTask()) != null) {
                if (workQueue.base - workQueue.top < 0) {
                    this.signalWork(workQueue);
                }
                forkJoinTask.doExec();
                continue;
            }
            WorkQueue workQueue2 = this.findNonEmptyStealQueue(workQueue.nextSeed());
            if (workQueue2 != null) {
                int n;
                if (!bl) {
                    bl = true;
                    while (!U.compareAndSwapLong(this, CTL, l = this.ctl, l + 0x1000000000000L)) {
                    }
                }
                if ((n = workQueue2.base) - workQueue2.top >= 0 || (forkJoinTask = workQueue2.pollAt(n)) == null) continue;
                if (workQueue2.base - workQueue2.top < 0) {
                    this.signalWork(workQueue2);
                }
                workQueue.runSubtask(forkJoinTask);
                continue;
            }
            if (bl) {
                l = this.ctl;
                long l2 = l - 0x1000000000000L;
                if ((int)(l2 >> 48) + (this.config & 0xFFFF) == 0) {
                    return;
                }
                if (!U.compareAndSwapLong(this, CTL, l, l2)) continue;
                bl = false;
                continue;
            }
            l = this.ctl;
            if ((int)(l >> 48) + (this.config & 0xFFFF) == 0 && U.compareAndSwapLong(this, CTL, l, l + 0x1000000000000L)) break;
        }
    }

    final ForkJoinTask<?> nextTaskFor(WorkQueue workQueue) {
        ForkJoinTask<?> forkJoinTask;
        WorkQueue workQueue2;
        int n;
        do {
            if ((forkJoinTask = workQueue.nextLocalTask()) != null) {
                return forkJoinTask;
            }
            workQueue2 = this.findNonEmptyStealQueue(workQueue.nextSeed());
            if (workQueue2 != null) continue;
            return null;
        } while ((n = workQueue2.base) - workQueue2.top >= 0 || (forkJoinTask = workQueue2.pollAt(n)) == null);
        if (workQueue2.base - workQueue2.top < 0) {
            this.signalWork(workQueue2);
        }
        return forkJoinTask;
    }

    static int getSurplusQueuedTaskCount() {
        Thread thread = Thread.currentThread();
        if (thread instanceof ForkJoinWorkerThread) {
            ForkJoinWorkerThread forkJoinWorkerThread = (ForkJoinWorkerThread)thread;
            ForkJoinPool forkJoinPool = forkJoinWorkerThread.pool;
            int n = forkJoinPool.config & 0xFFFF;
            WorkQueue workQueue = forkJoinWorkerThread.workQueue;
            int n2 = workQueue.top - workQueue.base;
            int n3 = (int)(forkJoinPool.ctl >> 48) + n;
            return n2 - (n3 > (n >>>= 1) ? 0 : (n3 > (n >>>= 1) ? 1 : (n3 > (n >>>= 1) ? 2 : (n3 > (n >>>= 1) ? 4 : 8))));
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private boolean tryTerminate(boolean var1_1, boolean var2_2) {
        if (this == ForkJoinPool.common) {
            return false;
        }
        var3_3 = this.plock;
        if (var3_3 >= 0) {
            if (!var2_2) {
                return false;
            }
            if ((var3_3 & 2) != 0 || !ForkJoinPool.U.compareAndSwapInt(this, ForkJoinPool.PLOCK, var3_3, var3_3 += 2)) {
                var3_3 = this.acquirePlock();
            }
            if (!ForkJoinPool.U.compareAndSwapInt(this, ForkJoinPool.PLOCK, var3_3, var4_4 = var3_3 + 2 & 0x7FFFFFFF | -2147483648)) {
                this.releasePlock(var4_4);
            }
        }
        block5: while (true) {
            if (((var4_5 = this.ctl) & 0x80000000L) != 0L) {
                if ((short)(var4_5 >>> 32) == -(this.config & 65535)) {
                    var6_6 = this;
                    synchronized (var6_6) {
                        this.notifyAll();
                    }
                }
                return true;
            }
            if (!var1_1) {
                if ((int)(var4_5 >> 48) != -(this.config & 65535)) {
                    return false;
                }
                var6_7 = this.workQueues;
                if (this.workQueues != null) {
                    for (var8_11 = 0; var8_11 < var6_7.length; ++var8_11) {
                        var7_9 = var6_7[var8_11];
                        if (var7_9 == null) continue;
                        if (!var7_9.isEmpty()) {
                            this.signalWork((WorkQueue)var7_9);
                            return false;
                        }
                        if ((var8_11 & 1) == 0 || var7_9.eventCount < 0) continue;
                        return false;
                    }
                }
            }
            if (!ForkJoinPool.U.compareAndSwapLong(this, ForkJoinPool.CTL, var4_5, var4_5 | 0x80000000L)) continue;
            var6_8 = 0;
            while (true) {
                if (var6_8 < 3) ** break;
                continue block5;
                var7_9 = this.workQueues;
                if (this.workQueues != null) {
                    var10_15 = ((WorkQueue[])var7_9).length;
                    for (var11_16 = 0; var11_16 < var10_15; ++var11_16) {
                        var8_12 = var7_9[var11_16];
                        if (var8_12 == null) continue;
                        var8_12.qlock = -1;
                        if (var6_8 <= 0) continue;
                        var8_12.cancelAll();
                        if (var6_8 <= 1 || (var9_14 = var8_12.owner) == null) continue;
                        if (!var9_14.isInterrupted()) {
                            try {
                                var9_14.interrupt();
                            }
                            catch (Throwable var12_18) {
                                // empty catch block
                            }
                        }
                        ForkJoinPool.U.unpark(var9_14);
                    }
                    while ((var12_17 = (int)(var13_19 = this.ctl) & 0x7FFFFFFF) != 0 && (var11_16 = var12_17 & 65535) < var10_15 && var11_16 >= 0 && (var8_13 = var7_9[var11_16]) != null) {
                        var16_21 = (long)(var8_13.nextWait & 0x7FFFFFFF) | var13_19 + 0x1000000000000L & -281474976710656L | var13_19 & 0xFFFF80000000L;
                        if (var8_13.eventCount != (var12_17 | -2147483648) || !ForkJoinPool.U.compareAndSwapLong(this, ForkJoinPool.CTL, var13_19, var16_21)) continue;
                        var8_13.eventCount = var12_17 + 65536 & 0x7FFFFFFF;
                        var8_13.qlock = -1;
                        var15_20 = var8_13.parker;
                        if (var15_20 == null) continue;
                        ForkJoinPool.U.unpark(var15_20);
                    }
                }
                ++var6_8;
            }
            break;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static WorkQueue commonSubmitterQueue() {
        Submitter submitter = submitters.get();
        if (submitter == null) return null;
        ForkJoinPool forkJoinPool = common;
        if (forkJoinPool == null) return null;
        WorkQueue[] workQueueArray = forkJoinPool.workQueues;
        if (forkJoinPool.workQueues == null) return null;
        int n = workQueueArray.length - 1;
        if (n < 0) return null;
        WorkQueue workQueue = workQueueArray[n & submitter.seed & 0x7E];
        return workQueue;
    }

    static boolean tryExternalUnpush(ForkJoinTask<?> forkJoinTask) {
        ForkJoinPool forkJoinPool;
        Submitter submitter;
        if (forkJoinTask != null && (submitter = submitters.get()) != null && (forkJoinPool = common) != null) {
            int n;
            WorkQueue workQueue;
            int n2;
            WorkQueue[] workQueueArray = forkJoinPool.workQueues;
            if (forkJoinPool.workQueues != null && (n2 = workQueueArray.length - 1) >= 0 && (workQueue = workQueueArray[n2 & submitter.seed & 0x7E]) != null && (n = workQueue.top) != workQueue.base) {
                long l;
                ForkJoinTask<?>[] forkJoinTaskArray = workQueue.array;
                if (workQueue.array != null && U.getObject(forkJoinTaskArray, l = (long)(((forkJoinTaskArray.length - 1 & n - 1) << ASHIFT) + ABASE)) == forkJoinTask && U.compareAndSwapInt(workQueue, QLOCK, 0, 1)) {
                    if (workQueue.array == forkJoinTaskArray && workQueue.top == n && U.compareAndSwapObject(forkJoinTaskArray, l, forkJoinTask, null)) {
                        workQueue.top = n - 1;
                        workQueue.qlock = 0;
                        return true;
                    }
                    workQueue.qlock = 0;
                }
            }
        }
        return false;
    }

    private void externalHelpComplete(WorkQueue workQueue, ForkJoinTask<?> forkJoinTask) {
        block7: {
            int n;
            if (workQueue == null) break block7;
            ForkJoinTask<?>[] forkJoinTaskArray = workQueue.array;
            if (workQueue.array != null && (n = forkJoinTaskArray.length - 1) >= 0 && forkJoinTask != null && forkJoinTask.status >= 0) {
                CountedCompleter<?> countedCompleter;
                do {
                    int n2;
                    long l;
                    Object object;
                    countedCompleter = null;
                    int n3 = workQueue.top;
                    if (n3 - workQueue.base > 0 && (object = U.getObject(forkJoinTaskArray, l = (long)(((n & n3 - 1) << ASHIFT) + ABASE))) != null && object instanceof CountedCompleter) {
                        CountedCompleter<?> countedCompleter2;
                        CountedCompleter<?> countedCompleter3 = countedCompleter2 = (CountedCompleter<?>)object;
                        do {
                            if (countedCompleter3 != forkJoinTask) continue;
                            if (!U.compareAndSwapInt(workQueue, QLOCK, 0, 1)) break;
                            if (workQueue.array == forkJoinTaskArray && workQueue.top == n3 && U.compareAndSwapObject(forkJoinTaskArray, l, countedCompleter2, null)) {
                                workQueue.top = n3 - 1;
                                countedCompleter = countedCompleter2;
                            }
                            workQueue.qlock = 0;
                            break;
                        } while ((countedCompleter3 = countedCompleter3.completer) != null);
                    }
                    if (countedCompleter != null) {
                        countedCompleter.doExec();
                    }
                    if (forkJoinTask.status < 0 || (n2 = (int)(this.ctl >>> 32)) >= 0 || n2 >> 16 >= 0) break block7;
                } while (countedCompleter != null);
                this.helpSignal(forkJoinTask, workQueue.poolIndex);
                if (forkJoinTask.status >= 0) {
                    this.helpComplete(forkJoinTask, -1);
                }
            }
        }
    }

    static void externalHelpJoin(ForkJoinTask<?> forkJoinTask) {
        ForkJoinPool forkJoinPool;
        Submitter submitter;
        if (forkJoinTask != null && (submitter = submitters.get()) != null && (forkJoinPool = common) != null) {
            WorkQueue workQueue;
            int n;
            WorkQueue[] workQueueArray = forkJoinPool.workQueues;
            if (forkJoinPool.workQueues != null && (n = workQueueArray.length - 1) >= 0 && (workQueue = workQueueArray[n & submitter.seed & 0x7E]) != null) {
                ForkJoinTask<?>[] forkJoinTaskArray = workQueue.array;
                if (workQueue.array != null) {
                    long l;
                    int n2 = forkJoinTaskArray.length - 1;
                    int n3 = workQueue.top;
                    if (n3 != workQueue.base && U.getObject(forkJoinTaskArray, l = (long)(((n2 & n3 - 1) << ASHIFT) + ABASE)) == forkJoinTask && U.compareAndSwapInt(workQueue, QLOCK, 0, 1)) {
                        if (workQueue.array == forkJoinTaskArray && workQueue.top == n3 && U.compareAndSwapObject(forkJoinTaskArray, l, forkJoinTask, null)) {
                            workQueue.top = n3 - 1;
                            workQueue.qlock = 0;
                            forkJoinTask.doExec();
                        } else {
                            workQueue.qlock = 0;
                        }
                    }
                    if (forkJoinTask.status >= 0) {
                        if (forkJoinTask instanceof CountedCompleter) {
                            forkJoinPool.externalHelpComplete(workQueue, forkJoinTask);
                        } else {
                            forkJoinPool.helpSignal(forkJoinTask, workQueue.poolIndex);
                        }
                    }
                }
            }
        }
    }

    public ForkJoinPool() {
        this(Math.min(Short.MAX_VALUE, Runtime.getRuntime().availableProcessors()), defaultForkJoinWorkerThreadFactory, null, false);
    }

    public ForkJoinPool(int n) {
        this(n, defaultForkJoinWorkerThreadFactory, null, false);
    }

    public ForkJoinPool(int n, ForkJoinWorkerThreadFactory forkJoinWorkerThreadFactory, Thread.UncaughtExceptionHandler uncaughtExceptionHandler, boolean bl) {
        ForkJoinPool.checkPermission();
        if (forkJoinWorkerThreadFactory == null) {
            throw new NullPointerException();
        }
        if (n <= 0 || n > Short.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        this.factory = forkJoinWorkerThreadFactory;
        this.ueh = uncaughtExceptionHandler;
        this.config = n | (bl ? 65536 : 0);
        long l = -n;
        this.ctl = l << 48 & 0xFFFF000000000000L | l << 32 & 0xFFFF00000000L;
        int n2 = ForkJoinPool.nextPoolId();
        StringBuilder stringBuilder = new StringBuilder("ForkJoinPool-");
        stringBuilder.append(Integer.toString(n2));
        stringBuilder.append("-worker-");
        this.workerNamePrefix = stringBuilder.toString();
    }

    ForkJoinPool(int n, long l, ForkJoinWorkerThreadFactory forkJoinWorkerThreadFactory, Thread.UncaughtExceptionHandler uncaughtExceptionHandler) {
        this.config = n;
        this.ctl = l;
        this.factory = forkJoinWorkerThreadFactory;
        this.ueh = uncaughtExceptionHandler;
        this.workerNamePrefix = "ForkJoinPool.commonPool-worker-";
    }

    public static ForkJoinPool commonPool() {
        return common;
    }

    public <T> T invoke(ForkJoinTask<T> forkJoinTask) {
        if (forkJoinTask == null) {
            throw new NullPointerException();
        }
        this.externalPush(forkJoinTask);
        return forkJoinTask.join();
    }

    public void execute(ForkJoinTask<?> forkJoinTask) {
        if (forkJoinTask == null) {
            throw new NullPointerException();
        }
        this.externalPush(forkJoinTask);
    }

    @Override
    public void execute(Runnable runnable) {
        if (runnable == null) {
            throw new NullPointerException();
        }
        ForkJoinTask forkJoinTask = runnable instanceof ForkJoinTask ? (ForkJoinTask)((Object)runnable) : new ForkJoinTask.AdaptedRunnableAction(runnable);
        this.externalPush(forkJoinTask);
    }

    public <T> ForkJoinTask<T> submit(ForkJoinTask<T> forkJoinTask) {
        if (forkJoinTask == null) {
            throw new NullPointerException();
        }
        this.externalPush(forkJoinTask);
        return forkJoinTask;
    }

    public <T> ForkJoinTask<T> submit(Callable<T> callable2) {
        ForkJoinTask.AdaptedCallable<T> adaptedCallable = new ForkJoinTask.AdaptedCallable<T>(callable2);
        this.externalPush(adaptedCallable);
        return adaptedCallable;
    }

    public <T> ForkJoinTask<T> submit(Runnable runnable, T t) {
        ForkJoinTask.AdaptedRunnable<T> adaptedRunnable = new ForkJoinTask.AdaptedRunnable<T>(runnable, t);
        this.externalPush(adaptedRunnable);
        return adaptedRunnable;
    }

    public ForkJoinTask<?> submit(Runnable runnable) {
        if (runnable == null) {
            throw new NullPointerException();
        }
        ForkJoinTask forkJoinTask = runnable instanceof ForkJoinTask ? (ForkJoinTask)((Object)runnable) : new ForkJoinTask.AdaptedRunnableAction(runnable);
        this.externalPush(forkJoinTask);
        return forkJoinTask;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> collection) {
        ArrayList<Future<T>> arrayList;
        block7: {
            int n;
            int n2;
            ArrayList<Future<T>> arrayList2 = new ArrayList<Future<T>>(collection.size());
            boolean bl = false;
            try {
                for (Callable<T> callable2 : collection) {
                    ForkJoinTask.AdaptedCallable<T> adaptedCallable = new ForkJoinTask.AdaptedCallable<T>(callable2);
                    arrayList2.add(adaptedCallable);
                    this.externalPush(adaptedCallable);
                }
                n2 = arrayList2.size();
                for (int i = 0; i < n2; ++i) {
                    ((ForkJoinTask)arrayList2.get(i)).quietlyJoin();
                }
                bl = true;
                arrayList = arrayList2;
                if (bl) break block7;
                n = arrayList2.size();
            }
            catch (Throwable throwable2) {
                if (!bl) {
                    int n3 = arrayList2.size();
                    for (int i = 0; i < n3; ++i) {
                        ((Future)arrayList2.get(i)).cancel(false);
                    }
                }
                throw throwable2;
            }
            for (n2 = 0; n2 < n; ++n2) {
                arrayList2.get(n2).cancel(false);
            }
        }
        return arrayList;
    }

    public ForkJoinWorkerThreadFactory getFactory() {
        return this.factory;
    }

    public Thread.UncaughtExceptionHandler getUncaughtExceptionHandler() {
        return this.ueh;
    }

    public int getParallelism() {
        return this.config & 0xFFFF;
    }

    public static int getCommonPoolParallelism() {
        return commonParallelism;
    }

    public int getPoolSize() {
        return (this.config & 0xFFFF) + (short)(this.ctl >>> 32);
    }

    public boolean getAsyncMode() {
        return this.config >>> 16 == 1;
    }

    public int getRunningThreadCount() {
        int n = 0;
        WorkQueue[] workQueueArray = this.workQueues;
        if (this.workQueues != null) {
            for (int i = 1; i < workQueueArray.length; i += 2) {
                WorkQueue workQueue = workQueueArray[i];
                if (workQueue == null || !workQueue.isApparentlyUnblocked()) continue;
                ++n;
            }
        }
        return n;
    }

    public int getActiveThreadCount() {
        int n = (this.config & 0xFFFF) + (int)(this.ctl >> 48);
        return n <= 0 ? 0 : n;
    }

    public boolean isQuiescent() {
        return (int)(this.ctl >> 48) + (this.config & 0xFFFF) == 0;
    }

    public long getStealCount() {
        long l = this.stealCount;
        WorkQueue[] workQueueArray = this.workQueues;
        if (this.workQueues != null) {
            for (int i = 1; i < workQueueArray.length; i += 2) {
                WorkQueue workQueue = workQueueArray[i];
                if (workQueue == null) continue;
                l += (long)workQueue.nsteals;
            }
        }
        return l;
    }

    public long getQueuedTaskCount() {
        long l = 0L;
        WorkQueue[] workQueueArray = this.workQueues;
        if (this.workQueues != null) {
            for (int i = 1; i < workQueueArray.length; i += 2) {
                WorkQueue workQueue = workQueueArray[i];
                if (workQueue == null) continue;
                l += (long)workQueue.queueSize();
            }
        }
        return l;
    }

    public int getQueuedSubmissionCount() {
        int n = 0;
        WorkQueue[] workQueueArray = this.workQueues;
        if (this.workQueues != null) {
            for (int i = 0; i < workQueueArray.length; i += 2) {
                WorkQueue workQueue = workQueueArray[i];
                if (workQueue == null) continue;
                n += workQueue.queueSize();
            }
        }
        return n;
    }

    public boolean hasQueuedSubmissions() {
        WorkQueue[] workQueueArray = this.workQueues;
        if (this.workQueues != null) {
            for (int i = 0; i < workQueueArray.length; i += 2) {
                WorkQueue workQueue = workQueueArray[i];
                if (workQueue == null || workQueue.isEmpty()) continue;
                return true;
            }
        }
        return false;
    }

    protected ForkJoinTask<?> pollSubmission() {
        WorkQueue[] workQueueArray = this.workQueues;
        if (this.workQueues != null) {
            for (int i = 0; i < workQueueArray.length; i += 2) {
                ForkJoinTask<?> forkJoinTask;
                WorkQueue workQueue = workQueueArray[i];
                if (workQueue == null || (forkJoinTask = workQueue.poll()) == null) continue;
                return forkJoinTask;
            }
        }
        return null;
    }

    protected int drainTasksTo(Collection<? super ForkJoinTask<?>> collection) {
        int n = 0;
        WorkQueue[] workQueueArray = this.workQueues;
        if (this.workQueues != null) {
            for (int i = 0; i < workQueueArray.length; ++i) {
                ForkJoinTask<?> forkJoinTask;
                WorkQueue workQueue = workQueueArray[i];
                if (workQueue == null) continue;
                while ((forkJoinTask = workQueue.poll()) != null) {
                    collection.add(forkJoinTask);
                    ++n;
                }
            }
        }
        return n;
    }

    public String toString() {
        int n;
        int n2;
        long l = 0L;
        long l2 = 0L;
        int n3 = 0;
        long l3 = this.stealCount;
        long l4 = this.ctl;
        WorkQueue[] workQueueArray = this.workQueues;
        if (this.workQueues != null) {
            for (n2 = 0; n2 < workQueueArray.length; ++n2) {
                WorkQueue workQueue = workQueueArray[n2];
                if (workQueue == null) continue;
                n = workQueue.queueSize();
                if ((n2 & 1) == 0) {
                    l2 += (long)n;
                    continue;
                }
                l += (long)n;
                l3 += (long)workQueue.nsteals;
                if (!workQueue.isApparentlyUnblocked()) continue;
                ++n3;
            }
        }
        n2 = this.config & 0xFFFF;
        n = n2 + (short)(l4 >>> 32);
        int n4 = n2 + (int)(l4 >> 48);
        if (n4 < 0) {
            n4 = 0;
        }
        String string2 = (l4 & 0x80000000L) != 0L ? (n == 0 ? "Terminated" : "Terminating") : (this.plock < 0 ? "Shutting down" : "Running");
        return super.toString() + "[" + string2 + ", parallelism = " + n2 + ", size = " + n + ", active = " + n4 + ", running = " + n3 + ", steals = " + l3 + ", tasks = " + l + ", submissions = " + l2 + "]";
    }

    @Override
    public void shutdown() {
        ForkJoinPool.checkPermission();
        this.tryTerminate(false, true);
    }

    @Override
    public List<Runnable> shutdownNow() {
        ForkJoinPool.checkPermission();
        this.tryTerminate(true, true);
        return Collections.emptyList();
    }

    @Override
    public boolean isTerminated() {
        long l = this.ctl;
        return (l & 0x80000000L) != 0L && (short)(l >>> 32) == -(this.config & 0xFFFF);
    }

    public boolean isTerminating() {
        long l = this.ctl;
        return (l & 0x80000000L) != 0L && (short)(l >>> 32) != -(this.config & 0xFFFF);
    }

    @Override
    public boolean isShutdown() {
        return this.plock < 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean awaitTermination(long l, TimeUnit timeUnit) throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        if (this == common) {
            this.awaitQuiescence(l, timeUnit);
            return false;
        }
        long l2 = timeUnit.toNanos(l);
        if (this.isTerminated()) {
            return true;
        }
        long l3 = System.nanoTime();
        boolean bl = false;
        ForkJoinPool forkJoinPool = this;
        synchronized (forkJoinPool) {
            long l4 = l2;
            long l5 = 0L;
            while (!(bl = this.isTerminated() || l4 <= 0L || (l5 = timeUnit.toMillis(l4)) <= 0L)) {
                this.wait(l5);
                l4 = l2 - (System.nanoTime() - l3);
            }
        }
        return bl;
    }

    public boolean awaitQuiescence(long l, TimeUnit timeUnit) {
        long l2 = timeUnit.toNanos(l);
        Thread thread = Thread.currentThread();
        if (thread instanceof ForkJoinWorkerThread) {
            ForkJoinWorkerThread forkJoinWorkerThread = (ForkJoinWorkerThread)thread;
            if (forkJoinWorkerThread.pool == this) {
                this.helpQuiescePool(forkJoinWorkerThread.workQueue);
                return true;
            }
        }
        long l3 = System.nanoTime();
        int n = 0;
        boolean bl = true;
        block0: while (!this.isQuiescent()) {
            int n2;
            WorkQueue[] workQueueArray = this.workQueues;
            if (this.workQueues == null || (n2 = workQueueArray.length - 1) < 0) break;
            if (!bl) {
                if (System.nanoTime() - l3 > l2) {
                    return false;
                }
                Thread.yield();
            }
            bl = false;
            for (int i = n2 + 1 << 2; i >= 0; --i) {
                int n3;
                WorkQueue workQueue;
                if ((workQueue = workQueueArray[n++ & n2]) == null || (n3 = workQueue.base) - workQueue.top >= 0) continue;
                bl = true;
                ForkJoinTask<?> forkJoinTask = workQueue.pollAt(n3);
                if (forkJoinTask == null) continue block0;
                if (workQueue.base - workQueue.top < 0) {
                    this.signalWork(workQueue);
                }
                forkJoinTask.doExec();
                continue block0;
            }
        }
        return true;
    }

    static void quiesceCommonPool() {
        common.awaitQuiescence(Long.MAX_VALUE, TimeUnit.NANOSECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void managedBlock(ManagedBlocker managedBlocker) throws InterruptedException {
        Thread thread = Thread.currentThread();
        if (thread instanceof ForkJoinWorkerThread) {
            ForkJoinPool forkJoinPool = ((ForkJoinWorkerThread)thread).pool;
            while (!managedBlocker.isReleasable()) {
                int n;
                WorkQueue[] workQueueArray = forkJoinPool.workQueues;
                if (forkJoinPool.workQueues != null && (n = workQueueArray.length - 1) >= 0) {
                    for (int i = 0; i <= n; ++i) {
                        if (managedBlocker.isReleasable()) {
                            return;
                        }
                        WorkQueue workQueue = workQueueArray[i];
                        if (workQueue == null || workQueue.base - workQueue.top >= 0) continue;
                        forkJoinPool.signalWork(workQueue);
                        int n2 = (int)(forkJoinPool.ctl >>> 32);
                        if (n2 >= 0 || n2 >> 16 >= 0) break;
                    }
                }
                if (!forkJoinPool.tryCompensate()) continue;
                try {
                    while (!managedBlocker.isReleasable() && !managedBlocker.block()) {
                    }
                    break;
                }
                finally {
                    forkJoinPool.incrementActiveCount();
                }
            }
        } else {
            while (!managedBlocker.isReleasable() && !managedBlocker.block()) {
            }
        }
    }

    @Override
    protected <T> RunnableFuture<T> newTaskFor(Runnable runnable, T t) {
        return new ForkJoinTask.AdaptedRunnable<T>(runnable, t);
    }

    @Override
    protected <T> RunnableFuture<T> newTaskFor(Callable<T> callable2) {
        return new ForkJoinTask.AdaptedCallable<T>(callable2);
    }

    private static Unsafe getUnsafe() {
        return akka.util.Unsafe.instance;
    }

    static {
        Object object;
        Object object2;
        Object object3;
        PL_SPINS = Integer.getInteger("akka.dispatch.forkjoin.spins", 256);
        try {
            U = ForkJoinPool.getUnsafe();
            object3 = ForkJoinPool.class;
            CTL = U.objectFieldOffset(((Class)object3).getDeclaredField("ctl"));
            STEALCOUNT = U.objectFieldOffset(((Class)object3).getDeclaredField("stealCount"));
            PLOCK = U.objectFieldOffset(((Class)object3).getDeclaredField("plock"));
            INDEXSEED = U.objectFieldOffset(((Class)object3).getDeclaredField("indexSeed"));
            Class<Thread> clazz = Thread.class;
            PARKBLOCKER = U.objectFieldOffset(clazz.getDeclaredField("parkBlocker"));
            object2 = WorkQueue.class;
            QLOCK = U.objectFieldOffset(((Class)object2).getDeclaredField("qlock"));
            object = ForkJoinTask[].class;
            ABASE = U.arrayBaseOffset((Class<?>)object);
            int n = U.arrayIndexScale((Class<?>)object);
            if ((n & n - 1) != 0) {
                throw new Error("data type scale not a power of two");
            }
            ASHIFT = 31 - Integer.numberOfLeadingZeros(n);
        }
        catch (Exception exception) {
            throw new Error(exception);
        }
        submitters = new ThreadLocal();
        defaultForkJoinWorkerThreadFactory = new DefaultForkJoinWorkerThreadFactory();
        object3 = defaultForkJoinWorkerThreadFactory;
        modifyThreadPermission = new RuntimePermission("modifyThread");
        int n = 0;
        object2 = null;
        try {
            object = System.getProperty("java.util.concurrent.ForkJoinPool.common.parallelism");
            String string2 = System.getProperty("java.util.concurrent.ForkJoinPool.common.exceptionHandler");
            String string3 = System.getProperty("java.util.concurrent.ForkJoinPool.common.threadFactory");
            if (string3 != null) {
                object3 = (ForkJoinWorkerThreadFactory)ClassLoader.getSystemClassLoader().loadClass(string3).newInstance();
            }
            if (string2 != null) {
                object2 = (Thread.UncaughtExceptionHandler)ClassLoader.getSystemClassLoader().loadClass(string2).newInstance();
            }
            if (object != null) {
                n = Integer.parseInt((String)object);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (n <= 0) {
            n = Runtime.getRuntime().availableProcessors();
        }
        if (n > Short.MAX_VALUE) {
            n = Short.MAX_VALUE;
        }
        commonParallelism = n;
        long l = -n;
        long l2 = l << 48 & 0xFFFF000000000000L | l << 32 & 0xFFFF00000000L;
        common = new ForkJoinPool(n, l2, (ForkJoinWorkerThreadFactory)object3, (Thread.UncaughtExceptionHandler)object2);
    }

    public static interface ManagedBlocker {
        public boolean block() throws InterruptedException;

        public boolean isReleasable();
    }

    static final class WorkQueue {
        static final int INITIAL_QUEUE_CAPACITY = 8192;
        static final int MAXIMUM_QUEUE_CAPACITY = 0x4000000;
        volatile long pad00;
        volatile long pad01;
        volatile long pad02;
        volatile long pad03;
        volatile long pad04;
        volatile long pad05;
        volatile long pad06;
        int seed;
        volatile int eventCount;
        int nextWait;
        int hint;
        int poolIndex;
        final int mode;
        int nsteals;
        volatile int qlock;
        volatile int base;
        int top;
        ForkJoinTask<?>[] array;
        final ForkJoinPool pool;
        final ForkJoinWorkerThread owner;
        volatile Thread parker;
        volatile ForkJoinTask<?> currentJoin;
        ForkJoinTask<?> currentSteal;
        volatile Object pad10;
        volatile Object pad11;
        volatile Object pad12;
        volatile Object pad13;
        volatile Object pad14;
        volatile Object pad15;
        volatile Object pad16;
        volatile Object pad17;
        volatile Object pad18;
        volatile Object pad19;
        volatile Object pad1a;
        volatile Object pad1b;
        volatile Object pad1c;
        volatile Object pad1d;
        private static final Unsafe U;
        private static final long QLOCK;
        private static final int ABASE;
        private static final int ASHIFT;

        WorkQueue(ForkJoinPool forkJoinPool, ForkJoinWorkerThread forkJoinWorkerThread, int n, int n2) {
            this.pool = forkJoinPool;
            this.owner = forkJoinWorkerThread;
            this.mode = n;
            this.seed = n2;
            this.top = 4096;
            this.base = 4096;
        }

        final int queueSize() {
            int n = this.base - this.top;
            return n >= 0 ? 0 : -n;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        final boolean isEmpty() {
            int n = this.top;
            int n2 = this.base - n;
            if (n2 >= 0) return true;
            if (n2 != -1) return false;
            ForkJoinTask<?>[] forkJoinTaskArray = this.array;
            if (this.array == null) return true;
            int n3 = forkJoinTaskArray.length - 1;
            if (n3 < 0) return true;
            if (U.getObject(forkJoinTaskArray, (long)((n3 & n - 1) << ASHIFT) + (long)ABASE) != null) return false;
            return true;
        }

        final void push(ForkJoinTask<?> forkJoinTask) {
            int n = this.top;
            ForkJoinTask<?>[] forkJoinTaskArray = this.array;
            if (this.array != null) {
                int n2 = forkJoinTaskArray.length - 1;
                int n3 = ((n2 & n) << ASHIFT) + ABASE;
                U.putOrderedObject(forkJoinTaskArray, n3, forkJoinTask);
                this.top = n + 1;
                int n4 = this.top - this.base;
                if (n4 <= 2) {
                    ForkJoinPool forkJoinPool = this.pool;
                    if (forkJoinPool != null) {
                        forkJoinPool.signalWork(this);
                    }
                } else if (n4 >= n2) {
                    this.growArray();
                }
            }
        }

        final ForkJoinTask<?>[] growArray() {
            int n;
            int n2;
            int n3;
            int n4;
            ForkJoinTask<?>[] forkJoinTaskArray = this.array;
            int n5 = n4 = forkJoinTaskArray != null ? forkJoinTaskArray.length << 1 : 8192;
            if (n4 > 0x4000000) {
                throw new RejectedExecutionException("Queue capacity exceeded");
            }
            this.array = new ForkJoinTask[n4];
            ForkJoinTask[] forkJoinTaskArray2 = this.array;
            if (forkJoinTaskArray != null && (n3 = forkJoinTaskArray.length - 1) >= 0 && (n2 = this.top) - (n = this.base) > 0) {
                int n6 = n4 - 1;
                do {
                    int n7 = ((n & n3) << ASHIFT) + ABASE;
                    int n8 = ((n & n6) << ASHIFT) + ABASE;
                    ForkJoinTask forkJoinTask = (ForkJoinTask)U.getObjectVolatile(forkJoinTaskArray, n7);
                    if (forkJoinTask == null || !U.compareAndSwapObject(forkJoinTaskArray, n7, forkJoinTask, null)) continue;
                    U.putObjectVolatile(forkJoinTaskArray2, n8, forkJoinTask);
                } while (++n != n2);
            }
            return forkJoinTaskArray2;
        }

        final ForkJoinTask<?> pop() {
            int n;
            ForkJoinTask<?>[] forkJoinTaskArray = this.array;
            if (this.array != null && (n = forkJoinTaskArray.length - 1) >= 0) {
                long l;
                ForkJoinTask forkJoinTask;
                int n2;
                while ((n2 = this.top - 1) - this.base >= 0 && (forkJoinTask = (ForkJoinTask)U.getObject(forkJoinTaskArray, l = (long)(((n & n2) << ASHIFT) + ABASE))) != null) {
                    if (!U.compareAndSwapObject(forkJoinTaskArray, l, forkJoinTask, null)) continue;
                    this.top = n2;
                    return forkJoinTask;
                }
            }
            return null;
        }

        final ForkJoinTask<?> pollAt(int n) {
            int n2;
            ForkJoinTask forkJoinTask;
            ForkJoinTask<?>[] forkJoinTaskArray = this.array;
            if (this.array != null && (forkJoinTask = (ForkJoinTask)U.getObjectVolatile(forkJoinTaskArray, n2 = ((forkJoinTaskArray.length - 1 & n) << ASHIFT) + ABASE)) != null && this.base == n && U.compareAndSwapObject(forkJoinTaskArray, n2, forkJoinTask, null)) {
                this.base = n + 1;
                return forkJoinTask;
            }
            return null;
        }

        final ForkJoinTask<?> poll() {
            int n;
            while ((n = this.base) - this.top < 0) {
                ForkJoinTask<?>[] forkJoinTaskArray = this.array;
                if (this.array == null) break;
                int n2 = ((forkJoinTaskArray.length - 1 & n) << ASHIFT) + ABASE;
                ForkJoinTask forkJoinTask = (ForkJoinTask)U.getObjectVolatile(forkJoinTaskArray, n2);
                if (forkJoinTask != null) {
                    if (this.base != n || !U.compareAndSwapObject(forkJoinTaskArray, n2, forkJoinTask, null)) continue;
                    this.base = n + 1;
                    return forkJoinTask;
                }
                if (this.base != n) continue;
                if (n + 1 == this.top) break;
                Thread.yield();
            }
            return null;
        }

        final ForkJoinTask<?> nextLocalTask() {
            return this.mode == 0 ? this.pop() : this.poll();
        }

        final ForkJoinTask<?> peek() {
            int n;
            ForkJoinTask<?>[] forkJoinTaskArray = this.array;
            if (forkJoinTaskArray == null || (n = forkJoinTaskArray.length - 1) < 0) {
                return null;
            }
            int n2 = this.mode == 0 ? this.top - 1 : this.base;
            int n3 = ((n2 & n) << ASHIFT) + ABASE;
            return (ForkJoinTask)U.getObjectVolatile(forkJoinTaskArray, n3);
        }

        final boolean tryUnpush(ForkJoinTask<?> forkJoinTask) {
            int n;
            ForkJoinTask<?>[] forkJoinTaskArray = this.array;
            if (this.array != null && (n = this.top) != this.base && U.compareAndSwapObject(forkJoinTaskArray, ((forkJoinTaskArray.length - 1 & --n) << ASHIFT) + ABASE, forkJoinTask, null)) {
                this.top = n;
                return true;
            }
            return false;
        }

        final void cancelAll() {
            ForkJoinTask<?> forkJoinTask;
            ForkJoinTask.cancelIgnoringExceptions(this.currentJoin);
            ForkJoinTask.cancelIgnoringExceptions(this.currentSteal);
            while ((forkJoinTask = this.poll()) != null) {
                ForkJoinTask.cancelIgnoringExceptions(forkJoinTask);
            }
        }

        final int nextSeed() {
            int n = this.seed;
            n ^= n << 13;
            n ^= n >>> 17;
            n ^= n << 5;
            this.seed = n;
            return n;
        }

        private void popAndExecAll() {
            while (true) {
                long l;
                ForkJoinTask forkJoinTask;
                int n;
                int n2;
                ForkJoinTask<?>[] forkJoinTaskArray = this.array;
                if (this.array == null || (n2 = forkJoinTaskArray.length - 1) < 0 || (n = this.top - 1) - this.base < 0 || (forkJoinTask = (ForkJoinTask)U.getObject(forkJoinTaskArray, l = (long)(((n2 & n) << ASHIFT) + ABASE))) == null) break;
                if (!U.compareAndSwapObject(forkJoinTaskArray, l, forkJoinTask, null)) continue;
                this.top = n;
                forkJoinTask.doExec();
            }
        }

        private void pollAndExecAll() {
            ForkJoinTask<?> forkJoinTask;
            while ((forkJoinTask = this.poll()) != null) {
                forkJoinTask.doExec();
            }
        }

        final boolean tryRemoveAndExec(ForkJoinTask<?> forkJoinTask) {
            int n;
            int n2;
            int n3;
            int n4;
            boolean bl = true;
            boolean bl2 = false;
            boolean bl3 = true;
            ForkJoinTask<?>[] forkJoinTaskArray = this.array;
            if (this.array != null && (n4 = forkJoinTaskArray.length - 1) >= 0 && (n3 = (n2 = this.top) - (n = this.base)) > 0) {
                int n5;
                ForkJoinTask forkJoinTask2;
                while ((forkJoinTask2 = (ForkJoinTask)U.getObjectVolatile(forkJoinTaskArray, n5 = ((--n2 & n4) << ASHIFT) + ABASE)) != null) {
                    if (forkJoinTask2 == forkJoinTask) {
                        if (n2 + 1 == this.top) {
                            if (!U.compareAndSwapObject(forkJoinTaskArray, n5, forkJoinTask, null)) break;
                            this.top = n2;
                            bl2 = true;
                            break;
                        }
                        if (this.base != n) break;
                        bl2 = U.compareAndSwapObject(forkJoinTaskArray, n5, forkJoinTask, new EmptyTask());
                        break;
                    }
                    if (forkJoinTask2.status >= 0) {
                        bl3 = false;
                    } else if (n2 + 1 == this.top) {
                        if (!U.compareAndSwapObject(forkJoinTaskArray, n5, forkJoinTask2, null)) break;
                        this.top = n2;
                        break;
                    }
                    if (--n3 != 0) continue;
                    if (bl3 || this.base != n) break;
                    bl = false;
                    break;
                }
            }
            if (bl2) {
                forkJoinTask.doExec();
            }
            return bl;
        }

        final boolean pollAndExecCC(ForkJoinTask<?> forkJoinTask) {
            int n;
            block0: while ((n = this.base) - this.top < 0) {
                CountedCompleter<?> countedCompleter;
                long l;
                Object object;
                ForkJoinTask<?>[] forkJoinTaskArray = this.array;
                if (this.array == null || (object = U.getObject(forkJoinTaskArray, l = (long)(((forkJoinTaskArray.length - 1 & n) << ASHIFT) + ABASE))) == null || !(object instanceof CountedCompleter)) break;
                CountedCompleter<?> countedCompleter2 = countedCompleter = (CountedCompleter<?>)object;
                do {
                    if (countedCompleter2 != forkJoinTask) continue;
                    if (this.base != n || !U.compareAndSwapObject(forkJoinTaskArray, l, countedCompleter, null)) continue block0;
                    this.base = n + 1;
                    countedCompleter.doExec();
                    return true;
                } while ((countedCompleter2 = countedCompleter2.completer) != null);
                break;
            }
            return false;
        }

        final void runTask(ForkJoinTask<?> forkJoinTask) {
            if (forkJoinTask != null) {
                this.currentSteal = forkJoinTask;
                this.currentSteal.doExec();
                this.currentSteal = null;
                ++this.nsteals;
                if (this.base - this.top < 0) {
                    if (this.mode == 0) {
                        this.popAndExecAll();
                    } else {
                        this.pollAndExecAll();
                    }
                }
            }
        }

        final void runSubtask(ForkJoinTask<?> forkJoinTask) {
            if (forkJoinTask != null) {
                ForkJoinTask<?> forkJoinTask2 = this.currentSteal;
                this.currentSteal = forkJoinTask;
                this.currentSteal.doExec();
                this.currentSteal = forkJoinTask2;
            }
        }

        final boolean isApparentlyUnblocked() {
            Thread.State state2;
            ForkJoinWorkerThread forkJoinWorkerThread;
            return this.eventCount >= 0 && (forkJoinWorkerThread = this.owner) != null && (state2 = forkJoinWorkerThread.getState()) != Thread.State.BLOCKED && state2 != Thread.State.WAITING && state2 != Thread.State.TIMED_WAITING;
        }

        static {
            try {
                U = ForkJoinPool.getUnsafe();
                Class<WorkQueue> clazz = WorkQueue.class;
                Class<ForkJoinTask[]> clazz2 = ForkJoinTask[].class;
                QLOCK = U.objectFieldOffset(clazz.getDeclaredField("qlock"));
                ABASE = U.arrayBaseOffset(clazz2);
                int n = U.arrayIndexScale(clazz2);
                if ((n & n - 1) != 0) {
                    throw new Error("data type scale not a power of two");
                }
                ASHIFT = 31 - Integer.numberOfLeadingZeros(n);
            }
            catch (Exception exception) {
                throw new Error(exception);
            }
        }
    }

    static final class EmptyTask
    extends ForkJoinTask<Void> {
        private static final long serialVersionUID = -7721805057305804111L;

        EmptyTask() {
            this.status = -268435456;
        }

        @Override
        public final Void getRawResult() {
            return null;
        }

        @Override
        public final void setRawResult(Void void_) {
        }

        @Override
        public final boolean exec() {
            return true;
        }
    }

    static final class Submitter {
        int seed;

        Submitter(int n) {
            this.seed = n;
        }
    }

    static final class DefaultForkJoinWorkerThreadFactory
    implements ForkJoinWorkerThreadFactory {
        DefaultForkJoinWorkerThreadFactory() {
        }

        @Override
        public final ForkJoinWorkerThread newThread(ForkJoinPool forkJoinPool) {
            return new ForkJoinWorkerThread(forkJoinPool);
        }
    }

    public static interface ForkJoinWorkerThreadFactory {
        public ForkJoinWorkerThread newThread(ForkJoinPool var1);
    }
}

