/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.jdbc.trace;

import java.sql.CallableStatement;
import java.sql.SQLException;
import org.apache.skywalking.apm.agent.core.context.ContextManager;
import org.apache.skywalking.apm.agent.core.context.tag.Tags;
import org.apache.skywalking.apm.agent.core.context.trace.AbstractSpan;
import org.apache.skywalking.apm.agent.core.context.trace.SpanLayer;
import org.apache.skywalking.apm.network.trace.component.Component;
import org.apache.skywalking.apm.plugin.jdbc.trace.ConnectionInfo;

public class CallableStatementTracing {
    public static <R> R execute(CallableStatement realStatement, ConnectionInfo connectInfo, String method, String sql, Executable<R> exec) throws SQLException {
        AbstractSpan span = ContextManager.createExitSpan((String)(connectInfo.getDBType() + "/JDBI/CallableStatement/" + method), (String)connectInfo.getDatabasePeer());
        try {
            Tags.DB_TYPE.set(span, "sql");
            SpanLayer.asDB((AbstractSpan)span);
            Tags.DB_INSTANCE.set(span, connectInfo.getDatabaseName());
            Tags.DB_STATEMENT.set(span, sql);
            span.setComponent((Component)connectInfo.getComponent());
            R r = exec.exe(realStatement, sql);
            return r;
        }
        catch (SQLException e) {
            span.log((Throwable)e);
            throw e;
        }
        finally {
            ContextManager.stopSpan((AbstractSpan)span);
        }
    }

    public static interface Executable<R> {
        public R exe(CallableStatement var1, String var2) throws SQLException;
    }
}

