/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.common.task.engine;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.common.lifecycle.Closeable;
import com.alibaba.nacos.common.task.AbstractExecuteTask;
import com.alibaba.nacos.common.task.NacosTask;
import com.alibaba.nacos.common.task.NacosTaskProcessor;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TaskExecuteWorker
implements NacosTaskProcessor,
Closeable {
    private static final int QUEUE_CAPACITY = 32768;
    private final Logger log;
    private final String name;
    private final BlockingQueue<Runnable> queue;
    private final AtomicBoolean closed;

    public TaskExecuteWorker(String name, int mod, int total) {
        this(name, mod, total, null);
    }

    public TaskExecuteWorker(String name, int mod, int total, Logger logger) {
        this.name = name + "_" + mod + "%" + total;
        this.queue = new ArrayBlockingQueue<Runnable>(32768);
        this.closed = new AtomicBoolean(false);
        this.log = null == logger ? LoggerFactory.getLogger(TaskExecuteWorker.class) : logger;
        new InnerWorker(name).start();
    }

    public String getName() {
        return this.name;
    }

    @Override
    public boolean process(NacosTask task) {
        if (task instanceof AbstractExecuteTask) {
            this.putTask((Runnable)((Object)task));
        }
        return true;
    }

    private void putTask(Runnable task) {
        try {
            this.queue.put(task);
        }
        catch (InterruptedException ire) {
            this.log.error(ire.toString(), (Throwable)ire);
        }
    }

    public int pendingTaskCount() {
        return this.queue.size();
    }

    public String status() {
        return this.name + ", pending tasks: " + this.pendingTaskCount();
    }

    @Override
    public void shutdown() throws NacosException {
        this.queue.clear();
        this.closed.compareAndSet(false, true);
    }

    private class InnerWorker
    extends Thread {
        InnerWorker(String name) {
            this.setDaemon(false);
            this.setName(name);
        }

        @Override
        public void run() {
            while (!TaskExecuteWorker.this.closed.get()) {
                try {
                    Runnable task = (Runnable)TaskExecuteWorker.this.queue.take();
                    long begin = System.currentTimeMillis();
                    task.run();
                    long duration = System.currentTimeMillis() - begin;
                    if (duration <= 1000L) continue;
                    TaskExecuteWorker.this.log.warn("distro task {} takes {}ms", (Object)task, (Object)duration);
                }
                catch (Throwable e) {
                    TaskExecuteWorker.this.log.error("[DISTRO-FAILED] " + e.toString(), e);
                }
            }
        }
    }
}

