/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.agent.core.remote;

import java.util.LinkedList;
import java.util.List;
import org.apache.skywalking.apm.agent.core.remote.ChannelBuilder;
import org.apache.skywalking.apm.agent.core.remote.ChannelDecorator;
import org.apache.skywalking.apm.dependencies.io.grpc.Channel;
import org.apache.skywalking.apm.dependencies.io.grpc.ConnectivityState;
import org.apache.skywalking.apm.dependencies.io.grpc.ManagedChannel;
import org.apache.skywalking.apm.dependencies.io.grpc.ManagedChannelBuilder;
import org.apache.skywalking.apm.dependencies.io.grpc.netty.NettyChannelBuilder;

public class GRPCChannel {
    private final ManagedChannel originChannel;
    private final Channel channelWithDecorators;

    private GRPCChannel(String host, int port, List<ChannelBuilder> channelBuilders, List<ChannelDecorator> decorators) throws Exception {
        NettyChannelBuilder channelBuilder = NettyChannelBuilder.forAddress(host, port);
        for (ChannelBuilder builder : channelBuilders) {
            channelBuilder = builder.build(channelBuilder);
        }
        Channel channel = this.originChannel = ((ManagedChannelBuilder)channelBuilder).build();
        for (ChannelDecorator decorator : decorators) {
            channel = decorator.build(channel);
        }
        this.channelWithDecorators = channel;
    }

    public static Builder newBuilder(String host, int port) {
        return new Builder(host, port);
    }

    public Channel getChannel() {
        return this.channelWithDecorators;
    }

    public boolean isTerminated() {
        return this.originChannel.isTerminated();
    }

    public void shutdownNow() {
        this.originChannel.shutdownNow();
    }

    public boolean isShutdown() {
        return this.originChannel.isShutdown();
    }

    public boolean isConnected() {
        return this.isConnected(false);
    }

    public boolean isConnected(boolean requestConnection) {
        return this.originChannel.getState(requestConnection) == ConnectivityState.READY;
    }

    public static class Builder {
        private final String host;
        private final int port;
        private final List<ChannelBuilder> channelBuilders;
        private final List<ChannelDecorator> decorators;

        private Builder(String host, int port) {
            this.host = host;
            this.port = port;
            this.channelBuilders = new LinkedList<ChannelBuilder>();
            this.decorators = new LinkedList<ChannelDecorator>();
        }

        public Builder addChannelDecorator(ChannelDecorator interceptor) {
            this.decorators.add(interceptor);
            return this;
        }

        public GRPCChannel build() throws Exception {
            return new GRPCChannel(this.host, this.port, this.channelBuilders, this.decorators);
        }

        public Builder addManagedChannelBuilder(ChannelBuilder builder) {
            this.channelBuilders.add(builder);
            return this;
        }
    }
}

