/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.agent.core.meter;

import java.util.List;
import java.util.Objects;
import org.apache.skywalking.apm.agent.core.meter.MeterId;
import org.apache.skywalking.apm.agent.core.meter.MeterTag;
import org.apache.skywalking.apm.network.language.agent.v3.Label;
import org.apache.skywalking.apm.network.language.agent.v3.MeterData;

public abstract class BaseMeter {
    protected final MeterId meterId;

    public BaseMeter(MeterId meterId) {
        this.meterId = meterId;
    }

    public String getName() {
        return this.meterId.getName();
    }

    public String getTag(String tagKey) {
        for (MeterTag tag : this.meterId.getTags()) {
            if (!tag.getKey().equals(tagKey)) continue;
            return tag.getValue();
        }
        return null;
    }

    public abstract MeterData.Builder transform();

    public List<Label> transformTags() {
        return this.getId().transformTags();
    }

    public MeterId getId() {
        return this.meterId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BaseMeter baseMeter = (BaseMeter)o;
        return Objects.equals(this.meterId, baseMeter.meterId);
    }

    public int hashCode() {
        return Objects.hash(this.meterId);
    }
}

