/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fury.memory;

import org.apache.fury.memory.MemoryBuffer;

public class BitUtils {
    private static final int WORD_SIZE = 8;

    public static void set(MemoryBuffer bitmapBuffer, int baseOffset, int index) {
        int byteIndex = baseOffset + (index >> 3);
        int bitIndex = index & 7;
        byte currentByte = bitmapBuffer.getByte(byteIndex);
        byte bitMask = (byte)(1L << bitIndex);
        currentByte = (byte)(currentByte | bitMask);
        bitmapBuffer.putByte(byteIndex, currentByte);
    }

    public static void setAll(MemoryBuffer bitmapBuffer, int baseOffset, int valueCount) {
        int sizeInBytes = (valueCount + 7) / 8;
        int remainder = valueCount % 8;
        int sizeInBytesMinus1 = sizeInBytes - 1;
        int bytesMinus1EndOffset = baseOffset + sizeInBytesMinus1;
        for (int i = baseOffset; i < bytesMinus1EndOffset; ++i) {
            bitmapBuffer.putByte(i, (byte)-1);
        }
        if (remainder != 0) {
            byte byteValue = (byte)(255 >>> 8 - remainder);
            bitmapBuffer.putByte(baseOffset + sizeInBytesMinus1, byteValue);
        }
    }

    public static void unset(MemoryBuffer bitmapBuffer, int baseOffset, int index) {
        BitUtils.setBit(bitmapBuffer, baseOffset, index, 0);
    }

    public static void setBit(MemoryBuffer bitmapBuffer, int baseOffset, int index, int value) {
        int byteIndex = baseOffset + (index >> 3);
        int bitIndex = index & 7;
        byte current = bitmapBuffer.getByte(byteIndex);
        byte bitMask = (byte)(1L << bitIndex);
        current = value != 0 ? (byte)(current | bitMask) : (byte)(current - (bitMask & current));
        bitmapBuffer.putByte(byteIndex, current);
    }

    public static boolean isSet(MemoryBuffer bitmapBuffer, int baseOffset, int index) {
        int byteIndex = baseOffset + (index >> 3);
        int bitIndex = index & 7;
        byte b = bitmapBuffer.getByte(byteIndex);
        return (b >> bitIndex & 1) != 0;
    }

    public static boolean isNotSet(MemoryBuffer bitmapBuffer, int baseOffset, int index) {
        int byteIndex = baseOffset + (index >> 3);
        int bitIndex = index & 7;
        byte b = bitmapBuffer.getByte(byteIndex);
        return (b >> bitIndex & 1) == 0;
    }

    public static boolean anySet(MemoryBuffer bitmapBuffer, int baseOffset, int bitmapWidthInBytes) {
        int addr = baseOffset;
        int bitmapWidthInWords = bitmapWidthInBytes / 8;
        int i = 0;
        while (i < bitmapWidthInWords) {
            if (bitmapBuffer.getInt64(addr) != 0L) {
                return true;
            }
            ++i;
            addr += 8;
        }
        return false;
    }

    public static boolean anyUnSet(MemoryBuffer bitmapBuffer, int baseOffset, int valueCount) {
        int sizeInBytes = (valueCount + 7) / 8;
        int remainder = valueCount % 8;
        int sizeInBytesMinus1 = sizeInBytes - 1;
        int bytesMinus1EndOffset = baseOffset + sizeInBytesMinus1;
        for (int i = baseOffset; i < bytesMinus1EndOffset; ++i) {
            if (bitmapBuffer.getByte(i) == -1) continue;
            return true;
        }
        if (remainder != 0) {
            byte mask;
            byte byteValue = bitmapBuffer.getByte(baseOffset + sizeInBytesMinus1);
            return byteValue != (mask = (byte)(255 >>> 8 - remainder));
        }
        return false;
    }

    public static int getNullCount(MemoryBuffer bitmapBuffer, int baseOffset, int valueCount) {
        int count = 0;
        int sizeInBytes = (valueCount + 7) / 8;
        int remainder = valueCount % 8;
        int sizeInBytesMinus1 = sizeInBytes - 1;
        int bytesMinus1EndOffset = baseOffset + sizeInBytesMinus1;
        for (int i = baseOffset; i < bytesMinus1EndOffset; ++i) {
            byte byteValue = bitmapBuffer.getByte(i);
            count += Integer.bitCount(byteValue & 0xFF);
        }
        byte byteValue = bitmapBuffer.getByte(baseOffset + sizeInBytesMinus1);
        if (remainder != 0) {
            byte mask = (byte)(255 << remainder);
            byteValue = (byte)(byteValue | mask);
        }
        return 8 * sizeInBytes - (count += Integer.bitCount(byteValue & 0xFF));
    }

    public static int calculateBitmapWidthInBytes(int numFields) {
        return (numFields + 63) / 64 * 8;
    }
}

