/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.core.rpc.netty.http;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.handler.codec.http.multipart.Attribute;
import io.netty.handler.codec.http.multipart.HttpPostRequestDecoder;
import io.netty.handler.codec.http.multipart.InterfaceHttpData;
import io.netty.util.concurrent.GenericFutureListener;
import java.lang.reflect.Method;
import java.util.concurrent.RejectedExecutionException;
import org.apache.seata.common.rpc.http.HttpContext;
import org.apache.seata.core.rpc.netty.http.BaseHttpChannelHandler;
import org.apache.seata.core.rpc.netty.http.ControllerManager;
import org.apache.seata.core.rpc.netty.http.HttpInvocation;
import org.apache.seata.core.rpc.netty.http.ParameterParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpDispatchHandler
extends BaseHttpChannelHandler<HttpRequest> {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpDispatchHandler.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void channelRead0(ChannelHandlerContext ctx, HttpRequest httpRequest) {
        try {
            boolean keepAlive = HttpUtil.isKeepAlive((HttpMessage)httpRequest) && httpRequest.protocolVersion().isKeepAliveDefault();
            QueryStringDecoder queryStringDecoder = new QueryStringDecoder(httpRequest.uri());
            String path = queryStringDecoder.path();
            HttpInvocation httpInvocation = ControllerManager.getHttpInvocation(path);
            if (httpInvocation == null) {
                this.sendErrorResponse(ctx, HttpResponseStatus.NOT_FOUND, false);
                return;
            }
            HttpContext httpContext = new HttpContext((Object)httpRequest, ctx, keepAlive, "HTTP/1.1");
            ObjectNode requestDataNode = OBJECT_MAPPER.createObjectNode();
            requestDataNode.set("param", (JsonNode)ParameterParser.convertParamMap(queryStringDecoder.parameters()));
            if (httpRequest.method() == HttpMethod.POST) {
                HttpPostRequestDecoder httpPostRequestDecoder = null;
                try {
                    httpPostRequestDecoder = new HttpPostRequestDecoder(httpRequest);
                    ObjectNode bodyDataNode = OBJECT_MAPPER.createObjectNode();
                    for (InterfaceHttpData interfaceHttpData : httpPostRequestDecoder.getBodyHttpDatas()) {
                        if (interfaceHttpData.getHttpDataType() != InterfaceHttpData.HttpDataType.Attribute) continue;
                        Attribute attribute = (Attribute)interfaceHttpData;
                        bodyDataNode.put(attribute.getName(), attribute.getValue());
                    }
                    requestDataNode.putIfAbsent("body", (JsonNode)bodyDataNode);
                }
                finally {
                    if (httpPostRequestDecoder != null) {
                        httpPostRequestDecoder.destroy();
                    }
                }
            }
            Object httpController = httpInvocation.getController();
            Method handleMethod = httpInvocation.getMethod();
            Object[] args = ParameterParser.getArgValues(httpInvocation.getParamMetaData(), handleMethod, requestDataNode, httpContext);
            try {
                HTTP_HANDLER_THREADS.execute(() -> {
                    try {
                        Object result = handleMethod.invoke(httpController, args);
                        if (httpContext.isAsync()) {
                            return;
                        }
                        this.sendResponse(ctx, keepAlive, result);
                    }
                    catch (IllegalArgumentException e) {
                        LOGGER.error("Illegal argument exception: {}", (Object)e.getMessage(), (Object)e);
                        this.sendErrorResponse(ctx, HttpResponseStatus.BAD_REQUEST, false);
                    }
                    catch (Exception e) {
                        LOGGER.error("Exception occurred while processing HTTP request: {}", (Object)e.getMessage(), (Object)e);
                        this.sendErrorResponse(ctx, HttpResponseStatus.INTERNAL_SERVER_ERROR, false);
                    }
                });
            }
            catch (RejectedExecutionException e) {
                LOGGER.error("HTTP thread pool is full: {}", (Object)e.getMessage(), (Object)e);
                this.sendErrorResponse(ctx, HttpResponseStatus.SERVICE_UNAVAILABLE, false);
            }
        }
        catch (Exception e) {
            LOGGER.error("Exception occurred while processing HTTP request: {}", (Object)e.getMessage(), (Object)e);
            this.sendErrorResponse(ctx, HttpResponseStatus.INTERNAL_SERVER_ERROR, false);
        }
    }

    private void sendResponse(ChannelHandlerContext ctx, boolean keepAlive, Object result) throws JsonProcessingException {
        DefaultFullHttpResponse response;
        if (result != null) {
            byte[] body = OBJECT_MAPPER.writeValueAsBytes(result);
            response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK, Unpooled.wrappedBuffer((byte[])body));
            response.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)body.length);
        } else {
            response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK, Unpooled.wrappedBuffer((ByteBuf)Unpooled.EMPTY_BUFFER));
        }
        if (!keepAlive) {
            ctx.writeAndFlush((Object)response).addListeners(new GenericFutureListener[]{ChannelFutureListener.CLOSE});
        } else {
            ctx.writeAndFlush((Object)response);
        }
    }

    private void sendErrorResponse(ChannelHandlerContext ctx, HttpResponseStatus status, boolean keepAlive) {
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, status, Unpooled.wrappedBuffer((ByteBuf)Unpooled.EMPTY_BUFFER));
        if (!keepAlive) {
            ctx.writeAndFlush((Object)response).addListeners(new GenericFutureListener[]{ChannelFutureListener.CLOSE});
        } else {
            ctx.writeAndFlush((Object)response);
        }
    }
}

