/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.server.cluster.raft;

import com.alipay.sofa.jraft.Closure;
import com.alipay.sofa.jraft.Iterator;
import com.alipay.sofa.jraft.RouteTable;
import com.alipay.sofa.jraft.Status;
import com.alipay.sofa.jraft.conf.Configuration;
import com.alipay.sofa.jraft.core.StateMachineAdapter;
import com.alipay.sofa.jraft.entity.LeaderChangeContext;
import com.alipay.sofa.jraft.entity.PeerId;
import com.alipay.sofa.jraft.rpc.InvokeContext;
import com.alipay.sofa.jraft.rpc.impl.cli.CliClientServiceImpl;
import com.alipay.sofa.jraft.storage.snapshot.SnapshotReader;
import com.alipay.sofa.jraft.storage.snapshot.SnapshotWriter;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import org.apache.seata.common.XID;
import org.apache.seata.common.holder.ObjectHolder;
import org.apache.seata.common.metadata.ClusterRole;
import org.apache.seata.common.metadata.Node;
import org.apache.seata.common.store.SessionMode;
import org.apache.seata.common.store.StoreMode;
import org.apache.seata.common.thread.NamedThreadFactory;
import org.apache.seata.common.util.CollectionUtils;
import org.apache.seata.common.util.StringUtils;
import org.apache.seata.core.serializer.SerializerType;
import org.apache.seata.server.cluster.listener.ClusterChangeEvent;
import org.apache.seata.server.cluster.raft.RaftServer;
import org.apache.seata.server.cluster.raft.RaftServerManager;
import org.apache.seata.server.cluster.raft.context.SeataClusterContext;
import org.apache.seata.server.cluster.raft.execute.RaftMsgExecute;
import org.apache.seata.server.cluster.raft.execute.branch.AddBranchSessionExecute;
import org.apache.seata.server.cluster.raft.execute.branch.RemoveBranchSessionExecute;
import org.apache.seata.server.cluster.raft.execute.branch.UpdateBranchSessionExecute;
import org.apache.seata.server.cluster.raft.execute.global.AddGlobalSessionExecute;
import org.apache.seata.server.cluster.raft.execute.global.RemoveGlobalSessionExecute;
import org.apache.seata.server.cluster.raft.execute.global.UpdateGlobalSessionExecute;
import org.apache.seata.server.cluster.raft.execute.lock.BranchReleaseLockExecute;
import org.apache.seata.server.cluster.raft.execute.lock.GlobalReleaseLockExecute;
import org.apache.seata.server.cluster.raft.execute.vgroup.VGroupAddExecute;
import org.apache.seata.server.cluster.raft.execute.vgroup.VGroupRemoveExecute;
import org.apache.seata.server.cluster.raft.processor.request.PutNodeMetadataRequest;
import org.apache.seata.server.cluster.raft.processor.response.PutNodeMetadataResponse;
import org.apache.seata.server.cluster.raft.snapshot.StoreSnapshotFile;
import org.apache.seata.server.cluster.raft.snapshot.metadata.LeaderMetadataSnapshotFile;
import org.apache.seata.server.cluster.raft.snapshot.session.SessionSnapshotFile;
import org.apache.seata.server.cluster.raft.snapshot.vgroup.VGroupSnapshotFile;
import org.apache.seata.server.cluster.raft.sync.RaftSyncMessageSerializer;
import org.apache.seata.server.cluster.raft.sync.msg.RaftBaseMsg;
import org.apache.seata.server.cluster.raft.sync.msg.RaftClusterMetadataMsg;
import org.apache.seata.server.cluster.raft.sync.msg.RaftSyncMsgType;
import org.apache.seata.server.cluster.raft.sync.msg.dto.RaftClusterMetadata;
import org.apache.seata.server.cluster.raft.util.RaftTaskUtil;
import org.apache.seata.server.session.SessionHolder;
import org.apache.seata.server.store.StoreConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.core.env.Environment;

public class RaftStateMachine
extends StateMachineAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(RaftStateMachine.class);
    private final String mode;
    private final String group;
    private final List<StoreSnapshotFile> snapshotFiles = new ArrayList();
    private static final Map<RaftSyncMsgType, RaftMsgExecute<?>> EXECUTES = new HashMap();
    private volatile RaftClusterMetadata raftClusterMetadata = new RaftClusterMetadata();
    private final Lock lock = new ReentrantLock();
    private static final ScheduledThreadPoolExecutor RESYNC_METADATA_POOL = new ScheduledThreadPoolExecutor(1, (ThreadFactory)new NamedThreadFactory("reSyncMetadataPool", 1, true));
    private final AtomicLong leaderTerm = new AtomicLong(-1L);
    private final AtomicLong currentTerm = new AtomicLong(-1L);
    private final AtomicBoolean initSync = new AtomicBoolean(false);
    private ScheduledFuture<?> scheduledFuture;

    public boolean isLeader() {
        return this.leaderTerm.get() > 0L;
    }

    public RaftStateMachine(String group) {
        this.group = group;
        this.mode = StoreConfig.getSessionMode().getName();
        EXECUTES.put(RaftSyncMsgType.REFRESH_CLUSTER_METADATA, syncMsg -> {
            this.refreshClusterMetadata(syncMsg);
            return null;
        });
        this.registryStoreSnapshotFile((StoreSnapshotFile)new LeaderMetadataSnapshotFile(group));
        if (StoreMode.RAFT.getName().equalsIgnoreCase(this.mode)) {
            this.registryStoreSnapshotFile((StoreSnapshotFile)new SessionSnapshotFile(group));
            this.registryStoreSnapshotFile((StoreSnapshotFile)new VGroupSnapshotFile(group));
            EXECUTES.put(RaftSyncMsgType.ADD_GLOBAL_SESSION, new AddGlobalSessionExecute());
            EXECUTES.put(RaftSyncMsgType.ADD_BRANCH_SESSION, new AddBranchSessionExecute());
            EXECUTES.put(RaftSyncMsgType.REMOVE_BRANCH_SESSION, new RemoveBranchSessionExecute());
            EXECUTES.put(RaftSyncMsgType.UPDATE_GLOBAL_SESSION_STATUS, new UpdateGlobalSessionExecute());
            EXECUTES.put(RaftSyncMsgType.RELEASE_GLOBAL_SESSION_LOCK, new GlobalReleaseLockExecute());
            EXECUTES.put(RaftSyncMsgType.REMOVE_GLOBAL_SESSION, new RemoveGlobalSessionExecute());
            EXECUTES.put(RaftSyncMsgType.UPDATE_BRANCH_SESSION_STATUS, new UpdateBranchSessionExecute());
            EXECUTES.put(RaftSyncMsgType.RELEASE_BRANCH_SESSION_LOCK, new BranchReleaseLockExecute());
            EXECUTES.put(RaftSyncMsgType.REMOVE_VGROUP_MAPPING, new VGroupRemoveExecute());
            EXECUTES.put(RaftSyncMsgType.ADD_VGROUP_MAPPING, new VGroupAddExecute());
            this.scheduledFuture = RESYNC_METADATA_POOL.scheduleAtFixedRate(() -> this.syncCurrentNodeInfo(group), 10L, 10L, TimeUnit.SECONDS);
        }
    }

    public void onApply(Iterator iterator) {
        while (iterator.hasNext()) {
            Closure done = iterator.done();
            if (done != null) {
                done.run(Status.OK());
            } else {
                ByteBuffer byteBuffer = iterator.getData();
                if (byteBuffer != null && byteBuffer.hasRemaining()) {
                    RaftBaseMsg msg = (RaftBaseMsg)RaftSyncMessageSerializer.decode((byte[])byteBuffer.array()).getBody();
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("sync msg: {}", (Object)msg);
                    }
                    this.onExecuteRaft(msg);
                }
            }
            iterator.next();
        }
    }

    public void onSnapshotSave(SnapshotWriter writer, Closure done) {
        if (!StringUtils.equals((String)SessionMode.RAFT.getName(), (String)this.mode)) {
            done.run(Status.OK());
            return;
        }
        long current = System.currentTimeMillis();
        for (StoreSnapshotFile snapshotFile : this.snapshotFiles) {
            Status status = snapshotFile.save(writer);
            if (status.isOk()) continue;
            done.run(status);
            return;
        }
        LOGGER.info("groupId: {}, onSnapshotSave cost: {} ms.", (Object)this.group, (Object)(System.currentTimeMillis() - current));
        done.run(Status.OK());
    }

    public boolean onSnapshotLoad(SnapshotReader reader) {
        if (!StringUtils.equals((String)SessionMode.RAFT.getName(), (String)this.mode)) {
            return true;
        }
        if (this.isLeader()) {
            if (LOGGER.isWarnEnabled()) {
                LOGGER.warn("Leader is not supposed to load snapshot");
            }
            return false;
        }
        long current = System.currentTimeMillis();
        for (StoreSnapshotFile snapshotFile : this.snapshotFiles) {
            if (snapshotFile.load(reader)) continue;
            return false;
        }
        LOGGER.info("groupId: {}, onSnapshotLoad cost: {} ms.", (Object)this.group, (Object)(System.currentTimeMillis() - current));
        return true;
    }

    public void onLeaderStart(long term) {
        boolean leader = this.isLeader();
        this.leaderTerm.set(term);
        LOGGER.info("groupId: {}, onLeaderStart: term={}.", (Object)this.group, (Object)term);
        this.currentTerm.set(term);
        this.syncMetadata();
        if (!leader && RaftServerManager.isRaftMode()) {
            CompletableFuture.runAsync(() -> {
                LOGGER.info("reload session, groupId: {}, session map size: {} ", (Object)this.group, (Object)SessionHolder.getRootSessionManager().allSessions().size());
                SeataClusterContext.bindGroup((String)this.group);
                try {
                    SessionHolder.reload((Collection)SessionHolder.getRootSessionManager().allSessions(), (SessionMode)SessionMode.RAFT, (boolean)false);
                }
                finally {
                    SeataClusterContext.unbindGroup();
                }
            });
            Configuration conf = RouteTable.getInstance().getConfiguration(this.group);
            this.changePeers(conf);
        }
    }

    public void onLeaderStop(Status status) {
        this.leaderTerm.set(-1L);
        LOGGER.info("groupId: {}, onLeaderStop: status={}.", (Object)this.group, (Object)status);
    }

    public void onStopFollowing(LeaderChangeContext ctx) {
        LOGGER.info("groupId: {}, onStopFollowing: {}.", (Object)this.group, (Object)ctx);
    }

    public void onStartFollowing(LeaderChangeContext ctx) {
        LOGGER.info("groupId: {}, onStartFollowing: {}.", (Object)this.group, (Object)ctx);
        this.currentTerm.set(ctx.getTerm());
        CompletableFuture.runAsync(() -> this.syncCurrentNodeInfo(ctx.getLeaderId()), RESYNC_METADATA_POOL);
    }

    public void onConfigurationCommitted(Configuration conf) {
        LOGGER.info("groupId: {}, onConfigurationCommitted: {}.", (Object)this.group, (Object)conf);
        RouteTable.getInstance().updateConfiguration(this.group, conf);
        this.initSync.compareAndSet(true, false);
        if (this.isLeader()) {
            this.changePeers(conf);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void changePeers(Configuration conf) {
        this.lock.lock();
        try {
            List newFollowers = conf.getPeers();
            LinkedHashSet newLearners = conf.getLearners();
            List currentFollowers = this.raftClusterMetadata.getFollowers();
            if (CollectionUtils.isNotEmpty((Collection)newFollowers)) {
                this.raftClusterMetadata.setFollowers(currentFollowers.stream().filter(node -> this.contains(node, (Collection)newFollowers)).collect(Collectors.toList()));
            }
            if (CollectionUtils.isNotEmpty((Collection)newLearners)) {
                this.raftClusterMetadata.setLearner(this.raftClusterMetadata.getLearner().stream().filter(node -> this.contains(node, (Collection)newLearners)).collect(Collectors.toList()));
            } else {
                this.raftClusterMetadata.setLearner(Collections.emptyList());
            }
            CompletableFuture.runAsync(() -> this.syncMetadata(), RESYNC_METADATA_POOL);
        }
        finally {
            this.lock.unlock();
        }
    }

    private boolean contains(Node node, Collection<PeerId> list) {
        if (node.getInternal() == null) {
            return true;
        }
        PeerId nodePeer = new PeerId(node.getInternal().getHost(), node.getInternal().getPort());
        return list.contains(nodePeer);
    }

    public void syncMetadata() {
        if (this.isLeader()) {
            SeataClusterContext.bindGroup((String)this.group);
            try {
                RaftClusterMetadataMsg raftClusterMetadataMsg = new RaftClusterMetadataMsg(this.changeOrInitRaftClusterMetadata());
                RaftTaskUtil.createTask(status -> this.refreshClusterMetadata((RaftBaseMsg)raftClusterMetadataMsg), (Object)raftClusterMetadataMsg, null);
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
            finally {
                SeataClusterContext.unbindGroup();
            }
        }
    }

    private void onExecuteRaft(RaftBaseMsg msg) {
        RaftMsgExecute execute = (RaftMsgExecute)EXECUTES.get(msg.getMsgType());
        if (execute == null) {
            throw new RuntimeException("the state machine does not allow events that cannot be executed, please feedback the information to the Seata community !!! msg: " + msg);
        }
        try {
            execute.execute(msg);
        }
        catch (Throwable e) {
            LOGGER.error("Message synchronization failure: {}, msgType: {}", new Object[]{e.getMessage(), msg.getMsgType(), e});
            throw new RuntimeException(e);
        }
    }

    public AtomicLong getCurrentTerm() {
        return this.currentTerm;
    }

    public void registryStoreSnapshotFile(StoreSnapshotFile storeSnapshotFile) {
        this.snapshotFiles.add(storeSnapshotFile);
    }

    public RaftClusterMetadata getRaftLeaderMetadata() {
        return this.raftClusterMetadata;
    }

    public void setRaftLeaderMetadata(RaftClusterMetadata raftClusterMetadata) {
        this.raftClusterMetadata = raftClusterMetadata;
    }

    public RaftClusterMetadata changeOrInitRaftClusterMetadata() {
        this.raftClusterMetadata.setTerm(this.currentTerm.get());
        Node leaderNode = this.raftClusterMetadata.getLeader();
        RaftServer raftServer = RaftServerManager.getRaftServer((String)this.group);
        PeerId cureentPeerId = raftServer.getServerId();
        if (leaderNode == null || leaderNode.getInternal() != null && !cureentPeerId.equals((Object)new PeerId(leaderNode.getInternal().getHost(), leaderNode.getInternal().getPort()))) {
            Node leader = this.raftClusterMetadata.createNode(cureentPeerId.getIp(), XID.getPort(), raftServer.getServerId().getPort(), Integer.parseInt(((Environment)ObjectHolder.INSTANCE.getObject("springConfigurableEnvironment")).getProperty("server.port", String.valueOf(7091))), this.group, Collections.emptyMap());
            leader.setRole(ClusterRole.LEADER);
            this.raftClusterMetadata.setLeader(leader);
        }
        return this.raftClusterMetadata;
    }

    public void refreshClusterMetadata(RaftBaseMsg syncMsg) {
        this.raftClusterMetadata = ((RaftClusterMetadataMsg)syncMsg).getRaftClusterMetadata();
        ((ApplicationEventPublisher)ObjectHolder.INSTANCE.getObject("springApplicationContext")).publishEvent((ApplicationEvent)new ClusterChangeEvent((Object)this, this.group, this.raftClusterMetadata.getTerm(), this.isLeader()));
        LOGGER.info("groupId: {}, refresh cluster metadata: {}", (Object)this.group, (Object)this.raftClusterMetadata);
    }

    private void syncCurrentNodeInfo(String group) {
        if (this.initSync.compareAndSet(false, true)) {
            try {
                RouteTable.getInstance().refreshLeader(RaftServerManager.getCliClientServiceInstance(), group, 1000);
                PeerId peerId = RouteTable.getInstance().selectLeader(group);
                if (peerId != null) {
                    this.syncCurrentNodeInfo(peerId);
                } else {
                    this.initSync.compareAndSet(true, false);
                }
            }
            catch (Exception e) {
                this.initSync.compareAndSet(true, false);
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    private void syncCurrentNodeInfo(PeerId leaderPeerId) {
        try {
            Node leader = this.raftClusterMetadata.getLeader();
            if (leader != null && StringUtils.isNotBlank((String)leader.getVersion())) {
                RaftServer raftServer = RaftServerManager.getRaftServer((String)this.group);
                PeerId cureentPeerId = raftServer.getServerId();
                Node node = this.raftClusterMetadata.createNode(cureentPeerId.getIp(), XID.getPort(), cureentPeerId.getPort(), Integer.parseInt(((Environment)ObjectHolder.INSTANCE.getObject("springConfigurableEnvironment")).getProperty("server.port", String.valueOf(7091))), this.group, Collections.emptyMap());
                InvokeContext invokeContext = new InvokeContext();
                PutNodeMetadataRequest putNodeInfoRequest = new PutNodeMetadataRequest(node);
                Configuration configuration = RouteTable.getInstance().getConfiguration(this.group);
                node.setRole(configuration.getPeers().contains(cureentPeerId) ? ClusterRole.FOLLOWER : ClusterRole.LEARNER);
                invokeContext.put("bolt.invoke.custom.serializer", (Object)SerializerType.JACKSON.getCode());
                CliClientServiceImpl cliClientService = (CliClientServiceImpl)RaftServerManager.getCliClientServiceInstance();
                cliClientService.getRpcClient().invokeAsync(leaderPeerId.getEndpoint(), (Object)putNodeInfoRequest, invokeContext, (result, err) -> {
                    if (err == null) {
                        PutNodeMetadataResponse putNodeMetadataResponse = (PutNodeMetadataResponse)result;
                        if (putNodeMetadataResponse.isSuccess()) {
                            this.scheduledFuture.cancel(true);
                            LOGGER.info("sync node info to leader: {}, result: {}", (Object)leaderPeerId, result);
                        } else {
                            this.initSync.compareAndSet(true, false);
                            LOGGER.info("sync node info to leader: {}, result: {}, retry will be made at the time of the re-election or after 10 seconds", (Object)leaderPeerId, result);
                        }
                    } else {
                        this.initSync.compareAndSet(true, false);
                        LOGGER.error("sync node info to leader: {}, error: {}", new Object[]{leaderPeerId, err.getMessage(), err});
                    }
                }, 30000L);
            } else {
                this.initSync.compareAndSet(true, false);
            }
        }
        catch (Exception e) {
            this.initSync.compareAndSet(true, false);
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeNodeMetadata(Node node) {
        this.lock.lock();
        try {
            List list = node.getRole() == ClusterRole.FOLLOWER ? this.raftClusterMetadata.getFollowers() : this.raftClusterMetadata.getLearner();
            for (Node follower : list) {
                Node.Endpoint endpoint = follower.getInternal();
                if (endpoint == null || !endpoint.getHost().equals(node.getInternal().getHost()) || endpoint.getPort() != node.getInternal().getPort()) continue;
                follower.setTransaction(node.getTransaction());
                follower.setControl(node.getControl());
                follower.setGroup(this.group);
                follower.setMetadata(node.getMetadata());
                follower.setVersion(node.getVersion());
                follower.setRole(node.getRole());
                return;
            }
            list.add(node);
            this.syncMetadata();
        }
        finally {
            this.lock.unlock();
        }
    }
}

