/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.gcp.gcs;

import com.google.auth.oauth2.AccessToken;
import com.google.auth.oauth2.OAuth2CredentialsWithRefresh;
import java.io.Closeable;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.iceberg.io.CloseableGroup;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.rest.ErrorHandlers;
import org.apache.iceberg.rest.HTTPClient;
import org.apache.iceberg.rest.RESTClient;
import org.apache.iceberg.rest.auth.AuthManager;
import org.apache.iceberg.rest.auth.AuthManagers;
import org.apache.iceberg.rest.auth.AuthSession;
import org.apache.iceberg.rest.credentials.Credential;
import org.apache.iceberg.rest.responses.LoadCredentialsResponse;

public class OAuth2RefreshCredentialsHandler
implements OAuth2CredentialsWithRefresh.OAuth2RefreshHandler,
AutoCloseable {
    private final Map<String, String> properties;
    private final String credentialsEndpoint;
    private final String catalogEndpoint;
    private volatile HTTPClient client;
    private AuthManager authManager;
    private AuthSession authSession;

    private OAuth2RefreshCredentialsHandler(Map<String, String> properties) {
        Preconditions.checkArgument((null != properties.get("gcs.oauth2.refresh-credentials-endpoint") ? 1 : 0) != 0, (Object)"Invalid credentials endpoint: null");
        Preconditions.checkArgument((null != properties.get("uri") ? 1 : 0) != 0, (Object)"Invalid catalog endpoint: null");
        this.credentialsEndpoint = properties.get("gcs.oauth2.refresh-credentials-endpoint");
        this.catalogEndpoint = properties.get("uri");
        this.properties = properties;
    }

    public AccessToken refreshAccessToken() {
        LoadCredentialsResponse response = (LoadCredentialsResponse)this.httpClient().get(this.credentialsEndpoint, null, LoadCredentialsResponse.class, Map.of(), ErrorHandlers.defaultErrorHandler());
        List gcsCredentials = response.credentials().stream().filter(c -> c.prefix().startsWith("gs")).collect(Collectors.toList());
        Preconditions.checkState((!gcsCredentials.isEmpty() ? 1 : 0) != 0, (Object)"Invalid GCS Credentials: empty");
        Preconditions.checkState((gcsCredentials.size() == 1 ? 1 : 0) != 0, (Object)"Invalid GCS Credentials: only one GCS credential should exist");
        Credential gcsCredential = (Credential)gcsCredentials.get(0);
        this.checkCredential(gcsCredential, "gcs.oauth2.token");
        this.checkCredential(gcsCredential, "gcs.oauth2.token-expires-at");
        String token = (String)gcsCredential.config().get("gcs.oauth2.token");
        String expiresAt = (String)gcsCredential.config().get("gcs.oauth2.token-expires-at");
        return new AccessToken(token, new Date(Long.parseLong(expiresAt)));
    }

    private void checkCredential(Credential gcsCredential, String gcsOauth2Token) {
        Preconditions.checkState((boolean)gcsCredential.config().containsKey(gcsOauth2Token), (String)"Invalid GCS Credentials: %s not set", (Object)gcsOauth2Token);
    }

    public static OAuth2RefreshCredentialsHandler create(Map<String, String> properties) {
        return new OAuth2RefreshCredentialsHandler(properties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RESTClient httpClient() {
        if (null == this.client) {
            OAuth2RefreshCredentialsHandler oAuth2RefreshCredentialsHandler = this;
            synchronized (oAuth2RefreshCredentialsHandler) {
                if (null == this.client) {
                    this.authManager = AuthManagers.loadAuthManager((String)"gcs-credentials-refresh", this.properties);
                    HTTPClient httpClient = HTTPClient.builder(this.properties).uri(this.catalogEndpoint).build();
                    this.authSession = this.authManager.catalogSession((RESTClient)httpClient, this.properties);
                    this.client = httpClient.withAuthSession(this.authSession);
                }
            }
        }
        return this.client;
    }

    @Override
    public void close() {
        CloseableGroup closeableGroup = new CloseableGroup();
        closeableGroup.addCloseable((AutoCloseable)this.authSession);
        closeableGroup.addCloseable((AutoCloseable)this.authManager);
        closeableGroup.addCloseable((Closeable)this.client);
        closeableGroup.setSuppressCloseFailure(true);
        try {
            closeableGroup.close();
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to close the OAuth2RefreshCredentialsHandler", e);
        }
    }
}

