/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.service.catalog.io;

import com.google.common.annotations.VisibleForTesting;
import io.smallrye.common.annotation.Identifier;
import jakarta.annotation.Nonnull;
import jakarta.enterprise.context.RequestScoped;
import jakarta.inject.Inject;
import java.util.HashMap;
import java.util.Map;
import org.apache.iceberg.CatalogUtil;
import org.apache.iceberg.io.FileIO;
import org.apache.polaris.core.storage.StorageAccessConfig;
import org.apache.polaris.service.catalog.io.ExceptionMappingFileIO;
import org.apache.polaris.service.catalog.io.FileIOFactory;

@RequestScoped
@Identifier(value="default")
public class DefaultFileIOFactory
implements FileIOFactory {
    @Inject
    public DefaultFileIOFactory() {
    }

    @Override
    public FileIO loadFileIO(@Nonnull StorageAccessConfig storageAccessConfig, @Nonnull String ioImplClassName, @Nonnull Map<String, String> properties) {
        properties = new HashMap<String, String>(properties);
        properties.putAll(storageAccessConfig.credentials());
        properties.putAll(storageAccessConfig.extraProperties());
        properties.putAll(storageAccessConfig.internalProperties());
        return this.loadFileIOInternal(ioImplClassName, properties);
    }

    @VisibleForTesting
    FileIO loadFileIOInternal(@Nonnull String ioImplClassName, @Nonnull Map<String, String> properties) {
        return new ExceptionMappingFileIO(CatalogUtil.loadFileIO((String)ioImplClassName, properties, null));
    }
}

