/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.apache.ozhera.monitor.service.model.prometheus;

import lombok.Data;

import java.io.Serializable;
import java.util.Map;

/**
 * @author gaoxihui
 * @date 2021/9/16 8:52 PM
 */
@Data
public class AlertEventData implements Serializable {
    private String id;//Uniquely identifies an alarm event (only one alarm will be generated for the same indicator at the same time). The format is ：df1d79e46d403e503ef024340cf589f4
    private String event_id;//Uniquely identifies an alarm (alarms generated by the same indicator), the format is，treeId_alertId_md5：1_24_df1d79e46d403e503ef024340cf589f4
    private Integer alert_id;//alert id
    private Integer tree_id;//iam tree id
    private String alert_name;//alert name
    private String alert_cname;//alert rule alias
    private String expr;//Alert Expression
    private String metric;//metric name
    private Map labels;//labels，Contains labels for the original data and labels configured in the alert
    private Map annotations;//alert rule description
    private String status;//alert status，firing、resolved
    private Long alert_time;//Current alert time
    private Float alert_value;//alert value
    private String env;//Configure the environment
    private String priority;//Alarm level
    private String created_by;//Alert creator
    private Long start_time;//Alarm start time
    private Long end_time;//timestamp
    private Integer duration;//larm duration, seconds

}
