/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.log.api.enums;

import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Stream;

public enum MQSourceEnum {
    ROCKETMQ(1, "rocketmq", "RocketMQService"),
    KAFKA(2, "kafka", "KafkaService");

    private final Integer code;
    private final String name;
    private final String serviceName;

    private MQSourceEnum(Integer code, String name, String serviceName) {
        this.code = code;
        this.name = name;
        this.serviceName = serviceName;
    }

    public static String queryName(Integer code) {
        for (MQSourceEnum value : MQSourceEnum.values()) {
            if (!Objects.equals(value.getCode(), code)) continue;
            return value.getName();
        }
        return ROCKETMQ.getName();
    }

    public static MQSourceEnum queryByName(String name) {
        if (name == null || "".equals(name)) {
            return null;
        }
        return ((Stream)Arrays.stream(MQSourceEnum.values()).sequential()).filter(sourceEnum -> sourceEnum.getName().equals(name)).findFirst().orElse(null);
    }

    public Integer getCode() {
        return this.code;
    }

    public String getName() {
        return this.name;
    }

    public String getServiceName() {
        return this.serviceName;
    }
}

