/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.log.agent.rpc.processor;

import com.xiaomi.data.push.rpc.netty.NettyRequestProcessor;
import com.xiaomi.data.push.rpc.protocol.RemotingCommand;
import com.xiaomi.youpin.docean.Ioc;
import com.xiaomi.youpin.docean.anno.Component;
import io.netty.channel.ChannelHandlerContext;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.collections.CollectionUtils;
import org.apache.ozhera.log.agent.channel.ChannelDefine;
import org.apache.ozhera.log.agent.channel.ChannelEngine;
import org.apache.ozhera.log.agent.channel.locator.ChannelDefineRpcLocator;
import org.apache.ozhera.log.api.model.meta.LogCollectMeta;
import org.apache.ozhera.log.common.Constant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
public class LogProcessor
implements NettyRequestProcessor {
    private static final Logger log = LoggerFactory.getLogger(LogProcessor.class);
    private ReentrantLock lock = new ReentrantLock();

    public RemotingCommand processRequest(ChannelHandlerContext channelHandlerContext, RemotingCommand remotingCommand) throws Exception {
        LogCollectMeta req = (LogCollectMeta)remotingCommand.getReq(LogCollectMeta.class);
        log.info("logCollect config req:{}", (Object)Constant.GSON.toJson((Object)req));
        RemotingCommand response = RemotingCommand.createResponseCommand((int)3001);
        response.setBody("ok".getBytes());
        log.info("\u3010config change\u3011receive data\uff1a{}", (Object)Constant.GSON.toJson((Object)req));
        this.metaConfigEffect(req);
        log.info("config change success");
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void metaConfigEffect(LogCollectMeta req) {
        try {
            this.lock.lock();
            ChannelEngine channelEngine = (ChannelEngine)Ioc.ins().getBean(ChannelEngine.class);
            int count = 0;
            do {
                if (channelEngine.isInitComplete()) continue;
                try {
                    TimeUnit.SECONDS.sleep(5L);
                    ++count;
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            } while (!channelEngine.isInitComplete() && count < 20);
            if (CollectionUtils.isNotEmpty((Collection)req.getAppLogMetaList())) {
                try {
                    List<ChannelDefine> channelDefines = ChannelDefineRpcLocator.agentTail2ChannelDefine(ChannelDefineRpcLocator.logCollectMeta2ChannelDefines(req));
                    channelEngine.refresh(channelDefines);
                }
                catch (Exception e) {
                    log.error("refresh config error,req:{}", (Object)Constant.GSON.toJson((Object)req), (Object)e);
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean rejectRequest() {
        return false;
    }

    public int cmdId() {
        return 3000;
    }
}

