/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.log.agent.channel;

import cn.hutool.core.io.FileUtil;
import com.xiaomi.mone.file.ReadResult;
import com.xiaomi.mone.file.common.FileInfoCache;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.ozhera.log.agent.channel.ChannelDefine;
import org.apache.ozhera.log.agent.channel.ChannelService;
import org.apache.ozhera.log.agent.channel.ChannelState;
import org.apache.ozhera.log.agent.channel.memory.ChannelMemory;
import org.apache.ozhera.log.agent.common.ChannelUtil;
import org.apache.ozhera.log.agent.input.Input;
import org.apache.ozhera.log.api.enums.LogTypeEnum;
import org.apache.ozhera.log.api.model.meta.LogPattern;
import org.apache.ozhera.log.api.model.msg.LineMessage;
import org.apache.ozhera.log.common.Constant;
import org.apache.ozhera.log.utils.NetUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractChannelService
implements ChannelService {
    private static final Logger log = LoggerFactory.getLogger(AbstractChannelService.class);
    public String instanceId = UUID.randomUUID().toString();

    @Override
    public String instanceId() {
        return this.instanceId;
    }

    @Override
    public ChannelState state() {
        ChannelState channelState = new ChannelState();
        ChannelDefine channelDefine = this.getChannelDefine();
        ChannelMemory channelMemory = this.getChannelMemory();
        channelState.setTailId(channelDefine.getChannelId());
        channelState.setTailName(channelDefine.getTailName());
        channelState.setAppId(channelDefine.getAppId());
        channelState.setAppName(channelDefine.getAppName());
        channelState.setLogPattern(channelDefine.getInput().getLogPattern());
        channelState.setLogPatternCode(channelDefine.getInput().getPatternCode());
        List<String> distinctIpList = channelDefine.getIpDirectoryRel().stream().map(LogPattern.IPRel::getIp).distinct().collect(Collectors.toList());
        channelState.setIpList(distinctIpList);
        channelState.setCollectTime(channelMemory.getCurrentTime());
        if (channelState.getStateProgressMap() == null) {
            channelState.setStateProgressMap(new HashMap<String, ChannelState.StateProgress>(256));
        }
        channelMemory.getFileProgressMap().forEach((pattern, fileProcess) -> {
            if (null != fileProcess.getFinished() && fileProcess.getFinished().booleanValue()) {
                return;
            }
            ChannelState.StateProgress stateProgress = new ChannelState.StateProgress();
            stateProgress.setCurrentFile((String)pattern);
            stateProgress.setIp(this.getTailPodIp((String)pattern));
            stateProgress.setCurrentRowNum(fileProcess.getCurrentRowNum());
            stateProgress.setPointer(fileProcess.getPointer());
            stateProgress.setFileMaxPointer(fileProcess.getFileMaxPointer());
            stateProgress.setCtTime(fileProcess.getCtTime());
            channelState.getStateProgressMap().put((String)pattern, stateProgress);
        });
        channelState.setTotalSendCnt(this.getLogCounts());
        return channelState;
    }

    public abstract ChannelDefine getChannelDefine();

    public abstract ChannelMemory getChannelMemory();

    public abstract Map<String, Long> getExpireFileMap();

    public abstract void cancelFile(String var1);

    public abstract Long getLogCounts();

    public LogTypeEnum getLogTypeEnum() {
        Input input = this.getChannelDefine().getInput();
        return LogTypeEnum.name2enum((String)input.getType());
    }

    protected String getTailPodIp(String pattern) {
        ChannelDefine channelDefine = this.getChannelDefine();
        List<LogPattern.IPRel> ipDirectoryRel = channelDefine.getIpDirectoryRel();
        LogPattern.IPRel actualIpRel = ipDirectoryRel.stream().filter(ipRel -> pattern.contains(ipRel.getKey())).findFirst().orElse(null);
        if (null != actualIpRel) {
            return actualIpRel.getIp();
        }
        return NetUtil.getLocalIp();
    }

    protected ChannelMemory initChannelMemory(Long channelId, Input input, List<String> patterns, ChannelDefine channelDefine) {
        ChannelMemory channelMemory = new ChannelMemory();
        channelMemory.setChannelId(channelId);
        channelMemory.setInput(input);
        channelMemory.setFileProgressMap(this.buildFileProgressMap(patterns, channelDefine));
        channelMemory.setCurrentTime(System.currentTimeMillis());
        channelMemory.setVersion("2.0");
        return channelMemory;
    }

    private Map<String, ChannelMemory.FileProgress> buildFileProgressMap(List<String> patterns, ChannelDefine channelDefine) {
        HashMap<String, ChannelMemory.FileProgress> fileProgressMap = new HashMap<String, ChannelMemory.FileProgress>();
        for (String pattern : patterns) {
            ChannelMemory.FileProgress fileProgress = new ChannelMemory.FileProgress();
            fileProgress.setPointer(0L);
            fileProgress.setCurrentRowNum(0L);
            fileProgress.setUnixFileNode(ChannelUtil.buildUnixFileNode(pattern));
            fileProgress.setPodType(channelDefine.getPodType());
            fileProgressMap.put(pattern, fileProgress);
        }
        return fileProgressMap;
    }

    protected static void wildcardGraceShutdown(List<String> directory, String matchExpress) {
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            log.info("wildcardGraceShutdown Shutdown,directory:{},express:{},cacheSize:{}", new Object[]{Constant.GSON.toJson((Object)directory), matchExpress, FileInfoCache.ins().caches().size()});
            FileInfoCache.ins().shutdown();
        }));
    }

    protected LineMessage createLineMessage(String lineMsg, AtomicReference<ReadResult> readResult, String pattern, String patternCode, String ip, long ct) {
        LineMessage lineMessage = new LineMessage();
        lineMessage.setMsgBody(lineMsg);
        lineMessage.setPointer(Long.valueOf(readResult.get().getPointer()));
        lineMessage.setLineNumber(Long.valueOf(readResult.get().getLineNumber()));
        lineMessage.setFileName(pattern);
        lineMessage.setProperties(LineMessage.KEY_MQ_TOPIC_TAG, patternCode);
        lineMessage.setProperties(LineMessage.KEY_IP, ip);
        lineMessage.setProperties(LineMessage.KEY_COLLECT_TIMESTAMP, String.valueOf(ct));
        String logType = this.getChannelDefine().getInput().getType();
        LogTypeEnum logTypeEnum = LogTypeEnum.name2enum((String)logType);
        if (logTypeEnum != null) {
            lineMessage.setProperties(LineMessage.KEY_MESSAGE_TYPE, logTypeEnum.getType().toString());
        }
        return lineMessage;
    }

    protected void updateChannelMemory(ChannelMemory channelMemory, String fileName, LogTypeEnum logTypeEnum, long ct, AtomicReference<ReadResult> readResult) {
        ChannelMemory.FileProgress fileProgress = channelMemory.getFileProgressMap().get(fileName);
        ChannelDefine channelDefine = this.getChannelDefine();
        if (null == fileProgress) {
            fileProgress = new ChannelMemory.FileProgress();
            channelMemory.getFileProgressMap().put(fileName, fileProgress);
            channelMemory.getInput().setLogPattern(channelDefine.getInput().getLogPattern());
            channelMemory.getInput().setType(logTypeEnum.name());
            channelMemory.getInput().setLogSplitExpress(channelDefine.getInput().getLogSplitExpress());
        }
        fileProgress.setCurrentRowNum(readResult.get().getLineNumber());
        fileProgress.setPointer(readResult.get().getPointer());
        if (null != readResult.get().getFileMaxPointer()) {
            fileProgress.setFileMaxPointer(readResult.get().getFileMaxPointer());
        }
        if (FileUtil.exist((String)fileName)) {
            fileProgress.setUnixFileNode(ChannelUtil.buildUnixFileNode(fileName));
        }
        fileProgress.setPodType(channelDefine.getPodType());
        fileProgress.setCtTime(ct);
    }
}

