/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomi.data.push.rpc.processor;

import com.xiaomi.data.push.rpc.RpcVersion;
import com.xiaomi.data.push.rpc.netty.NettyRequestProcessor;
import com.xiaomi.data.push.rpc.protocol.RemotingCommand;
import io.netty.channel.ChannelHandlerContext;
import java.util.Date;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PingProcessor
implements NettyRequestProcessor {
    private static final Logger log = LoggerFactory.getLogger(PingProcessor.class);
    private Function<String, String> function;

    public PingProcessor() {
    }

    public PingProcessor(Function<String, String> function) {
        this.function = function;
    }

    @Override
    public RemotingCommand processRequest(ChannelHandlerContext ctx, RemotingCommand request) {
        log.info("PingResProcessor ping:{}", (Object)new String(request.getBody()));
        RemotingCommand response = RemotingCommand.createResponseCommand(1002);
        if (null != this.function) {
            String res = this.function.apply(new String(request.getBody()));
            response.setBody(res.getBytes());
            return response;
        }
        RpcVersion version = new RpcVersion();
        response.setBody(("pong:" + String.valueOf(version) + ":" + String.valueOf(new Date())).getBytes());
        return response;
    }

    @Override
    public boolean rejectRequest() {
        return false;
    }
}

