/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.core.convert;

import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class KeyspaceConfiguration {
    private Map<Class<?>, KeyspaceSettings> settingsMap = new ConcurrentHashMap();

    public KeyspaceConfiguration() {
        for (KeyspaceSettings initial : this.initialConfiguration()) {
            this.settingsMap.put(initial.type, initial);
        }
    }

    public boolean hasSettingsFor(Class<?> type) {
        Assert.notNull(type, (String)"Type to lookup must not be null!");
        if (this.settingsMap.containsKey(type)) {
            return !(this.settingsMap.get(type) instanceof DefaultKeyspaceSetting);
        }
        for (KeyspaceSettings assignment : this.settingsMap.values()) {
            if (!assignment.inherit || !ClassUtils.isAssignable((Class)assignment.type, type)) continue;
            this.settingsMap.put(type, assignment.cloneFor(type));
            return true;
        }
        this.settingsMap.put(type, new DefaultKeyspaceSetting(type));
        return false;
    }

    public KeyspaceSettings getKeyspaceSettings(Class<?> type) {
        if (!this.hasSettingsFor(type)) {
            return null;
        }
        KeyspaceSettings settings = this.settingsMap.get(type);
        if (settings == null || settings instanceof DefaultKeyspaceSetting) {
            return null;
        }
        return settings;
    }

    protected Iterable<KeyspaceSettings> initialConfiguration() {
        return Collections.emptySet();
    }

    public void addKeyspaceSettings(KeyspaceSettings keyspaceSettings) {
        Assert.notNull((Object)keyspaceSettings, (String)"KeyspaceSettings must not be null!");
        this.settingsMap.put(keyspaceSettings.getType(), keyspaceSettings);
    }

    private static class DefaultKeyspaceSetting
    extends KeyspaceSettings {
        public DefaultKeyspaceSetting(Class<?> type) {
            super(type, "#default#", false);
        }
    }

    public static class KeyspaceSettings {
        private final String keyspace;
        private final Class<?> type;
        private final boolean inherit;
        @Nullable
        private Long timeToLive;
        @Nullable
        private String timeToLivePropertyName;

        public KeyspaceSettings(Class<?> type, String keyspace) {
            this(type, keyspace, true);
        }

        public KeyspaceSettings(Class<?> type, String keyspace, boolean inherit) {
            this.type = type;
            this.keyspace = keyspace;
            this.inherit = inherit;
        }

        KeyspaceSettings cloneFor(Class<?> type) {
            return new KeyspaceSettings(type, this.keyspace, false);
        }

        public String getKeyspace() {
            return this.keyspace;
        }

        public Class<?> getType() {
            return this.type;
        }

        public void setTimeToLive(Long timeToLive) {
            this.timeToLive = timeToLive;
        }

        @Nullable
        public Long getTimeToLive() {
            return this.timeToLive;
        }

        public void setTimeToLivePropertyName(String propertyName) {
            this.timeToLivePropertyName = propertyName;
        }

        @Nullable
        public String getTimeToLivePropertyName() {
            return this.timeToLivePropertyName;
        }
    }
}

