/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomi.youpin.docean.mvc.download;

import com.xiaomi.youpin.docean.common.DoceanConfig;
import com.xiaomi.youpin.docean.common.StringUtils;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.CharsetUtil;
import io.netty.util.concurrent.GenericFutureListener;
import java.nio.charset.Charset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseService {
    private static final Logger log = LoggerFactory.getLogger(BaseService.class);
    public static final String DATAPATH = DoceanConfig.ins().get("download_file_path", "/tmp");

    public static void send(ChannelHandlerContext ctx, String message) {
        BaseService.send(ctx, HttpResponseStatus.OK, message);
    }

    public static void send(ChannelHandlerContext ctx, HttpResponseStatus status, String message) {
        try {
            ByteBuf msg = Unpooled.copiedBuffer((CharSequence)message, (Charset)CharsetUtil.UTF_8);
            DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, status, msg);
            response.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)"text/plain; charset=UTF-8");
            response.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)msg.readableBytes());
            ctx.writeAndFlush((Object)response).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
        catch (Throwable ex) {
            log.error("send error:{}", (Object)ex.getMessage());
        }
    }

    public static boolean checkParams(ChannelHandlerContext ctx, String name, String token) {
        if (StringUtils.isEmpty(name) || StringUtils.isEmpty(token)) {
            BaseService.send(ctx, "error:" + name + ":bad:request");
            return false;
        }
        return true;
    }

    public static boolean checkToken(ChannelHandlerContext ctx, String name, String token, String path) {
        return true;
    }
}

