/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.registry.client;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.metadata.MetadataInfo;
import org.apache.dubbo.registry.client.ServiceInstance;
import org.apache.dubbo.rpc.RpcContext;

public class InstanceAddressURL
extends URL {
    private ServiceInstance instance;
    private MetadataInfo metadataInfo;
    private volatile transient Map<String, Number> numbers;
    private volatile transient Map<String, Map<String, Number>> methodNumbers;

    public InstanceAddressURL() {
    }

    public InstanceAddressURL(ServiceInstance instance, MetadataInfo metadataInfo) {
        this.instance = instance;
        this.metadataInfo = metadataInfo;
        this.host = instance.getHost();
        this.port = instance.getPort();
    }

    public ServiceInstance getInstance() {
        return this.instance;
    }

    public MetadataInfo getMetadataInfo() {
        return this.metadataInfo;
    }

    @Override
    public String getServiceInterface() {
        return RpcContext.getContext().getInterfaceName();
    }

    public String getGroup() {
        return RpcContext.getContext().getGroup();
    }

    public String getVersion() {
        return RpcContext.getContext().getVersion();
    }

    @Override
    public String getProtocol() {
        return RpcContext.getContext().getProtocol();
    }

    @Override
    public String getProtocolServiceKey() {
        return RpcContext.getContext().getProtocolServiceKey();
    }

    @Override
    public String getServiceKey() {
        return RpcContext.getContext().getServiceKey();
    }

    @Override
    public String getAddress() {
        return this.instance.getAddress();
    }

    @Override
    public String getPath() {
        MetadataInfo.ServiceInfo serviceInfo = this.metadataInfo.getServiceInfo(this.getProtocolServiceKey());
        return serviceInfo.getPath();
    }

    @Override
    public String getParameter(String key) {
        if ("version".equals(key)) {
            return this.getVersion();
        }
        if ("group".equals(key)) {
            return this.getGroup();
        }
        if ("interface".equals(key)) {
            return this.getServiceInterface();
        }
        if ("remote.application".equals(key)) {
            return this.instance.getServiceName();
        }
        if ("side".equals(key)) {
            return "consumer";
        }
        String protocolServiceKey = this.getProtocolServiceKey();
        if (protocolServiceKey == null) {
            return this.getInstanceParameter(key);
        }
        return this.getServiceParameter(protocolServiceKey, key);
    }

    @Override
    public String getServiceParameter(String service, String key) {
        String value = this.getInstanceParameter(key);
        if (StringUtils.isEmpty(value) && this.metadataInfo != null) {
            value = this.metadataInfo.getParameter(key, service);
        }
        return value;
    }

    @Override
    public String getServiceMethodParameter(String protocolServiceKey, String method, String key) {
        MetadataInfo.ServiceInfo serviceInfo = this.metadataInfo.getServiceInfo(protocolServiceKey);
        String value = serviceInfo.getMethodParameter(method, key, (String)null);
        if (StringUtils.isNotEmpty(value)) {
            return value;
        }
        return this.getParameter(key);
    }

    @Override
    public String getMethodParameter(String method, String key) {
        String protocolServiceKey = this.getProtocolServiceKey();
        if (protocolServiceKey == null) {
            return null;
        }
        return this.getServiceMethodParameter(protocolServiceKey, method, key);
    }

    @Override
    public boolean hasServiceMethodParameter(String protocolServiceKey, String method, String key) {
        MetadataInfo.ServiceInfo serviceInfo = this.metadataInfo.getServiceInfo(protocolServiceKey);
        if (method == null) {
            String suffix = "." + key;
            for (String fullKey : this.getParameters().keySet()) {
                if (!fullKey.endsWith(suffix)) continue;
                return true;
            }
            return false;
        }
        if (key == null) {
            String prefix = method + ".";
            for (String fullKey : this.getParameters().keySet()) {
                if (!fullKey.startsWith(prefix)) continue;
                return true;
            }
            return false;
        }
        return serviceInfo.hasMethodParameter(method, key);
    }

    @Override
    public boolean hasMethodParameter(String method, String key) {
        String protocolServiceKey = this.getProtocolServiceKey();
        if (protocolServiceKey == null) {
            return false;
        }
        return this.hasServiceMethodParameter(protocolServiceKey, method, key);
    }

    @Override
    public boolean hasServiceMethodParameter(String protocolServiceKey, String method) {
        MetadataInfo.ServiceInfo serviceInfo = this.metadataInfo.getServiceInfo(protocolServiceKey);
        return serviceInfo.hasMethodParameter(method);
    }

    @Override
    public boolean hasMethodParameter(String method) {
        String protocolServiceKey = this.getProtocolServiceKey();
        if (protocolServiceKey == null) {
            return false;
        }
        return this.hasServiceMethodParameter(protocolServiceKey, method);
    }

    @Override
    public Map<String, String> getServiceParameters(String protocolServiceKey) {
        Map<String, String> instanceParams = this.getInstanceMetadata();
        Map<Object, Object> metadataParams = this.metadataInfo == null ? new HashMap() : this.metadataInfo.getParameters(protocolServiceKey);
        int i = instanceParams == null ? 0 : instanceParams.size();
        int j = metadataParams == null ? 0 : metadataParams.size();
        HashMap<String, String> params = new HashMap<String, String>((int)((double)(i + j) / 0.75) + 1);
        if (instanceParams != null) {
            params.putAll(instanceParams);
        }
        if (metadataParams != null) {
            params.putAll(metadataParams);
        }
        return params;
    }

    @Override
    public Map<String, String> getParameters() {
        String protocolServiceKey = this.getProtocolServiceKey();
        if (protocolServiceKey == null) {
            return this.getInstance().getAllParams();
        }
        return this.getServiceParameters(protocolServiceKey);
    }

    @Override
    public URL addParameter(String key, String value) {
        if (StringUtils.isEmpty(key) || StringUtils.isEmpty(value)) {
            return this;
        }
        this.getInstance().getExtendParams().put(key, value);
        return this;
    }

    @Override
    public URL addParameterIfAbsent(String key, String value) {
        if (StringUtils.isEmpty(key) || StringUtils.isEmpty(value)) {
            return this;
        }
        this.getInstance().getExtendParams().putIfAbsent(key, value);
        return this;
    }

    public URL addServiceParameter(String protocolServiceKey, String key, String value) {
        if (StringUtils.isEmpty(key) || StringUtils.isEmpty(value)) {
            return this;
        }
        this.getMetadataInfo().getServiceInfo(protocolServiceKey).addParameter(key, value);
        return this;
    }

    public URL addServiceParameterIfAbsent(String protocolServiceKey, String key, String value) {
        if (StringUtils.isEmpty(key) || StringUtils.isEmpty(value)) {
            return this;
        }
        this.getMetadataInfo().getServiceInfo(protocolServiceKey).addParameterIfAbsent(key, value);
        return this;
    }

    public URL addConsumerParams(String protocolServiceKey, Map<String, String> params) {
        this.getMetadataInfo().getServiceInfo(protocolServiceKey).addConsumerParams(params);
        return this;
    }

    @Override
    protected Map<String, Number> getServiceNumbers(String protocolServiceKey) {
        return this.getServiceInfo(protocolServiceKey).getNumbers();
    }

    @Override
    protected Map<String, Number> getNumbers() {
        String protocolServiceKey = this.getProtocolServiceKey();
        if (protocolServiceKey == null) {
            if (this.numbers == null) {
                this.numbers = new ConcurrentHashMap<String, Number>();
            }
            return this.numbers;
        }
        return this.getServiceNumbers(protocolServiceKey);
    }

    @Override
    protected Map<String, Map<String, Number>> getServiceMethodNumbers(String protocolServiceKey) {
        return this.getServiceInfo(protocolServiceKey).getMethodNumbers();
    }

    @Override
    protected Map<String, Map<String, Number>> getMethodNumbers() {
        String protocolServiceKey = this.getProtocolServiceKey();
        if (protocolServiceKey == null) {
            if (this.methodNumbers == null) {
                this.methodNumbers = new ConcurrentHashMap<String, Map<String, Number>>();
            }
            return this.methodNumbers;
        }
        return this.getServiceMethodNumbers(protocolServiceKey);
    }

    private MetadataInfo.ServiceInfo getServiceInfo(String protocolServiceKey) {
        return this.metadataInfo.getServiceInfo(protocolServiceKey);
    }

    private String getInstanceParameter(String key) {
        String value = this.instance.getMetadata().get(key);
        if (StringUtils.isNotEmpty(value)) {
            return value;
        }
        return this.instance.getExtendParams().get(key);
    }

    private Map<String, String> getInstanceMetadata() {
        return this.instance.getMetadata();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceAddressURL)) {
            return false;
        }
        InstanceAddressURL that = (InstanceAddressURL)obj;
        return this.getInstance().equals(that.getInstance());
    }

    @Override
    public int hashCode() {
        return this.getInstance().hashCode();
    }

    public String getServiceString(String service) {
        MetadataInfo.ServiceInfo serviceInfo = this.metadataInfo.getServiceInfo(service);
        if (serviceInfo == null) {
            return this.instance.toString();
        }
        return this.instance.toString() + serviceInfo.toString();
    }

    @Override
    public String toString() {
        if (this.instance == null) {
            return "{}";
        }
        if (this.metadataInfo == null) {
            return this.instance.toString();
        }
        return this.instance.toString() + this.metadataInfo.toString();
    }
}

