/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.cache.support.jcache;

import java.util.concurrent.TimeUnit;
import javax.cache.CacheException;
import javax.cache.CacheManager;
import javax.cache.Caching;
import javax.cache.configuration.Configuration;
import javax.cache.configuration.MutableConfiguration;
import javax.cache.expiry.CreatedExpiryPolicy;
import javax.cache.expiry.Duration;
import javax.cache.spi.CachingProvider;
import org.apache.dubbo.cache.Cache;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.utils.StringUtils;

public class JCache
implements Cache {
    private final javax.cache.Cache<Object, Object> store;

    public JCache(URL url) {
        String method = url.getParameter("method", "");
        String key = url.getAddress() + "." + url.getServiceKey() + "." + method;
        String type = url.getParameter("jcache");
        CachingProvider provider = StringUtils.isEmpty(type) ? Caching.getCachingProvider() : Caching.getCachingProvider((String)type);
        CacheManager cacheManager = provider.getCacheManager();
        javax.cache.Cache cache = cacheManager.getCache(key);
        if (cache == null) {
            try {
                MutableConfiguration config = new MutableConfiguration().setTypes(Object.class, Object.class).setExpiryPolicyFactory(CreatedExpiryPolicy.factoryOf((Duration)new Duration(TimeUnit.MILLISECONDS, (long)url.getMethodParameter(method, "cache.write.expire", 60000)))).setStoreByValue(false).setManagementEnabled(true).setStatisticsEnabled(true);
                cache = cacheManager.createCache(key, (Configuration)config);
            }
            catch (CacheException e) {
                cache = cacheManager.getCache(key);
            }
        }
        this.store = cache;
    }

    @Override
    public void put(Object key, Object value) {
        this.store.put(key, value);
    }

    @Override
    public Object get(Object key) {
        return this.store.get(key);
    }
}

