/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.log.stream.job;

import com.google.gson.Gson;
import com.xiaomi.youpin.docean.Ioc;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.ozhera.log.common.Config;
import org.apache.ozhera.log.model.LogtailConfig;
import org.apache.ozhera.log.model.MilogSpaceData;
import org.apache.ozhera.log.model.SinkConfig;
import org.apache.ozhera.log.stream.common.SinkJobEnum;
import org.apache.ozhera.log.stream.job.SinkJobConfig;
import org.apache.ozhera.log.stream.job.extension.SinkJob;
import org.apache.ozhera.log.stream.job.extension.SinkJobProvider;
import org.apache.ozhera.log.stream.sink.SinkChain;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobManager {
    private static final Logger log = LoggerFactory.getLogger(JobManager.class);
    private static final String SINK_JOB_TYPE_KEY = "sink_job_type";
    private ConcurrentHashMap<Long, Map<SinkJobEnum, SinkJob>> jobs;
    private SinkChain sinkChain;
    private String sinkJobType;
    private Gson gson = new Gson();
    private ReentrantLock stopLock = new ReentrantLock();
    private ReentrantLock startLock = new ReentrantLock();

    public JobManager() {
        this.sinkJobType = Config.ins().get(SINK_JOB_TYPE_KEY, "");
        this.sinkChain = (SinkChain)Ioc.ins().getBean(SinkChain.class);
        this.jobs = new ConcurrentHashMap();
    }

    public void closeJobs(MilogSpaceData milogSpaceData) {
        List configList = milogSpaceData.getSpaceConfig();
        log.info("tasks that are already running:{},The task that is about to be shut down:{}", (Object)this.gson.toJson(this.jobs), (Object)this.gson.toJson((Object)milogSpaceData));
        if (CollectionUtils.isNotEmpty((Collection)configList)) {
            for (SinkConfig sinkConfig : configList) {
                List tailConfigs = sinkConfig.getLogtailConfigs();
                for (LogtailConfig tailConfig : tailConfigs) {
                    try {
                        this.sinkJobsShutDown(tailConfig);
                    }
                    catch (Exception e) {
                        log.error(String.format("[JobManager.closeJobs] closeJob err,logtailId:%s", tailConfig.getLogtailId()), (Throwable)e);
                    }
                }
            }
        }
    }

    private void sinkJobsShutDown(LogtailConfig logtailConfig) {
        Map<SinkJobEnum, SinkJob> sinkJobs = this.jobs.get(logtailConfig.getLogtailId());
        if (null != sinkJobs && !sinkJobs.isEmpty()) {
            sinkJobs.values().forEach(sinkJob -> {
                try {
                    sinkJob.shutdown();
                }
                catch (Exception e) {
                    log.error("[JobManager.shutdown] closeJobs.shutdown error,logTailID:{}", (Object)logtailConfig.getLogtailId(), (Object)e);
                }
            });
        }
        this.jobs.remove(logtailConfig.getLogtailId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopJob(LogtailConfig logtailConfig) {
        boolean locked = false;
        try {
            locked = this.stopLock.tryLock(10L, TimeUnit.SECONDS);
            if (locked) {
                List jobKeys = this.jobs.entrySet().stream().map(Map.Entry::getKey).collect(Collectors.toList());
                log.info("\u3010stop job\u3011,all jobs:{}", jobKeys);
                this.sinkJobsShutDown(logtailConfig);
            } else {
                log.warn("\u3010stop job\u3011,other job is running,wait 10s,tailConfig:{}", (Object)this.gson.toJson((Object)logtailConfig));
            }
        }
        catch (Exception e) {
            log.error(String.format("[JobManager.stopJob] stopJob err,logtailId:%s", logtailConfig.getLogtailId()), (Throwable)e);
        }
        finally {
            if (locked) {
                this.stopLock.unlock();
            }
        }
    }

    private void startConsumerJob(String type, String ak, String sk, String clusterInfo, LogtailConfig logtailConfig, SinkConfig sinkConfig, Long logSpaceId) {
        try {
            SinkJobConfig sinkJobConfig = this.buildSinkJobConfig(type, ak, sk, clusterInfo, logtailConfig, sinkConfig, logSpaceId);
            log.warn("##startConsumerJob## spaceId:{}, storeId:{}, tailId:{}", new Object[]{sinkJobConfig.getLogSpaceId(), sinkJobConfig.getLogStoreId(), sinkJobConfig.getLogTailId()});
            String sinkProviderBean = sinkJobConfig.getMqType() + "SinkJobProvider";
            SinkJobProvider sinkJobProvider = (SinkJobProvider)Ioc.ins().getBean(sinkProviderBean);
            if (StringUtils.equalsIgnoreCase((CharSequence)SinkJobEnum.NORMAL_JOB.name(), (CharSequence)this.sinkJobType)) {
                sinkJobConfig.setJobType(SinkJobEnum.NORMAL_JOB.name());
                this.startSinkJob(sinkJobProvider.getSinkJob(sinkJobConfig), SinkJobEnum.NORMAL_JOB, logtailConfig.getLogtailId());
            }
            if (StringUtils.equalsIgnoreCase((CharSequence)SinkJobEnum.BACKUP_JOB.name(), (CharSequence)this.sinkJobType)) {
                sinkJobConfig.setJobType(SinkJobEnum.BACKUP_JOB.name());
                this.startSinkJob(sinkJobProvider.getBackupJob(sinkJobConfig), SinkJobEnum.BACKUP_JOB, logtailConfig.getLogtailId());
            }
            if (StringUtils.isEmpty((CharSequence)this.sinkJobType)) {
                this.startSinkJob(sinkJobProvider.getSinkJob(sinkJobConfig), SinkJobEnum.NORMAL_JOB, logtailConfig.getLogtailId());
                sinkJobConfig.setJobType(SinkJobEnum.BACKUP_JOB.name());
                this.startSinkJob(sinkJobProvider.getBackupJob(sinkJobConfig), SinkJobEnum.BACKUP_JOB, logtailConfig.getLogtailId());
            }
            log.info(String.format("[JobManager.initJobs] startJob success,logTailId:%s,topic:%s,tag:%s,esIndex:%s", logtailConfig.getLogtailId(), logtailConfig.getTopic(), logtailConfig.getTag(), sinkConfig.getEsIndex()));
        }
        catch (Throwable e) {
            log.error(String.format("[JobManager.initJobs] startJob err,logTailId:%s,topic:%s,tag:%s,esIndex:%s", logtailConfig.getLogtailId(), logtailConfig.getTopic(), logtailConfig.getTag(), sinkConfig.getEsIndex()), (Throwable)new RuntimeException(e));
        }
    }

    private void startSinkJob(SinkJob sinkJob, SinkJobEnum jobEnum, Long tailId) throws Exception {
        if (sinkJob != null && sinkJob.start()) {
            Map jobMap = this.jobs.computeIfAbsent(tailId, k -> new HashMap());
            jobMap.put(jobEnum, sinkJob);
        }
    }

    private SinkJobConfig buildSinkJobConfig(String type, String ak, String sk, String clusterInfo, LogtailConfig logtailConfig, SinkConfig sinkConfig, Long logSpaceId) {
        SinkJobConfig sinkJobConfig = SinkJobConfig.builder().mqType(type).ak(ak).sk(sk).clusterInfo(clusterInfo).topic(logtailConfig.getTopic()).tag(logtailConfig.getTag()).index(sinkConfig.getEsIndex()).keyList(sinkConfig.getKeyList()).valueList(logtailConfig.getValueList()).parseScript(logtailConfig.getParseScript()).logStoreName(sinkConfig.getLogstoreName()).sinkChain(this.getSinkChain()).tail(logtailConfig.getTail()).storageInfo(sinkConfig.getEsInfo()).columnList(sinkConfig.getColumnList()).parseType(logtailConfig.getParseType()).jobType(SinkJobEnum.NORMAL_JOB.name()).storageType(sinkConfig.getStorageType()).consumerGroup(logtailConfig.getConsumerGroup()).build();
        sinkJobConfig.setLogTailId(logtailConfig.getLogtailId());
        sinkJobConfig.setLogStoreId(sinkConfig.getLogstoreId());
        sinkJobConfig.setLogSpaceId(logSpaceId);
        return sinkJobConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startJob(LogtailConfig logtailConfig, SinkConfig sinkConfig, Long logSpaceId) {
        boolean locked = false;
        try {
            locked = this.startLock.tryLock(10L, TimeUnit.SECONDS);
            if (locked) {
                String ak = logtailConfig.getAk();
                String sk = logtailConfig.getSk();
                String clusterInfo = logtailConfig.getClusterInfo();
                String type = logtailConfig.getType();
                if (StringUtils.isEmpty((CharSequence)clusterInfo) || StringUtils.isEmpty((CharSequence)logtailConfig.getTopic())) {
                    log.info("start job error,ak or sk or logtailConfig null,ak:{},sk:{},logtailConfig:{}", new Object[]{ak, sk, new Gson().toJson((Object)logtailConfig)});
                    return;
                }
                this.startConsumerJob(type, ak, sk, clusterInfo, logtailConfig, sinkConfig, logSpaceId);
            } else {
                log.warn("start job error,lock timeout,tailConfig:{},sinkConfig:{}", (Object)this.gson.toJson((Object)logtailConfig), (Object)this.gson.toJson((Object)sinkConfig));
            }
        }
        catch (Exception e) {
            log.error(String.format("[JobManager.startJob] start job err,logTailConfig:%s,esIndex:%s", logtailConfig, sinkConfig.getEsIndex()), (Throwable)e);
        }
        finally {
            if (locked) {
                this.startLock.unlock();
            }
        }
    }

    public void stopAllJob() {
        for (Map.Entry<Long, Map<SinkJobEnum, SinkJob>> sinkJobEntry : this.jobs.entrySet()) {
            sinkJobEntry.getValue().values().forEach(sinkJob -> {
                try {
                    sinkJob.shutdown();
                }
                catch (Exception e) {
                    log.error("[JobManager.shutdown] closeJobs.shutdown error,logTailID:{}", sinkJobEntry.getKey(), (Object)e);
                }
            });
        }
        this.jobs.clear();
    }

    public boolean shutDownJob(SinkJobEnum sinkJobEnum) {
        for (Map<SinkJobEnum, SinkJob> sinkJobMap : this.jobs.values()) {
            try {
                SinkJob sinkJob = sinkJobMap.get((Object)sinkJobEnum);
                sinkJob.shutdown();
            }
            catch (Exception e) {
                log.error("shutDownJob error", (Throwable)e);
            }
        }
        return true;
    }

    public boolean startJob(SinkJobEnum sinkJobEnum) {
        for (Map<SinkJobEnum, SinkJob> sinkJobMap : this.jobs.values()) {
            try {
                SinkJob sinkJob = sinkJobMap.get((Object)sinkJobEnum);
                sinkJob.start();
            }
            catch (Exception e) {
                log.error("startJob error", (Throwable)e);
            }
        }
        return true;
    }

    public ConcurrentHashMap<Long, Map<SinkJobEnum, SinkJob>> getJobs() {
        return this.jobs;
    }

    public SinkChain getSinkChain() {
        return this.sinkChain;
    }

    public String getSinkJobType() {
        return this.sinkJobType;
    }

    public Gson getGson() {
        return this.gson;
    }

    public ReentrantLock getStopLock() {
        return this.stopLock;
    }

    public ReentrantLock getStartLock() {
        return this.startLock;
    }

    public void setJobs(ConcurrentHashMap<Long, Map<SinkJobEnum, SinkJob>> jobs) {
        this.jobs = jobs;
    }

    public void setSinkChain(SinkChain sinkChain) {
        this.sinkChain = sinkChain;
    }

    public void setSinkJobType(String sinkJobType) {
        this.sinkJobType = sinkJobType;
    }

    public void setGson(Gson gson) {
        this.gson = gson;
    }

    public void setStopLock(ReentrantLock stopLock) {
        this.stopLock = stopLock;
    }

    public void setStartLock(ReentrantLock startLock) {
        this.startLock = startLock;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JobManager)) {
            return false;
        }
        JobManager other = (JobManager)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ConcurrentHashMap<Long, Map<SinkJobEnum, SinkJob>> this$jobs = this.getJobs();
        ConcurrentHashMap<Long, Map<SinkJobEnum, SinkJob>> other$jobs = other.getJobs();
        if (this$jobs == null ? other$jobs != null : !((Object)this$jobs).equals(other$jobs)) {
            return false;
        }
        SinkChain this$sinkChain = this.getSinkChain();
        SinkChain other$sinkChain = other.getSinkChain();
        if (this$sinkChain == null ? other$sinkChain != null : !this$sinkChain.equals(other$sinkChain)) {
            return false;
        }
        String this$sinkJobType = this.getSinkJobType();
        String other$sinkJobType = other.getSinkJobType();
        if (this$sinkJobType == null ? other$sinkJobType != null : !this$sinkJobType.equals(other$sinkJobType)) {
            return false;
        }
        Gson this$gson = this.getGson();
        Gson other$gson = other.getGson();
        if (this$gson == null ? other$gson != null : !this$gson.equals(other$gson)) {
            return false;
        }
        ReentrantLock this$stopLock = this.getStopLock();
        ReentrantLock other$stopLock = other.getStopLock();
        if (this$stopLock == null ? other$stopLock != null : !this$stopLock.equals(other$stopLock)) {
            return false;
        }
        ReentrantLock this$startLock = this.getStartLock();
        ReentrantLock other$startLock = other.getStartLock();
        return !(this$startLock == null ? other$startLock != null : !this$startLock.equals(other$startLock));
    }

    protected boolean canEqual(Object other) {
        return other instanceof JobManager;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ConcurrentHashMap<Long, Map<SinkJobEnum, SinkJob>> $jobs = this.getJobs();
        result = result * 59 + ($jobs == null ? 43 : ((Object)$jobs).hashCode());
        SinkChain $sinkChain = this.getSinkChain();
        result = result * 59 + ($sinkChain == null ? 43 : $sinkChain.hashCode());
        String $sinkJobType = this.getSinkJobType();
        result = result * 59 + ($sinkJobType == null ? 43 : $sinkJobType.hashCode());
        Gson $gson = this.getGson();
        result = result * 59 + ($gson == null ? 43 : $gson.hashCode());
        ReentrantLock $stopLock = this.getStopLock();
        result = result * 59 + ($stopLock == null ? 43 : $stopLock.hashCode());
        ReentrantLock $startLock = this.getStartLock();
        result = result * 59 + ($startLock == null ? 43 : $startLock.hashCode());
        return result;
    }

    public String toString() {
        return "JobManager(jobs=" + String.valueOf(this.getJobs()) + ", sinkChain=" + String.valueOf(this.getSinkChain()) + ", sinkJobType=" + this.getSinkJobType() + ", gson=" + String.valueOf(this.getGson()) + ", stopLock=" + String.valueOf(this.getStopLock()) + ", startLock=" + String.valueOf(this.getStartLock()) + ")";
    }
}

