/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.resource;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import org.nutz.lang.Streams;

public abstract class NutResource
implements Comparable<NutResource> {
    protected String name;
    protected String source;
    protected int priority = 100;

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (obj instanceof NutResource) {
            return this.toString().equals(obj.toString());
        }
        return false;
    }

    public abstract InputStream getInputStream() throws IOException;

    public String getName() {
        return this.name;
    }

    public Reader getReader() throws IOException {
        return Streams.utf8r(this.getInputStream());
    }

    public int hashCode() {
        return null == this.name ? "NULL".hashCode() : this.name.hashCode();
    }

    public NutResource setName(String name) {
        this.name = name;
        return this;
    }

    public String toString() {
        return String.format("NutResource[%s]", this.name);
    }

    public void setSource(String source) {
        this.source = source;
    }

    public String getSource() {
        return this.source;
    }

    @Override
    public int compareTo(NutResource o) {
        if (o.priority == this.priority) {
            return 0;
        }
        return o.priority > this.priority ? -1 : 1;
    }

    public int getPriority() {
        return this.priority;
    }

    public NutResource setPriority(int priority) {
        this.priority = priority;
        return this;
    }
}

