/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.mvc.impl;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.nutz.lang.Lang;
import org.nutz.lang.Strings;
import org.nutz.log.Log;
import org.nutz.log.Logs;
import org.nutz.mvc.ActionChain;
import org.nutz.mvc.ActionChainMaker;
import org.nutz.mvc.ActionContext;
import org.nutz.mvc.ActionInfo;
import org.nutz.mvc.Mvcs;
import org.nutz.mvc.NutConfig;
import org.nutz.mvc.RequestPath;
import org.nutz.mvc.UrlMapping;
import org.nutz.mvc.annotation.BlankAtException;
import org.nutz.mvc.impl.ActionInvoker;
import org.nutz.mvc.impl.MappingNode;

public class UrlMappingImpl
implements UrlMapping {
    private static final Log log = Logs.get();
    protected Map<String, ActionInvoker> map = new HashMap<String, ActionInvoker>();
    protected MappingNode<ActionInvoker> root = new MappingNode();
    protected String prefix;

    public UrlMappingImpl() {
    }

    public UrlMappingImpl(String prefix) {
        this();
        this.prefix = prefix;
    }

    @Override
    public void add(ActionChainMaker maker, ActionInfo ai, NutConfig config) {
        String[] paths = ai.getPaths();
        for (int i = 0; i < paths.length; ++i) {
            String path = paths[i];
            if (Strings.isBlank(path)) {
                throw new BlankAtException(ai.getModuleType(), ai.getMethod());
            }
            if (path.charAt(0) == '/') continue;
            paths[i] = '/' + path;
        }
        ActionChain chain = maker.eval(config, ai);
        for (String path : ai.getPaths()) {
            ActionInvoker invoker = this.map.get(path);
            if (null == invoker) {
                invoker = new ActionInvoker();
                this.map.put(path, invoker);
                this.root.add(path, invoker);
                config.getAtMap().addMethod(path, ai.getMethod());
            } else if (!ai.isForSpecialHttpMethod()) {
                log.warnf("Duplicate @At mapping ? path=" + path, new Object[0]);
            }
            if (ai.isForSpecialHttpMethod()) {
                for (String httpMethod : ai.getHttpMethods()) {
                    invoker.addChain(httpMethod, chain);
                }
                continue;
            }
            invoker.setDefaultChain(chain);
        }
        this.printActionMapping(ai);
        if (!Strings.isBlank(ai.getPathKey())) {
            config.getAtMap().add(ai.getPathKey(), ai.getPaths()[0]);
        }
    }

    @Override
    public ActionInvoker get(ActionContext ac) {
        ActionChain chain;
        RequestPath rp = Mvcs.getRequestPathObject(ac.getRequest());
        String path = rp.getPath();
        if (this.prefix != null) {
            path = path.substring(this.prefix.length());
        }
        ac.setSuffix(rp.getSuffix());
        ActionInvoker invoker = this.root.get(ac, path);
        if (invoker != null && (chain = invoker.getActionChain(ac)) != null) {
            if (log.isDebugEnabled()) {
                log.debugf("Found mapping for [%s] path=%s : %s", ac.getRequest().getMethod(), path, chain);
            }
            return invoker;
        }
        if (log.isDebugEnabled()) {
            log.debugf("Search mapping for [%s] path=%s : NOT Action match", ac.getRequest().getMethod(), path);
        }
        return null;
    }

    @Override
    public void add(String path, ActionInvoker invoker) {
        this.root.add(path, invoker);
        this.map.put(path, invoker);
    }

    protected void printActionMapping(ActionInfo ai) {
        this.print(ai);
    }

    protected void print(ActionInfo ai) {
        if (log.isDebugEnabled()) {
            String[] paths = ai.getPaths();
            StringBuilder sb = new StringBuilder();
            if (null != paths && paths.length > 0) {
                sb.append("   '").append(paths[0]).append("'");
                for (int i = 1; i < paths.length; ++i) {
                    sb.append(", '").append(paths[i]).append("'");
                }
            } else {
                throw Lang.impossible();
            }
            Method method = ai.getMethod();
            if (null == method) {
                throw Lang.impossible();
            }
            String str = this.genMethodDesc(ai);
            log.debugf("%s >> %50s | @Ok(%-5s) @Fail(%-5s) | by %d Filters | (I:%s/O:%s)", Strings.alignLeft(sb, 30, ' '), str, ai.getOkView(), ai.getFailView(), null == ai.getFilterInfos() ? 0 : ai.getFilterInfos().length, ai.getInputEncoding(), ai.getOutputEncoding());
        }
    }

    protected String genMethodDesc(ActionInfo ai) {
        Method method = ai.getMethod();
        String prefix = "";
        prefix = ai.getLineNumber() != null && ai.getLineNumber() > 0 ? String.format("(%s.java:%d).%s", method.getDeclaringClass().getSimpleName(), ai.getLineNumber(), method.getName()) : String.format("%s.%s(...)", method.getDeclaringClass().getSimpleName(), method.getName());
        return String.format("%-37s : %-10s", prefix, method.getReturnType().getSimpleName());
    }
}

