/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.lang.segment;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.nutz.lang.Lang;
import org.nutz.lang.Mirror;
import org.nutz.lang.segment.Segment;
import org.nutz.lang.segment.SegmentNode;
import org.nutz.lang.util.Context;
import org.nutz.lang.util.NutMap;

public class CharSegment
implements Segment,
Cloneable {
    private String orgString;
    private Context context;
    private List<SegmentNode> nodes;
    private NutMap keys;

    public CharSegment() {
    }

    public CharSegment(String str) {
        this.valueOf(str);
    }

    @Override
    public Segment add(String key, Object v) {
        if (!this.context.has(key)) {
            this.context.set(key, v);
            return this;
        }
        Object val = this.context.get(key);
        if (val == null) {
            this.context.set(key, v);
        } else if (val instanceof Collection) {
            ((Collection)val).add(v);
        } else {
            LinkedList<Object> objSet = new LinkedList<Object>();
            objSet.add(val);
            objSet.add(v);
            this.context.set(key, objSet);
        }
        return this;
    }

    @Override
    public void clearAll() {
        this.context.clear();
    }

    @Override
    public boolean contains(String key) {
        return this.keys.containsKey(key);
    }

    @Override
    public Segment born() {
        return new CharSegment(this.getOrginalString());
    }

    @Override
    public String getOrginalString() {
        return this.orgString;
    }

    @Override
    public Segment clone() {
        CharSegment cs = new CharSegment();
        cs.parse(Lang.inr(this.orgString));
        cs.context = this.context.clone();
        return cs;
    }

    @Override
    public Set<String> keys() {
        return this.keys.keySet();
    }

    @Override
    public int keyCount() {
        return this.keys.size();
    }

    @Override
    public boolean hasKey() {
        return !this.keys.isEmpty();
    }

    @Override
    public List<Object> values() {
        ArrayList<Object> re = new ArrayList<Object>(this.nodes.size());
        for (SegmentNode node : this.nodes) {
            if (node.isKey()) {
                re.add(this.context.get(node.getValue()));
                continue;
            }
            re.add(node.getValue());
        }
        return re;
    }

    @Override
    public Segment setAll(Object v) {
        for (String key : this.keys()) {
            this.context.set(key, v);
        }
        return this;
    }

    @Override
    public Segment setBy(Object obj) {
        Iterator<String> it = this.keys().iterator();
        Class<?> klass = obj.getClass();
        Mirror<Class<Map>> mirror = Mirror.me(klass);
        if (mirror.isStringLike() || mirror.isBoolean() || mirror.isNumber() || mirror.isChar()) {
            this.setAll(obj);
        } else if (mirror.isOf(Map.class)) {
            Map map = (Map)obj;
            while (it.hasNext()) {
                String key = it.next();
                try {
                    this.set(key, map.get(key));
                }
                catch (Exception e) {
                    this.set(key, "");
                }
            }
        } else {
            while (it.hasNext()) {
                String key = it.next();
                try {
                    this.set(key, mirror.getValue(obj, key));
                }
                catch (Exception e) {
                    this.set(key, "");
                }
            }
        }
        return this;
    }

    @Override
    public Segment set(String key, Object v) {
        this.context.set(key, v);
        return this;
    }

    @Override
    public List<SegmentNode> getNodes() {
        return this.nodes;
    }

    @Override
    public void parse(Reader reader) {
        this.nodes = new LinkedList<SegmentNode>();
        this.context = Lang.context();
        this.keys = new NutMap();
        StringBuilder org = new StringBuilder();
        StringBuilder sb = new StringBuilder();
        try {
            int b;
            block5: while (-1 != (b = reader.read())) {
                org.append((char)b);
                switch (b) {
                    case 36: {
                        b = reader.read();
                        if (b == -1) {
                            b = 36;
                        }
                        org.append((char)b);
                        if (b == 36) {
                            sb.append((char)b);
                            continue block5;
                        }
                        if (b == 123) {
                            if (sb.length() > 0) {
                                this.nodes.add(SegmentNode.val(sb.toString()));
                                sb = new StringBuilder();
                            }
                            while (-1 != (b = reader.read())) {
                                org.append((char)b);
                                if (b == 125) break;
                                sb.append((char)b);
                            }
                            if (b != 125) {
                                throw Lang.makeThrow("Error format around '%s'", sb);
                            }
                            String key = sb.toString();
                            this.nodes.add(SegmentNode.key(key));
                            this.keys.put(key, null);
                            sb = new StringBuilder();
                            continue block5;
                        }
                        sb.append('$').append((char)b);
                        continue block5;
                    }
                }
                sb.append((char)b);
            }
            if (sb.length() > 0) {
                this.nodes.add(SegmentNode.val(sb.toString()));
            }
            this.orgString = org.toString();
        }
        catch (IOException e) {
            throw Lang.wrapThrow(e);
        }
    }

    @Override
    public Segment valueOf(String str) {
        this.parse(new StringReader(str));
        return this;
    }

    @Override
    public CharSequence render() {
        return this.render(this.context);
    }

    @Override
    public CharSequence render(Context context) {
        StringBuilder sb = new StringBuilder();
        for (SegmentNode node : this.nodes) {
            Object val = node.isKey() ? context.get(node.getValue()) : node.getValue();
            if (null == val) continue;
            if (val instanceof Collection) {
                for (Object obj : (Collection)val) {
                    sb.append(obj);
                }
                continue;
            }
            sb.append(val);
        }
        return sb;
    }

    @Override
    public Context getContext() {
        return this.context;
    }

    @Override
    public void fillNulls(Context context) {
        for (String key : this.keys.keySet()) {
            Object val = context.get(key);
            if (null != val) continue;
            context.set(key, "${" + key + "}");
        }
    }

    public String toString() {
        return this.render().toString();
    }
}

