/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.json.handler;

import java.io.IOException;
import java.util.Map;
import org.nutz.json.JsonFormat;
import org.nutz.json.JsonRender;
import org.nutz.json.JsonShape;
import org.nutz.json.JsonTypeHandler;
import org.nutz.lang.Lang;
import org.nutz.lang.Mirror;
import org.nutz.lang.util.NutMap;

public class JsonEnumHandler
extends JsonTypeHandler {
    @Override
    public boolean supportFromJson(Mirror<?> mirror, Object obj) {
        return mirror.isEnum();
    }

    @Override
    public boolean supportToJson(Mirror<?> mirror, Object obj, JsonFormat jf) {
        return mirror.isEnum();
    }

    @Override
    public void toJson(Mirror<?> mirror, Object currentObj, JsonRender r, JsonFormat jf) throws IOException {
        Mirror<Class<?>> mr = Mirror.me(currentObj.getClass());
        if (mr.isEnum()) {
            JsonShape shape = Mirror.getAnnotationDeep(mr.getType(), JsonShape.class);
            if (shape == null || jf.isIgnoreJsonShape()) {
                r.string2Json(((Enum)currentObj).name());
            } else {
                switch (shape.value()) {
                    case ORDINAL: {
                        r.writeRaw(String.valueOf(((Enum)currentObj).ordinal()));
                        break;
                    }
                    case OBJECT: {
                        NutMap map = Lang.obj2nutmap(currentObj);
                        if (map.isEmpty()) {
                            r.string2Json(((Enum)currentObj).name());
                            break;
                        }
                        r.map2Json(map);
                        break;
                    }
                    case OBJECTWITHNAME: {
                        NutMap map = Lang.obj2nutmap(currentObj);
                        map.setv(shape.nameKey(), ((Enum)currentObj).name());
                        r.map2Json(map);
                        break;
                    }
                    default: {
                        r.string2Json(((Enum)currentObj).name());
                    }
                }
            }
        }
    }

    @Override
    public Object fromJson(Object obj, Mirror<?> mirror) throws Exception {
        String name = obj instanceof Map ? (String)((Map)obj).get("name") : String.valueOf(obj);
        return Enum.valueOf(mirror.getType(), name);
    }
}

