/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.prometheus.agent.util;

import com.alibaba.nacos.api.config.annotation.NacosValue;
import java.util.ArrayList;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class MailUtil {
    private static final Logger log = LoggerFactory.getLogger(MailUtil.class);
    @NacosValue(value="${mail.user.name}", autoRefreshed=true)
    private String mail_user_name;
    @NacosValue(value="${mail.pwd.code}", autoRefreshed=true)
    private String mail_pwd_code;
    @NacosValue(value="${mail.host}", autoRefreshed=true)
    private String mail_host;
    @NacosValue(value="${mail.smtp.auth}", autoRefreshed=true)
    private String mail_smtp_auth;
    @NacosValue(value="${mail.smtp.port}", autoRefreshed=true)
    private String mail_smtp_port;
    private Session myMailSession;

    private Session getMailSession() {
        if (null != this.myMailSession) {
            return this.myMailSession;
        }
        Properties properties = new Properties();
        properties.setProperty("mail.transport.protocol", "smtp");
        properties.setProperty("mail.host", this.mail_host);
        properties.setProperty("mail.smtp.auth", this.mail_smtp_auth);
        properties.setProperty("mail.smtp.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
        properties.setProperty("mail.smtp.port", this.mail_smtp_port);
        properties.setProperty("mail.smtp.socketFactory.fallback", "false");
        properties.setProperty("mail.smtp.socketFactory.port", this.mail_smtp_port);
        properties.put("mail.smtp.starttls.enable", "false");
        properties.put("mail.smtp.starttls.required", this.mail_smtp_auth);
        if (this.mail_smtp_auth.equals("true")) {
            properties.put("mail.smtp.ssl.protocols", "TLSv1.2");
        }
        log.info("mail property: {}", (Object)properties.toString());
        Authenticator authenticator = new Authenticator(){

            public PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(MailUtil.this.mail_user_name, MailUtil.this.mail_pwd_code);
            }
        };
        this.myMailSession = Session.getDefaultInstance((Properties)properties, (Authenticator)authenticator);
        return this.myMailSession;
    }

    public void sendMailTOSingleUser(String toEmailAddress, String title, String content) {
        log.info("sendMailTOSingleUser: toEmailAddress:{}, title:{}, content:{}", new Object[]{toEmailAddress, title, content});
        Session session = this.getMailSession();
        MimeMessage message = new MimeMessage(session);
        try {
            message.setFrom((Address)new InternetAddress(this.mail_user_name));
            message.setRecipient(MimeMessage.RecipientType.TO, (Address)new InternetAddress(toEmailAddress));
            message.setRecipient(Message.RecipientType.CC, (Address)new InternetAddress(this.mail_user_name));
            message.setSubject(title);
            message.setContent((Object)content, "text/html;charset=UTF-8");
            Transport.send((Message)message);
        }
        catch (MessagingException e) {
            e.printStackTrace();
        }
    }

    public void sendMailToUserArray(ArrayList<String> toEmailAddressArrayList, String title, String content) {
        log.info("sendMailToUserArray: toEmailAddressArrayList:{}, title:{}, content:{}", new Object[]{toEmailAddressArrayList, title, content});
        String[] toEmailAddressArray = toEmailAddressArrayList.toArray(new String[0]);
        Session session = this.getMailSession();
        MimeMessage message = new MimeMessage(session);
        try {
            message.setFrom((Address)new InternetAddress(this.mail_user_name));
            if (toEmailAddressArray != null) {
                InternetAddress[] toEmailRecipients = null;
                toEmailRecipients = new InternetAddress[toEmailAddressArray.length];
                for (int i = 0; i < toEmailAddressArray.length; ++i) {
                    toEmailRecipients[i] = new InternetAddress(toEmailAddressArray[i]);
                }
                message.setRecipients(MimeMessage.RecipientType.TO, (Address[])toEmailRecipients);
            }
            message.setRecipient(Message.RecipientType.CC, (Address)new InternetAddress(this.mail_user_name));
            message.setSubject(title);
            message.setContent((Object)content, "text/html;charset=UTF-8");
            Transport.send((Message)message);
        }
        catch (MessagingException ex) {
            ex.printStackTrace();
        }
    }
}

