/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomi.data.push.client;

import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.DefaultEventLoop;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpContentDecompressor;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.concurrent.DefaultPromise;
import io.netty.util.concurrent.EventExecutor;
import java.net.URI;
import java.util.Map;

public class HttpClientV3 {
    public String get(String url, Map<String, String> headers) {
        try {
            URI uri = new URI(url);
            int port = uri.getPort();
            port = port == -1 ? 80 : port;
            DefaultPromise promise = new DefaultPromise((EventExecutor)new DefaultEventLoop());
            Bootstrap bootstrap = this.getBootstrap((DefaultPromise<String>)promise);
            Channel channel = bootstrap.connect(uri.getHost(), port).sync().channel();
            DefaultFullHttpRequest httpRequest = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, uri.getPath());
            httpRequest.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderNames.CONNECTION);
            httpRequest.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)httpRequest.content().readableBytes());
            headers.entrySet().stream().forEach(it -> httpRequest.headers().set((String)it.getKey(), it.getValue()));
            channel.writeAndFlush((Object)httpRequest);
            return (String)promise.get();
        }
        catch (Throwable ex) {
            return ex.getMessage();
        }
    }

    public String post(String url, String body, Map<String, String> headers) {
        try {
            URI uri = new URI(url);
            int port = uri.getPort();
            port = port == -1 ? 80 : port;
            DefaultPromise promise = new DefaultPromise((EventExecutor)new DefaultEventLoop());
            Bootstrap bootstrap = this.getBootstrap((DefaultPromise<String>)promise);
            Channel channel = bootstrap.connect(uri.getHost(), port).sync().channel();
            ByteBuf buffer = Unpooled.wrappedBuffer((byte[])body.getBytes());
            DefaultFullHttpRequest httpRequest = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.POST, uri.getPath(), buffer);
            httpRequest.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderNames.CONNECTION);
            httpRequest.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)body.length());
            headers.entrySet().stream().forEach(it -> httpRequest.headers().set((String)it.getKey(), it.getValue()));
            channel.writeAndFlush((Object)httpRequest);
            return (String)promise.get();
        }
        catch (Throwable ex) {
            return ex.getMessage();
        }
    }

    private Bootstrap getBootstrap(final DefaultPromise<String> promise) {
        Bootstrap bootstrap = new Bootstrap();
        ((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)bootstrap.group((EventLoopGroup)new NioEventLoopGroup(1))).channel(NioSocketChannel.class)).option(ChannelOption.SO_KEEPALIVE, (Object)true)).option(ChannelOption.TCP_NODELAY, (Object)true)).handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            protected void initChannel(SocketChannel socketChannel) {
                socketChannel.pipeline().addLast(new ChannelHandler[]{new HttpClientCodec()});
                socketChannel.pipeline().addLast(new ChannelHandler[]{new HttpContentDecompressor()});
                socketChannel.pipeline().addLast(new ChannelHandler[]{new HttpObjectAggregator(123433)});
                socketChannel.pipeline().addLast(new ChannelHandler[]{new HttpClientMsgHandler(HttpClientV3.this, (DefaultPromise<String>)promise)});
            }
        });
        return bootstrap;
    }

    private class HttpClientMsgHandler
    extends SimpleChannelInboundHandler<FullHttpResponse> {
        private DefaultPromise<String> promise;

        public HttpClientMsgHandler(HttpClientV3 httpClientV3, DefaultPromise<String> promise) {
            this.promise = promise;
        }

        protected void channelRead0(ChannelHandlerContext ctx, FullHttpResponse msg) throws Exception {
            if (msg.content() != null) {
                byte[] data = new byte[msg.content().readableBytes()];
                msg.content().getBytes(0, data);
                this.promise.setSuccess((Object)new String(data));
            } else {
                this.promise.setSuccess((Object)"");
            }
        }
    }
}

