/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.prometheus.agent.config;

import com.alibaba.nacos.api.config.annotation.NacosValue;
import org.apache.ozhera.prometheus.agent.alertManagerClient.AlertManagerAliClient;
import org.apache.ozhera.prometheus.agent.alertManagerClient.AlertManagerClient;
import org.apache.ozhera.prometheus.agent.alertManagerClient.AlertManagerVMClient;
import org.apache.ozhera.prometheus.agent.client.Client;
import org.apache.ozhera.prometheus.agent.enums.ClientType;
import org.apache.ozhera.prometheus.agent.operators.BasicOperator;
import org.apache.ozhera.prometheus.agent.operators.ali.AliPrometheusOperator;
import org.apache.ozhera.prometheus.agent.operators.local.LocalPrometheusOperator;
import org.apache.ozhera.prometheus.agent.operators.vm.VMPrometheusOperator;
import org.apache.ozhera.prometheus.agent.prometheusClient.PrometheusAliClient;
import org.apache.ozhera.prometheus.agent.prometheusClient.PrometheusClient;
import org.apache.ozhera.prometheus.agent.prometheusClient.PrometheusVMClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(name={"service.selector.property"}, havingValue="outer")
public class ClientConfiguration {
    private static final Logger log = LoggerFactory.getLogger(ClientConfiguration.class);
    @NacosValue(value="${prometheus-agent.client.type:local}")
    private String prometheusAgentClientType;

    @Bean
    public BasicOperator prometheusOperator() {
        if (ClientType.LOCAL.getDesc().equals(this.prometheusAgentClientType)) {
            return new LocalPrometheusOperator();
        }
        if (ClientType.VM.getDesc().equals(this.prometheusAgentClientType)) {
            return new VMPrometheusOperator();
        }
        return new AliPrometheusOperator();
    }

    @Bean(name={"PrometheusClient"})
    public Client PrometheusClient() {
        if (ClientType.LOCAL.getDesc().equals(this.prometheusAgentClientType)) {
            return new PrometheusClient();
        }
        if (ClientType.VM.getDesc().equals(this.prometheusAgentClientType)) {
            return new PrometheusVMClient();
        }
        return new PrometheusAliClient();
    }

    @Bean(name={"AlertManagerClient"})
    public Client AlertManagerClient() {
        if (ClientType.LOCAL.getDesc().equals(this.prometheusAgentClientType)) {
            return new AlertManagerClient();
        }
        if (ClientType.VM.getDesc().equals(this.prometheusAgentClientType)) {
            return new AlertManagerVMClient();
        }
        return new AlertManagerAliClient();
    }
}

