/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.app.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.handlers.JacksonTypeHandler;
import java.time.Instant;
import java.util.List;
import java.util.Random;
import org.apache.commons.lang3.StringUtils;
import org.apache.ozhera.app.api.model.HeraSimpleEnv;
import org.apache.ozhera.app.enums.OperateEnum;
import org.apache.ozhera.app.exception.AppException;
import org.apache.ozhera.app.model.BaseCommon;
import org.apache.ozhera.app.model.vo.HeraAppEnvVo;
import org.apache.ozhera.app.model.vo.HeraAppOperateVo;
import org.springframework.beans.BeanUtils;

@TableName(value="hera_app_env", autoResultMap=true)
public class HeraAppEnv
extends BaseCommon {
    @TableId(value="id", type=IdType.AUTO)
    private Long id;
    private Long heraAppId;
    private Long appId;
    private String appName;
    private Long envId;
    private String envName;
    @TableField(value="ip_list", typeHandler=JacksonTypeHandler.class)
    private List<String> ipList;

    public HeraAppEnvVo toHeraAppEnvVo() {
        HeraAppEnvVo heraAppEnvVo = new HeraAppEnvVo();
        try {
            BeanUtils.copyProperties((Object)((Object)this), (Object)heraAppEnvVo);
            return heraAppEnvVo;
        }
        catch (Exception e) {
            throw new AppException("\u6570\u636e\u8f6c\u5316\u5f02\u5e38", (Throwable)e);
        }
    }

    public HeraAppEnv operateVoToHeraAppEnv(HeraAppOperateVo operateVo, OperateEnum operateEnum) {
        if (StringUtils.isBlank((CharSequence)operateVo.getEnvName())) {
            operateVo.setEnvName("staging");
        }
        if (null == operateVo.getEnvId()) {
            operateVo.setEnvId(Long.valueOf(new Random().nextInt(4000)));
        }
        BeanUtils.copyProperties((Object)operateVo, (Object)((Object)this));
        if (OperateEnum.ADD_OPERATE == operateEnum) {
            this.setCtime(Instant.now().toEpochMilli());
            this.setCreator(operateVo.getOperator());
        }
        this.setUtime(Instant.now().toEpochMilli());
        this.setUpdater(operateVo.getOperator());
        return this;
    }

    public HeraSimpleEnv toHeraSimpleEnv() {
        return HeraSimpleEnv.builder().id(this.id).name(this.envName).ips(this.ipList).build();
    }

    public Long getId() {
        return this.id;
    }

    public Long getHeraAppId() {
        return this.heraAppId;
    }

    public Long getAppId() {
        return this.appId;
    }

    public String getAppName() {
        return this.appName;
    }

    public Long getEnvId() {
        return this.envId;
    }

    public String getEnvName() {
        return this.envName;
    }

    public List<String> getIpList() {
        return this.ipList;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setHeraAppId(Long heraAppId) {
        this.heraAppId = heraAppId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public void setEnvId(Long envId) {
        this.envId = envId;
    }

    public void setEnvName(String envName) {
        this.envName = envName;
    }

    public void setIpList(List<String> ipList) {
        this.ipList = ipList;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HeraAppEnv)) {
            return false;
        }
        HeraAppEnv other = (HeraAppEnv)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Long this$heraAppId = this.getHeraAppId();
        Long other$heraAppId = other.getHeraAppId();
        if (this$heraAppId == null ? other$heraAppId != null : !((Object)this$heraAppId).equals(other$heraAppId)) {
            return false;
        }
        Long this$appId = this.getAppId();
        Long other$appId = other.getAppId();
        if (this$appId == null ? other$appId != null : !((Object)this$appId).equals(other$appId)) {
            return false;
        }
        Long this$envId = this.getEnvId();
        Long other$envId = other.getEnvId();
        if (this$envId == null ? other$envId != null : !((Object)this$envId).equals(other$envId)) {
            return false;
        }
        String this$appName = this.getAppName();
        String other$appName = other.getAppName();
        if (this$appName == null ? other$appName != null : !this$appName.equals(other$appName)) {
            return false;
        }
        String this$envName = this.getEnvName();
        String other$envName = other.getEnvName();
        if (this$envName == null ? other$envName != null : !this$envName.equals(other$envName)) {
            return false;
        }
        List<String> this$ipList = this.getIpList();
        List<String> other$ipList = other.getIpList();
        return !(this$ipList == null ? other$ipList != null : !((Object)this$ipList).equals(other$ipList));
    }

    protected boolean canEqual(Object other) {
        return other instanceof HeraAppEnv;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Long $heraAppId = this.getHeraAppId();
        result = result * 59 + ($heraAppId == null ? 43 : ((Object)$heraAppId).hashCode());
        Long $appId = this.getAppId();
        result = result * 59 + ($appId == null ? 43 : ((Object)$appId).hashCode());
        Long $envId = this.getEnvId();
        result = result * 59 + ($envId == null ? 43 : ((Object)$envId).hashCode());
        String $appName = this.getAppName();
        result = result * 59 + ($appName == null ? 43 : $appName.hashCode());
        String $envName = this.getEnvName();
        result = result * 59 + ($envName == null ? 43 : $envName.hashCode());
        List<String> $ipList = this.getIpList();
        result = result * 59 + ($ipList == null ? 43 : ((Object)$ipList).hashCode());
        return result;
    }

    public String toString() {
        return "HeraAppEnv(id=" + this.getId() + ", heraAppId=" + this.getHeraAppId() + ", appId=" + this.getAppId() + ", appName=" + this.getAppName() + ", envId=" + this.getEnvId() + ", envName=" + this.getEnvName() + ", ipList=" + String.valueOf(this.getIpList()) + ")";
    }
}

