<!--
  Licensed to the Apache Software Foundation (ASF) under one
  or more contributor license agreements.  See the NOTICE file
  distributed with this work for additional information
  regarding copyright ownership.  The ASF licenses this file
  to you under the Apache License, Version 2.0 (the
  "License"); you may not use this file except in compliance
  with the License.  You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing,
  software distributed under the License is distributed on an
  "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
  KIND, either express or implied.  See the License for the
  specific language governing permissions and limitations
  under the License.
  -->

## Kogito
**Kogito** is the next generation of business automation platform focused on cloud-native development, deployment and execution.

<p align="center"><img width=55% height=55% src="docsimg/kogito.png"></p>

[![GitHub Stars](https://img.shields.io/github/stars/apache/incubator-kie-kogito-runtimes.svg)](https://github.com/apache/incubator-kie-kogito-runtimes/stargazers)
[![GitHub Forks](https://img.shields.io/github/forks/apache/incubator-kie-kogito-runtimes.svg)](https://github.com/apache/incubator-kie-kogito-runtimes/network/members)
[![GitHub Issues](https://img.shields.io/github/issues/apache/incubator-kie-kogito-runtimes.svg)](https://github.com/apache/incubator-kie-kogito-runtimes/issues)
[![Pull Requests](https://img.shields.io/github/issues-pr/apache/incubator-kie-kogito-runtimes.svg?style=flat-square)](https://github.com/apache/incubator-kie-kogito-runtimes/pulls)
[![Zulip chat](https://img.shields.io/badge/zulip-join_chat-brightgreen.svg)]( https://kie.zulipchat.com)
[![Contributors](https://img.shields.io/github/contributors/apache/incubator-kie-kogito-runtimes.svg?style=flat-square)](https://github.com/apache/incubator-kie-kogito-runtimes/graphs/contributors)
[![License](https://img.shields.io/github/license/apache/incubator-kie-kogito-runtimes.svg)](https://github.com/apache/incubator-kie-kogito-runtimes/blob/main/LICENSE)
[![Twitter Follow](https://img.shields.io/twitter/follow/kogito_kie.svg?label=Follow&style=social)](https://twitter.com/kogito_kie?lang=en)

## Quick Links
**Homepage:** https://kie.apache.org

**Guides and Documentation:** https://kie.apache.org/docs/documentation/

**GitHub Issues:** https://github.com/apache/incubator-kie-issues/issues

## Requirements
- [Maven](https://maven.apache.org/) 3.9.6 or later
- [Java](https://openjdk.java.net/install/) 17 or later (devel package)
- optional: Docker installation for running integration tests

## Getting Started
The [Kogito Examples repository](https://github.com/apache/incubator-kie-kogito-examples) module contains a number of examples that you can take a look at and try out yourself. Please take a look at the readme of each individual example for more details on how the example works and how to run it yourself (either locally or on Kubernetes).

## Guides
The official guides for Kogito can be found at our main website, these include guides for Quarkus and Spring Boot.

- [Kogito Documentation](https://kie.apache.org/docs/documentation/).

If you want to read more about Quarkus:

- [Quarkus - Getting Started](https://quarkus.io/get-started/) - Quarkus Getting Started guide
- [Quarkus - Using Kogito to add business automation capabilities to an application](https://quarkus.io/guides/kogito) - A simple quick start hosted on the Quarkus web site.

## Building and Contributing to Kogito
All contributions are welcome! Before you start please read the [contribution guide](CONTRIBUTING.md).

## Getting Help
### Issues
- Do you have a [minimal, reproducible example](https://stackoverflow.com/help/minimal-reproducible-example) for your issue?
  - If so, please open a new issues for it in the [issues](https://github.com/apache/incubator-kie-issues/issues) with the details of your issue and example.
- Are you encountering an issue but unsure of what is going on? 
  - Start a new conversation in the Apache KIE [users mailing list](https://lists.apache.org/list.html?users@kie.apache.org), or open a new thread in the [Kogito stream](https://kie.zulipchat.com/#narrow/stream/232676-kogito) of the KIE Zulip chat.
  - Please provide as much relevant information as you can as to what could be causing the issue, and our developers will help you figure out what's going wrong.

### Requests
- Do you have a feature/enhancement request?
  - Please open a new thread in the [Kogito stream](https://kie.zulipchat.com/#narrow/stream/232676-kogito) of the KIE Zulip chat to start a discussion there.
