/*
 * Decompiled with CFR 0.152.
 */
package org.lionsoul.jcseg.segmenter;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.LinkedList;
import org.lionsoul.jcseg.ISegment;
import org.lionsoul.jcseg.IWord;
import org.lionsoul.jcseg.dic.ADictionary;
import org.lionsoul.jcseg.fi.CharTypeFunction;
import org.lionsoul.jcseg.segmenter.SegKit;
import org.lionsoul.jcseg.segmenter.SegmenterConfig;
import org.lionsoul.jcseg.segmenter.Word;
import org.lionsoul.jcseg.util.IPushbackReader;
import org.lionsoul.jcseg.util.IStringBuffer;
import org.lionsoul.jcseg.util.StringUtil;

public class NGramSeg
implements ISegment {
    protected int idx;
    protected IPushbackReader reader = null;
    protected final LinkedList<IWord> wordPool;
    protected final IStringBuffer isb;
    public final ADictionary dic;
    public final SegmenterConfig config;
    protected byte N = 1;

    public NGramSeg(SegmenterConfig config, ADictionary dic) {
        assert (config.getGRAM() > 0);
        this.config = config;
        this.dic = dic;
        this.N = config.getGRAM();
        this.wordPool = new LinkedList();
        this.isb = new IStringBuffer(this.N + 1);
    }

    @Override
    public void reset(Reader input) throws IOException {
        if (input != null) {
            this.reader = new IPushbackReader(new BufferedReader(input));
        }
        this.idx = -1;
    }

    @Override
    public int getStreamPosition() {
        return this.idx + 1;
    }

    protected int readNext() throws IOException {
        int c = this.reader.read();
        if (c != -1) {
            ++this.idx;
        }
        return c;
    }

    protected void pushBack(int data) throws IOException {
        this.reader.unread(data);
        --this.idx;
    }

    protected void streamResetTo(String str, int start) throws IOException {
        for (int i = start; i < str.length(); ++i) {
            this.pushBack(str.charAt(i));
        }
    }

    @Override
    public IWord next() throws IOException {
        int c;
        if (this.wordPool.size() > 0) {
            return this.wordPool.remove();
        }
        CharTypeFunction checker = null;
        String[] pofs = null;
        IWord word = null;
        while ((c = this.readNext()) != -1) {
            String str;
            if (StringUtil.isWhitespace(c)) continue;
            int pos = this.idx;
            int type = 0;
            checker = null;
            pofs = null;
            if (StringUtil.isPunctuation(c)) {
                str = String.valueOf((char)c);
                if (this.config.CLEAR_STOPWORD && this.dic.match(7, str)) continue;
                word = new Word(str, 10);
                word.setPartSpeechForNull(IWord.PUNCTUATION);
                word.setPosition(pos);
                return word;
            }
            if (StringUtil.isCJKChar(c)) {
                type = 1;
                checker = StringUtil::isCJKChar;
            } else if (StringUtil.isEnLetter(c)) {
                type = 5;
                checker = StringUtil::isEnLetter;
                pofs = IWord.EN_POSPEECH;
                if (c > 65280) {
                    c -= 65248;
                }
                if (c >= 65 && c <= 90) {
                    c += 32;
                }
            } else if (StringUtil.isLetterNumber(c)) {
                type = 6;
                checker = StringUtil::isLetterNumber;
                pofs = IWord.NUMERIC_POSPEECH;
            } else if (StringUtil.isOtherNumber(c)) {
                type = 7;
                checker = StringUtil::isOtherNumber;
                pofs = IWord.NUMERIC_POSPEECH;
            } else if (this.config.KEEP_UNREG_WORDS) {
                str = String.valueOf((char)c);
                if (this.config.CLEAR_STOPWORD && this.dic.match(7, str)) continue;
                word = new Word(str, 11);
                word.setPartSpeechForNull(IWord.UNRECOGNIZE);
                word.setPosition(pos);
                return word;
            }
            String string = str = this.N == 1 ? String.valueOf((char)c) : this.getNextType(c, type, checker);
            if (this.config.CLEAR_STOPWORD && this.dic.match(7, str)) {
                if (this.N <= 1) continue;
                this.streamResetTo(str, 1);
                continue;
            }
            boolean append_syn = this.config.LOAD_CJK_SYN && this.config.APPEND_CJK_SYN;
            boolean append_pinyin = this.config.LOAD_CJK_PINYIN && this.config.APPEND_CJK_PINYIN;
            word = append_syn || append_pinyin ? this.wordNewOrClone(0, str, type) : new Word(str, type);
            word.setPosition(pos);
            word.setPartSpeechForNull(pofs);
            if (append_syn && word.getSyn() != null) {
                SegKit.appendSynonyms(this.config, this.wordPool, word);
            }
            if (append_pinyin && word.getPinyin() != null) {
                SegKit.appendPinyin(this.config, this.wordPool, word);
            }
            if (this.N > 1) {
                this.streamResetTo(str, 1);
            }
            return word;
        }
        return null;
    }

    protected String getNextType(int c, int type, CharTypeFunction checker) throws IOException {
        int ch;
        this.isb.clear().append((char)c);
        while ((ch = this.readNext()) != -1) {
            if (type == 5) {
                if (ch > 65280) {
                    ch -= 65248;
                }
                if (ch >= 65 && ch <= 90) {
                    ch += 32;
                }
            }
            if (StringUtil.isWhitespace(ch)) {
                this.pushBack(ch);
                break;
            }
            if (!checker.is(ch)) {
                this.pushBack(ch);
                break;
            }
            this.isb.append((char)ch);
            if (this.isb.length() < this.N) continue;
            break;
        }
        return this.isb.toString();
    }

    public IWord wordNewOrClone(int t, String str, int type) {
        return this.dic.match(t, str) ? this.dic.get(t, str).clone() : new Word(str, type);
    }

    public ADictionary getDic() {
        return this.dic;
    }

    public SegmenterConfig getConfig() {
        return this.config;
    }

    public byte getN() {
        return this.N;
    }

    public void setN(byte n) {
        assert (n > 0);
        this.N = n;
    }
}

