/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.traversal.algorithm.records;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Stack;
import org.apache.commons.collections.CollectionUtils;
import org.apache.hugegraph.backend.id.Id;
import org.apache.hugegraph.perf.PerfUtil;
import org.apache.hugegraph.traversal.algorithm.HugeTraverser;
import org.apache.hugegraph.traversal.algorithm.records.AbstractRecords;
import org.apache.hugegraph.traversal.algorithm.records.record.Record;
import org.apache.hugegraph.traversal.algorithm.records.record.RecordType;
import org.apache.hugegraph.util.collection.IntIterator;

public abstract class DoubleWayMultiPathsRecords
extends AbstractRecords {
    private final Stack<Record> sourceRecords;
    private final Stack<Record> targetRecords;
    private IntIterator parentRecordKeys;
    private int currentKey;
    private boolean movingForward;
    private long accessed;

    public DoubleWayMultiPathsRecords(RecordType type, boolean concurrent, Id sourceV, Id targetV) {
        super(type, concurrent);
        int sourceCode = this.code(sourceV);
        int targetCode = this.code(targetV);
        Record firstSourceRecord = this.newRecord();
        Record firstTargetRecord = this.newRecord();
        firstSourceRecord.addPath(sourceCode, 0);
        firstTargetRecord.addPath(targetCode, 0);
        this.sourceRecords = new Stack();
        this.targetRecords = new Stack();
        this.sourceRecords.push(firstSourceRecord);
        this.targetRecords.push(firstTargetRecord);
        this.accessed = 2L;
    }

    @Override
    public void startOneLayer(boolean forward) {
        this.movingForward = forward;
        Record parentRecord = this.movingForward ? this.sourceRecords.peek() : this.targetRecords.peek();
        this.currentRecord(this.newRecord(), parentRecord);
        this.parentRecordKeys = parentRecord.keys();
    }

    @Override
    public void finishOneLayer() {
        Record record = this.currentRecord();
        if (this.movingForward) {
            this.sourceRecords.push(record);
        } else {
            this.targetRecords.push(record);
        }
        this.accessed += (long)record.size();
    }

    @Override
    @PerfUtil.Watched
    public boolean hasNextKey() {
        return this.parentRecordKeys.hasNext();
    }

    @Override
    @PerfUtil.Watched
    public Id nextKey() {
        this.currentKey = this.parentRecordKeys.next();
        return this.id(this.currentKey);
    }

    public boolean parentsContain(int id) {
        Record parentRecord = this.parentRecord();
        if (parentRecord == null) {
            return false;
        }
        IntIterator parents = parentRecord.get(this.currentKey);
        while (parents.hasNext()) {
            int parent = parents.next();
            if (parent != id) continue;
            return true;
        }
        return false;
    }

    @Override
    public long accessed() {
        return this.accessed;
    }

    public boolean sourcesLessThanTargets() {
        return this.sourceRecords.peek().size() <= this.targetRecords.peek().size();
    }

    @PerfUtil.Watched
    protected final HugeTraverser.PathSet linkPath(int source, int target, boolean ring) {
        HugeTraverser.PathSet paths = new HugeTraverser.PathSet();
        HugeTraverser.PathSet sources = this.linkSourcePath(source);
        HugeTraverser.PathSet targets = this.linkTargetPath(target);
        for (HugeTraverser.Path tpath : targets) {
            tpath.reverse();
            for (HugeTraverser.Path spath : sources) {
                if (!ring && CollectionUtils.containsAny(spath.vertices(), tpath.vertices())) continue;
                ArrayList<Id> ids = new ArrayList<Id>(spath.vertices());
                ids.addAll(tpath.vertices());
                Id crosspoint = this.id(this.movingForward ? target : source);
                paths.add(new HugeTraverser.Path(crosspoint, ids));
            }
        }
        return paths;
    }

    private HugeTraverser.PathSet linkSourcePath(int source) {
        return this.linkPathLayer(this.sourceRecords, source, this.sourceRecords.size() - 1);
    }

    private HugeTraverser.PathSet linkTargetPath(int target) {
        return this.linkPathLayer(this.targetRecords, target, this.targetRecords.size() - 1);
    }

    private HugeTraverser.PathSet linkPathLayer(Stack<Record> all, int id, int layerIndex) {
        HugeTraverser.PathSet results = new HugeTraverser.PathSet();
        if (layerIndex == 0) {
            Id sid = this.id(id);
            results.add(new HugeTraverser.Path(Lists.newArrayList((Object[])new Id[]{sid})));
            return results;
        }
        Id current = this.id(id);
        Record layer = (Record)all.elementAt(layerIndex);
        IntIterator iterator = layer.get(id);
        while (iterator.hasNext()) {
            int parent = iterator.next();
            HugeTraverser.PathSet paths = this.linkPathLayer(all, parent, layerIndex - 1);
            paths.append(current);
            results.addAll(paths);
        }
        return results;
    }

    @PerfUtil.Watched
    protected final void addPath(int current, int parent) {
        this.currentRecord().addPath(current, parent);
    }

    protected final boolean sourceContains(int node) {
        return this.sourceRecords.peek().containsKey(node);
    }

    protected final boolean targetContains(int node) {
        return this.targetRecords.peek().containsKey(node);
    }

    protected final Stack<Record> sourceRecords() {
        return this.sourceRecords;
    }

    protected final Stack<Record> targetRecords() {
        return this.targetRecords;
    }

    protected final boolean movingForward() {
        return this.movingForward;
    }

    protected final int current() {
        return this.currentKey;
    }
}

