/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.job.algorithm.cent;

import java.util.Map;
import org.apache.hugegraph.job.UserJob;
import org.apache.hugegraph.job.algorithm.cent.AbstractCentAlgorithm;
import org.apache.hugegraph.type.define.Directions;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.__;
import org.apache.tinkerpop.gremlin.structure.T;
import org.apache.tinkerpop.gremlin.structure.Vertex;

public class EigenvectorCentralityAlgorithm
extends AbstractCentAlgorithm {
    public static final long DEFAULT_DEGREE = 100L;
    public static final long DEFAULT_SAMPLE = 1L;

    @Override
    public String name() {
        return "eigenvector_centrality";
    }

    @Override
    public Object call(UserJob<Object> job, Map<String, Object> parameters) {
        try (Traverser traverser = new Traverser(job);){
            Object object = traverser.eigenvectorCentrality(EigenvectorCentralityAlgorithm.direction(parameters), EigenvectorCentralityAlgorithm.edgeLabel(parameters), EigenvectorCentralityAlgorithm.depth(parameters), EigenvectorCentralityAlgorithm.degree(parameters), EigenvectorCentralityAlgorithm.sample(parameters), EigenvectorCentralityAlgorithm.sourceLabel(parameters), EigenvectorCentralityAlgorithm.sourceSample(parameters), EigenvectorCentralityAlgorithm.sourceCLabel(parameters), EigenvectorCentralityAlgorithm.top(parameters));
            return object;
        }
    }

    private static class Traverser
    extends AbstractCentAlgorithm.Traverser {
        public Traverser(UserJob<Object> job) {
            super(job);
        }

        public Object eigenvectorCentrality(Directions direction, String label, int depth, long degree, long sample, String sourceLabel, long sourceSample, String sourceCLabel, long topN) {
            assert (depth > 0);
            assert (degree > 0L || degree == -1L);
            assert (topN >= 0L || topN == -1L);
            GraphTraversal t = this.constructSource(sourceLabel, sourceSample, sourceCLabel);
            GraphTraversal<Vertex, Vertex> unit = this.constructPathUnit(direction, label, degree, sample, sourceLabel, sourceCLabel);
            t = t.repeat((Traversal)__.groupCount((String)"m").by(T.id).local(unit).simplePath()).times(depth);
            GraphTraversal tCap = t.cap("m", new String[0]);
            GraphTraversal<Vertex, ?> tLimit = this.topN(tCap, topN);
            return this.execute(tLimit, () -> tLimit.next());
        }
    }
}

