/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.backend.cache;

import com.google.common.collect.ImmutableSet;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import org.apache.hugegraph.HugeGraphParams;
import org.apache.hugegraph.backend.cache.Cache;
import org.apache.hugegraph.backend.cache.CacheManager;
import org.apache.hugegraph.backend.cache.CachedBackendStore;
import org.apache.hugegraph.backend.id.Id;
import org.apache.hugegraph.backend.query.IdQuery;
import org.apache.hugegraph.backend.query.Query;
import org.apache.hugegraph.backend.query.QueryResults;
import org.apache.hugegraph.backend.store.BackendMutation;
import org.apache.hugegraph.backend.store.BackendStore;
import org.apache.hugegraph.backend.store.ram.RamTable;
import org.apache.hugegraph.backend.tx.GraphTransaction;
import org.apache.hugegraph.config.CoreOptions;
import org.apache.hugegraph.config.HugeConfig;
import org.apache.hugegraph.event.Event;
import org.apache.hugegraph.event.EventHub;
import org.apache.hugegraph.event.EventListener;
import org.apache.hugegraph.exception.NotSupportException;
import org.apache.hugegraph.iterator.ExtendableIterator;
import org.apache.hugegraph.iterator.ListIterator;
import org.apache.hugegraph.perf.PerfUtil;
import org.apache.hugegraph.schema.IndexLabel;
import org.apache.hugegraph.structure.HugeEdge;
import org.apache.hugegraph.structure.HugeVertex;
import org.apache.hugegraph.type.HugeType;
import org.apache.hugegraph.util.E;

public final class CachedGraphTransaction
extends GraphTransaction {
    private static final int MAX_CACHE_PROPS_PER_VERTEX = 10000;
    private static final int MAX_CACHE_EDGES_PER_QUERY = 100;
    private static final float DEFAULT_LEVEL_RATIO = 0.001f;
    private static final long AVG_VERTEX_ENTRY_SIZE = 40L;
    private static final long AVG_EDGE_ENTRY_SIZE = 100L;
    private final Cache<Id, Object> verticesCache;
    private final Cache<Id, Object> edgesCache;
    private EventListener storeEventListener;
    private EventListener cacheEventListener;

    public CachedGraphTransaction(HugeGraphParams graph, BackendStore store) {
        super(graph, store);
        HugeConfig conf = graph.configuration();
        String type = (String)conf.get(CoreOptions.VERTEX_CACHE_TYPE);
        long capacity = (Long)conf.get(CoreOptions.VERTEX_CACHE_CAPACITY);
        int expire = (Integer)conf.get(CoreOptions.VERTEX_CACHE_EXPIRE);
        this.verticesCache = this.cache("vertex", type, capacity, 40L, expire);
        type = (String)conf.get(CoreOptions.EDGE_CACHE_TYPE);
        capacity = (Long)conf.get(CoreOptions.EDGE_CACHE_CAPACITY);
        expire = (Integer)conf.get(CoreOptions.EDGE_CACHE_EXPIRE);
        this.edgesCache = this.cache("edge", type, capacity, 100L, expire);
        this.listenChanges();
    }

    @Override
    public void close() {
        try {
            super.close();
        }
        finally {
            this.unlistenChanges();
        }
    }

    private Cache<Id, Object> cache(String prefix, String type, long capacity, long entrySize, long expire) {
        Cache<Id, Object> cache;
        String name = prefix + "-" + this.params().spaceGraphName();
        switch (type) {
            case "l1": {
                cache = CacheManager.instance().cache(name, capacity);
                break;
            }
            case "l2": {
                long heapCapacity = (long)(0.001f * (float)capacity);
                cache = CacheManager.instance().levelCache(super.graph(), name, heapCapacity, capacity, entrySize);
                break;
            }
            default: {
                throw new NotSupportException("cache type '%s'", type);
            }
        }
        cache.expire(expire * 1000L);
        cache.enableMetrics(true);
        return cache;
    }

    private void listenChanges() {
        ImmutableSet storeEvents = ImmutableSet.of((Object)"store.init", (Object)"store.clear", (Object)"store.truncate");
        this.storeEventListener = arg_0 -> this.lambda$listenChanges$0((Set)storeEvents, arg_0);
        if (storeEventListenStatus.putIfAbsent(this.params().spaceGraphName(), true) == null) {
            this.store().provider().listen(this.storeEventListener);
        }
        this.cacheEventListener = event -> {
            LOG.debug("Graph {} received graph cache event: {}", (Object)this.graph(), (Object)event);
            Object[] args = event.args();
            E.checkArgument((args.length > 0 && args[0] instanceof String ? 1 : 0) != 0, (String)"Expect event action argument", (Object[])new Object[0]);
            if ("invalid".equals(args[0])) {
                event.checkArgs(new Class[]{String.class, HugeType.class, Object.class});
                HugeType type = (HugeType)args[1];
                if (type.isVertex()) {
                    Object arg2 = args[2];
                    if (arg2 instanceof Id) {
                        Id id = (Id)arg2;
                        this.verticesCache.invalidate(id);
                    } else if (arg2 != null && arg2.getClass().isArray()) {
                        int size = Array.getLength(arg2);
                        for (int i = 0; i < size; ++i) {
                            Object id = Array.get(arg2, i);
                            E.checkArgument((boolean)(id instanceof Id), (String)"Expect instance of Id in array, but got '%s'", (Object[])new Object[]{id.getClass()});
                            this.verticesCache.invalidate((Id)id);
                        }
                    } else {
                        E.checkArgument((boolean)false, (String)"Expect Id or Id[], but got: %s", (Object[])new Object[]{arg2});
                    }
                } else if (type.isEdge()) {
                    this.edgesCache.clear();
                }
                return true;
            }
            if ("clear".equals(args[0])) {
                event.checkArgs(new Class[]{String.class, HugeType.class});
                HugeType type = (HugeType)args[1];
                this.clearCache(type, false);
                return true;
            }
            return false;
        };
        if (graphCacheListenStatus.putIfAbsent(this.params().spaceGraphName(), true) == null) {
            EventHub graphEventHub = this.params().graphEventHub();
            graphEventHub.listen("cache", this.cacheEventListener);
        }
    }

    private void unlistenChanges() {
        String graphName = this.params().spaceGraphName();
        if (graphCacheListenStatus.remove(graphName) != null) {
            EventHub graphEventHub = this.params().graphEventHub();
            graphEventHub.unlisten("cache", this.cacheEventListener);
        }
        if (storeEventListenStatus.remove(graphName) != null) {
            this.store().provider().unlisten(this.storeEventListener);
        }
    }

    private void notifyChanges(String action, HugeType type, Id[] ids) {
        EventHub graphEventHub = this.params().graphEventHub();
        graphEventHub.notify("cache", new Object[]{action, type, ids});
    }

    private void notifyChanges(String action, HugeType type) {
        EventHub graphEventHub = this.params().graphEventHub();
        graphEventHub.notify("cache", new Object[]{action, type});
    }

    public void clearCache(HugeType type, boolean notify) {
        if (type == null || type == HugeType.VERTEX) {
            this.verticesCache.clear();
        }
        if (type == null || type == HugeType.EDGE) {
            this.edgesCache.clear();
        }
        if (notify) {
            this.notifyChanges("cleared", null);
        }
    }

    private boolean enableCacheVertex() {
        return this.verticesCache.capacity() > 0L;
    }

    private boolean enableCacheEdge() {
        return this.edgesCache.capacity() > 0L;
    }

    private boolean needCacheVertex(HugeVertex vertex) {
        return vertex.sizeOfSubProperties() <= 10000;
    }

    @Override
    @PerfUtil.Watched(prefix="graphcache")
    protected Iterator<HugeVertex> queryVerticesFromBackend(Query query) {
        if (this.enableCacheVertex() && query.idsSize() > 0 && query.conditionsSize() == 0) {
            return this.queryVerticesByIds((IdQuery)query);
        }
        return super.queryVerticesFromBackend(query);
    }

    @PerfUtil.Watched(prefix="graphcache")
    private Iterator<HugeVertex> queryVerticesByIds(IdQuery query) {
        if (query.idsSize() == 1) {
            Iterator<HugeVertex> rs;
            Id vertexId = query.ids().iterator().next();
            HugeVertex vertex = (HugeVertex)this.verticesCache.get(vertexId);
            if (vertex != null) {
                if (!vertex.expired()) {
                    return QueryResults.iterator(vertex);
                }
                this.verticesCache.invalidate(vertexId);
            }
            if ((vertex = QueryResults.one(rs = super.queryVerticesFromBackend(query))) == null) {
                return QueryResults.emptyIterator();
            }
            if (this.needCacheVertex(vertex)) {
                this.verticesCache.update(vertex.id(), vertex);
            }
            return QueryResults.iterator(vertex);
        }
        IdQuery newQuery = new IdQuery(HugeType.VERTEX, query);
        ArrayList<HugeVertex> vertices = new ArrayList<HugeVertex>();
        for (Id vertexId : query.ids()) {
            HugeVertex vertex = (HugeVertex)this.verticesCache.get(vertexId);
            if (vertex == null) {
                newQuery.query(vertexId);
                continue;
            }
            if (vertex.expired()) {
                newQuery.query(vertexId);
                this.verticesCache.invalidate(vertexId);
                continue;
            }
            vertices.add(vertex);
        }
        ExtendableIterator results = new ExtendableIterator();
        if (!vertices.isEmpty()) {
            results.extend(vertices.iterator());
        } else {
            newQuery = query;
        }
        if (!newQuery.empty()) {
            Iterator<HugeVertex> rs = super.queryVerticesFromBackend(newQuery);
            ListIterator<HugeVertex> listIterator = QueryResults.toList(rs);
            for (HugeVertex vertex : listIterator.list()) {
                if (!this.needCacheVertex(vertex)) continue;
                this.verticesCache.update(vertex.id(), vertex);
            }
            results.extend(listIterator);
        }
        return results;
    }

    @Override
    @PerfUtil.Watched(prefix="graphcache")
    protected Iterator<HugeEdge> queryEdgesFromBackend(Query query) {
        RamTable ramtable = this.params().ramtable();
        if (ramtable != null && ramtable.matched(query)) {
            return ramtable.query(query);
        }
        if (!this.enableCacheEdge() || query.empty() || query.paging() || query.bigCapacity()) {
            return super.queryEdgesFromBackend(query);
        }
        CachedBackendStore.QueryId cacheKey = new CachedBackendStore.QueryId(query);
        Object value = this.edgesCache.get(cacheKey);
        ArrayList<HugeEdge> edges = (ArrayList<HugeEdge>)value;
        if (value != null) {
            for (HugeEdge edge : edges) {
                if (!edge.expired()) continue;
                this.edgesCache.invalidate(cacheKey);
                value = null;
                break;
            }
        }
        if (value != null) {
            return edges.iterator();
        }
        Iterator<HugeEdge> rs = super.queryEdgesFromBackend(query);
        int tryMax = 101;
        edges = new ArrayList<HugeEdge>(101);
        for (int i = 0; rs.hasNext() && i < 101; ++i) {
            edges.add(rs.next());
        }
        if (edges.isEmpty()) {
            this.edgesCache.update(cacheKey, Collections.emptyList());
        } else if (edges.size() <= 100) {
            this.edgesCache.update(cacheKey, edges);
        }
        return new ExtendableIterator(edges.iterator(), rs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @PerfUtil.Watched(prefix="graphcache")
    protected void commitMutation2Backend(BackendMutation ... mutations) {
        boolean invalidEdgesCache;
        int edgesInTxSize;
        Collection<HugeVertex> deletions;
        Collection<HugeVertex> updates;
        block12: {
            updates = this.verticesInTxUpdated();
            deletions = this.verticesInTxRemoved();
            Id[] vertexIds = new Id[updates.size() + deletions.size()];
            int vertexOffset = 0;
            edgesInTxSize = this.edgesInTxSize();
            try {
                super.commitMutation2Backend(mutations);
                if (this.enableCacheVertex()) {
                    for (HugeVertex vertex : updates) {
                        vertexIds[vertexOffset++] = vertex.id();
                        if (this.needCacheVertex(vertex)) {
                            this.verticesCache.updateIfPresent(vertex.id(), vertex);
                            continue;
                        }
                        this.verticesCache.invalidate(vertex.id());
                    }
                }
                if (!this.enableCacheVertex()) break block12;
            }
            catch (Throwable throwable) {
                boolean invalidEdgesCache2;
                if (this.enableCacheVertex()) {
                    for (HugeVertex vertex : deletions) {
                        vertexIds[vertexOffset++] = vertex.id();
                        this.verticesCache.invalidate(vertex.id());
                    }
                    if (vertexOffset > 0) {
                        this.notifyChanges("invalided", HugeType.VERTEX, vertexIds);
                    }
                }
                boolean bl = invalidEdgesCache2 = edgesInTxSize + updates.size() + deletions.size() > 0;
                if (invalidEdgesCache2 && this.enableCacheEdge()) {
                    this.edgesCache.clear();
                    this.notifyChanges("cleared", HugeType.EDGE);
                }
                throw throwable;
            }
            for (HugeVertex vertex : deletions) {
                vertexIds[vertexOffset++] = vertex.id();
                this.verticesCache.invalidate(vertex.id());
            }
            if (vertexOffset > 0) {
                this.notifyChanges("invalided", HugeType.VERTEX, vertexIds);
            }
        }
        boolean bl = invalidEdgesCache = edgesInTxSize + updates.size() + deletions.size() > 0;
        if (invalidEdgesCache && this.enableCacheEdge()) {
            this.edgesCache.clear();
            this.notifyChanges("cleared", HugeType.EDGE);
        }
    }

    @Override
    public void removeIndex(IndexLabel indexLabel) {
        try {
            super.removeIndex(indexLabel);
        }
        finally {
            if (indexLabel.baseType() == HugeType.EDGE_LABEL) {
                this.edgesCache.clear();
                this.notifyChanges("cleared", HugeType.EDGE);
            }
        }
    }

    private /* synthetic */ Object lambda$listenChanges$0(Set storeEvents, Event event) {
        if (storeEvents.contains(event.name())) {
            LOG.debug("Graph {} clear graph cache on event '{}'", (Object)this.graph(), (Object)event.name());
            this.clearCache(null, true);
            return true;
        }
        return false;
    }
}

