/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.query.serializer;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.Map;
import org.apache.hugegraph.exception.BackendException;

public abstract class AbstractSerializerAdapter<T>
implements JsonSerializer<T>,
JsonDeserializer<T> {
    public abstract Map<String, Type> validType();

    public T deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonObject object = json.getAsJsonObject();
        String type = object.get("cls").getAsString();
        JsonElement element = object.get("el");
        try {
            return (T)context.deserialize(element, this.validType().get(type));
        }
        catch (Exception e) {
            throw new BackendException("Unknown element type: " + type, e);
        }
    }

    public JsonElement serialize(T src, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject result = new JsonObject();
        Class<?> clazz = src.getClass();
        result.add("cls", (JsonElement)new JsonPrimitive(clazz.getSimpleName().substring(0, 1).toUpperCase()));
        result.add("el", context.serialize(src, clazz));
        return result;
    }
}

