/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.auth;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import org.apache.hugegraph.HugeException;
import org.apache.hugegraph.HugeGraph;
import org.apache.hugegraph.auth.HugeGraphAuthProxy;
import org.apache.hugegraph.config.CoreOptions;
import org.apache.hugegraph.event.EventHub;
import org.apache.hugegraph.testutil.Whitebox;
import org.apache.hugegraph.util.Log;
import org.apache.tinkerpop.gremlin.groovy.engine.GremlinExecutor;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalSource;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversalSource;
import org.apache.tinkerpop.gremlin.server.GraphManager;
import org.apache.tinkerpop.gremlin.server.GremlinServer;
import org.apache.tinkerpop.gremlin.server.Settings;
import org.apache.tinkerpop.gremlin.server.util.ThreadFactoryUtil;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.slf4j.Logger;

public class ContextGremlinServer
extends GremlinServer {
    private static final Logger LOG = Log.logger(ContextGremlinServer.class);
    private static final String G_PREFIX = "__g_";
    private final EventHub eventHub;

    public ContextGremlinServer(Settings settings, EventHub eventHub) {
        super(settings, ContextGremlinServer.newGremlinExecutorService(settings));
        this.eventHub = eventHub;
        this.listenChanges();
    }

    private void listenChanges() {
        this.eventHub.listen("graph.create", event -> {
            LOG.debug("GremlinServer accepts event '{}'", (Object)event.name());
            event.checkArgs(new Class[]{HugeGraph.class});
            HugeGraph graph = (HugeGraph)event.args()[0];
            this.injectGraph(graph);
            return null;
        });
        this.eventHub.listen("graph.drop", event -> {
            LOG.debug("GremlinServer accepts event '{}'", (Object)event.name());
            event.checkArgs(new Class[]{HugeGraph.class});
            HugeGraph graph = (HugeGraph)event.args()[0];
            this.removeGraph(graph.spaceGraphName());
            return null;
        });
    }

    private void unlistenChanges() {
        if (this.eventHub == null) {
            return;
        }
        this.eventHub.unlisten("graph.create");
        this.eventHub.unlisten("graph.drop");
    }

    public synchronized CompletableFuture<Void> stop() {
        try {
            CompletableFuture completableFuture = super.stop();
            return completableFuture;
        }
        finally {
            this.unlistenChanges();
        }
    }

    public void injectAuthGraph() {
        GraphManager manager = this.getServerGremlinExecutor().getGraphManager();
        for (String name : manager.getGraphNames()) {
            Object graph = manager.getGraph(name);
            graph = new HugeGraphAuthProxy((HugeGraph)graph);
            manager.putGraph(name, graph);
        }
    }

    public void injectTraversalSource() {
        GraphManager manager = this.getServerGremlinExecutor().getGraphManager();
        for (String graph : manager.getGraphNames()) {
            GraphTraversalSource g = manager.getGraph(graph).traversal();
            String gName = G_PREFIX + graph;
            if (manager.getTraversalSource(gName) != null) {
                throw new HugeException("Found existing name '%s' in global bindings, it may lead to gremlin query error.", new Object[]{gName});
            }
            manager.putTraversalSource(gName, (TraversalSource)g);
        }
    }

    private void injectGraph(HugeGraph graph) {
        String name = graph.spaceGraphName();
        GraphManager manager = this.getServerGremlinExecutor().getGraphManager();
        GremlinExecutor executor = this.getServerGremlinExecutor().getGremlinExecutor();
        manager.putGraph(name, (Graph)graph);
        GraphTraversalSource g = manager.getGraph(name).traversal();
        manager.putTraversalSource(G_PREFIX + name, (TraversalSource)g);
        Whitebox.invoke((Object)executor, (String)"globalBindings", (Class[])new Class[]{String.class, Object.class}, (String)"put", (Object[])new Object[]{name, graph});
    }

    private void removeGraph(String name) {
        GraphManager manager = this.getServerGremlinExecutor().getGraphManager();
        GremlinExecutor executor = this.getServerGremlinExecutor().getGremlinExecutor();
        try {
            manager.removeGraph(name);
            manager.removeTraversalSource(G_PREFIX + name);
            Whitebox.invoke((Object)executor, (String)"globalBindings", (Class[])new Class[]{Object.class}, (String)"remove", (Object[])new Object[]{name});
        }
        catch (Exception e) {
            throw new HugeException("Failed to remove graph '%s' from gremlin server context", (Throwable)e, new Object[]{name});
        }
    }

    static ExecutorService newGremlinExecutorService(Settings settings) {
        if (settings.gremlinPool == 0) {
            settings.gremlinPool = CoreOptions.CPUS;
        }
        int size = settings.gremlinPool;
        ThreadFactory factory = ThreadFactoryUtil.create((String)"exec-%d");
        return new HugeGraphAuthProxy.ContextThreadPoolExecutor(size, size, factory);
    }

    static {
        HugeGraphAuthProxy.setContext(HugeGraphAuthProxy.Context.admin());
    }
}

