/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.api.auth;

import com.codahale.metrics.annotation.Timed;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableMap;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Singleton;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.hugegraph.api.API;
import org.apache.hugegraph.api.filter.StatusFilter;
import org.apache.hugegraph.auth.AuthManager;
import org.apache.hugegraph.auth.HugeGraphAuthProxy;
import org.apache.hugegraph.auth.HugePermission;
import org.apache.hugegraph.core.GraphManager;
import org.apache.hugegraph.define.Checkable;
import org.apache.hugegraph.util.E;
import org.apache.hugegraph.util.Log;
import org.slf4j.Logger;

@Path(value="graphspaces/{graphspace}/auth/managers")
@Singleton
@Tag(name="ManagerAPI")
public class ManagerAPI
extends API {
    private static final Logger LOG = Log.logger(ManagerAPI.class);

    @POST
    @Timed
    @StatusFilter.Status(value=201)
    @Consumes(value={"application/json"})
    @Produces(value={"application/json;charset=UTF-8"})
    public String createManager(@Context GraphManager manager, @PathParam(value="graphspace") String graphSpace, JsonManager jsonManager) {
        LOG.debug("Create manager: {}", (Object)jsonManager);
        String user = jsonManager.user;
        HugePermission type = jsonManager.type;
        this.validType(type);
        AuthManager authManager = manager.authManager();
        this.validUser(authManager, user);
        String creator = HugeGraphAuthProxy.getContext().user().username();
        switch (type) {
            case SPACE: {
                this.validGraphSpace(manager, graphSpace);
                ManagerAPI.validPermission(ManagerAPI.hasAdminOrSpaceManagerPerm(manager, graphSpace, creator), creator, "manager.create");
                if (authManager.isSpaceMember(graphSpace, user)) {
                    authManager.deleteSpaceMember(graphSpace, user);
                }
                authManager.createSpaceManager(graphSpace, user);
                break;
            }
            case SPACE_MEMBER: {
                this.validGraphSpace(manager, graphSpace);
                ManagerAPI.validPermission(ManagerAPI.hasAdminOrSpaceManagerPerm(manager, graphSpace, creator), creator, "manager.create");
                if (authManager.isSpaceManager(graphSpace, user)) {
                    authManager.deleteSpaceManager(graphSpace, user);
                }
                authManager.createSpaceMember(graphSpace, user);
                break;
            }
            case ADMIN: {
                ManagerAPI.validPermission(ManagerAPI.hasAdminPerm(manager, creator), creator, "manager.create");
                authManager.createAdminManager(user);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid type");
            }
        }
        return manager.serializer().writeMap((Map<?, ?>)ImmutableMap.of((Object)"user", (Object)user, (Object)"type", (Object)type, (Object)"graphspace", (Object)graphSpace));
    }

    @DELETE
    @Timed
    @Consumes(value={"application/json"})
    public void delete(@Context GraphManager manager, @PathParam(value="graphspace") String graphSpace, @QueryParam(value="user") String user, @QueryParam(value="type") HugePermission type) {
        LOG.debug("Delete graph manager: {} {} {}", new Object[]{user, type, graphSpace});
        E.checkArgument((!"admin".equals(user) || type != HugePermission.ADMIN ? 1 : 0) != 0, (String)"User 'admin' can't be removed from ADMIN", (Object[])new Object[0]);
        AuthManager authManager = manager.authManager();
        this.validType(type);
        this.validUser(authManager, user);
        String actionUser = HugeGraphAuthProxy.getContext().user().username();
        switch (type) {
            case SPACE: {
                this.validGraphSpace(manager, graphSpace);
                ManagerAPI.validPermission(ManagerAPI.hasAdminOrSpaceManagerPerm(manager, graphSpace, actionUser), actionUser, "manager.delete");
                authManager.deleteSpaceManager(graphSpace, user);
                break;
            }
            case SPACE_MEMBER: {
                this.validGraphSpace(manager, graphSpace);
                ManagerAPI.validPermission(ManagerAPI.hasAdminOrSpaceManagerPerm(manager, graphSpace, actionUser), actionUser, "manager.delete");
                authManager.deleteSpaceMember(graphSpace, user);
                break;
            }
            case ADMIN: {
                ManagerAPI.validPermission(ManagerAPI.hasAdminPerm(manager, actionUser), actionUser, "manager.delete");
                authManager.deleteAdminManager(user);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid type");
            }
        }
    }

    @GET
    @Timed
    @Consumes(value={"application/json"})
    public String list(@Context GraphManager manager, @PathParam(value="graphspace") String graphSpace, @QueryParam(value="type") HugePermission type) {
        List adminManagers;
        LOG.debug("list graph manager: {} {}", (Object)type, (Object)graphSpace);
        AuthManager authManager = manager.authManager();
        this.validType(type);
        switch (type) {
            case SPACE: {
                this.validGraphSpace(manager, graphSpace);
                adminManagers = authManager.listSpaceManager(graphSpace);
                break;
            }
            case SPACE_MEMBER: {
                this.validGraphSpace(manager, graphSpace);
                adminManagers = authManager.listSpaceMember(graphSpace);
                break;
            }
            case ADMIN: {
                adminManagers = authManager.listAdminManager();
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid type");
            }
        }
        return manager.serializer().writeList("admins", adminManagers);
    }

    @GET
    @Timed
    @Path(value="check")
    @Consumes(value={"application/json"})
    public String checkRole(@Context GraphManager manager, @PathParam(value="graphspace") String graphSpace, @QueryParam(value="type") HugePermission type) {
        boolean result;
        LOG.debug("check if current user is graph manager: {} {}", (Object)type, (Object)graphSpace);
        this.validType(type);
        AuthManager authManager = manager.authManager();
        String user = HugeGraphAuthProxy.getContext().user().username();
        switch (type) {
            case SPACE: {
                this.validGraphSpace(manager, graphSpace);
                result = authManager.isSpaceManager(graphSpace, user);
                break;
            }
            case SPACE_MEMBER: {
                this.validGraphSpace(manager, graphSpace);
                result = authManager.isSpaceMember(graphSpace, user);
                break;
            }
            case ADMIN: {
                result = authManager.isAdminManager(user);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid type");
            }
        }
        return manager.serializer().writeMap((Map<?, ?>)ImmutableMap.of((Object)"check", (Object)result));
    }

    @GET
    @Timed
    @Path(value="role")
    @Consumes(value={"application/json"})
    public String getRolesInGs(@Context GraphManager manager, @PathParam(value="graphspace") String graphSpace, @QueryParam(value="user") String user) {
        LOG.debug("get user [{}]'s role in graph space [{}]", (Object)user, (Object)graphSpace);
        AuthManager authManager = manager.authManager();
        ArrayList<HugePermission> result = new ArrayList<HugePermission>();
        this.validGraphSpace(manager, graphSpace);
        if (authManager.isAdminManager(user)) {
            result.add(HugePermission.ADMIN);
        }
        if (authManager.isSpaceManager(graphSpace, user)) {
            result.add(HugePermission.SPACE);
        }
        if (authManager.isSpaceMember(graphSpace, user)) {
            result.add(HugePermission.SPACE_MEMBER);
        }
        if (result.isEmpty()) {
            result.add(HugePermission.NONE);
        }
        return manager.serializer().writeMap((Map<?, ?>)ImmutableMap.of((Object)"user", (Object)user, (Object)"graphspace", (Object)graphSpace, (Object)"roles", result));
    }

    private void validUser(AuthManager authManager, String user) {
        E.checkArgument((authManager.findUser(user) != null || authManager.findGroup(user) != null ? 1 : 0) != 0, (String)"The user or group is not exist", (Object[])new Object[0]);
    }

    private void validType(HugePermission type) {
        E.checkArgument((type == HugePermission.SPACE || type == HugePermission.SPACE_MEMBER || type == HugePermission.ADMIN ? 1 : 0) != 0, (String)"The type must be in [SPACE, SPACE_MEMBER, ADMIN]", (Object[])new Object[0]);
    }

    private void validGraphSpace(GraphManager manager, String graphSpace) {
        E.checkArgument((manager.graphSpace(graphSpace) != null ? 1 : 0) != 0, (String)"The graph space is not exist", (Object[])new Object[0]);
    }

    private static class JsonManager
    implements Checkable {
        @JsonProperty(value="user")
        private String user;
        @JsonProperty(value="type")
        private HugePermission type;

        private JsonManager() {
        }

        @Override
        public void checkCreate(boolean isBatch) {
        }

        @Override
        public void checkUpdate() {
        }
    }
}

