/*
 * Decompiled with CFR 0.152.
 */
package org.apdplat.word.segmentation.impl;

import java.util.ArrayList;
import java.util.List;
import org.apdplat.word.recognition.RecognitionTool;
import org.apdplat.word.segmentation.SegmentationAlgorithm;
import org.apdplat.word.segmentation.Word;
import org.apdplat.word.segmentation.impl.AbstractSegmentation;

public class MaximumMatching
extends AbstractSegmentation {
    @Override
    public SegmentationAlgorithm getSegmentationAlgorithm() {
        return SegmentationAlgorithm.MaximumMatching;
    }

    @Override
    public List<Word> segImpl(String string) {
        ArrayList<Word> arrayList = new ArrayList<Word>();
        int n = string.length();
        int n2 = this.getInterceptLength();
        for (int i = 0; i < n; i += n2) {
            if (n2 > n - i) {
                n2 = n - i;
            }
            while (!this.getDictionary().contains(string, i, n2) && !RecognitionTool.recog(string, i, n2) && n2 != 1) {
                --n2;
            }
            this.addWord(arrayList, string, i, n2);
            n2 = this.getInterceptLength();
        }
        return arrayList;
    }

    public static void main(String[] stringArray) {
        String string = "\u4ed6\u5341\u5206\u60ca\u8bb6\u5730\u8bf4\uff1a\u201c\u554a\uff0c\u539f\u6765\u662f\u60a8\uff0c\u6768\u5c1a\u5ddd\uff01\u80fd\u89c1\u5230\u60a8\u771f\u662f\u592a\u597d\u4e86\uff0c\u6211\u6709\u4e2aNutch\u95ee\u9898\u60f3\u5411\u60a8\u8bf7\u6559\u5462\uff01\u201d";
        if (stringArray != null && stringArray.length == 1) {
            string = stringArray[0];
        }
        MaximumMatching maximumMatching = new MaximumMatching();
        System.out.println(maximumMatching.seg(string).toString());
    }
}

