/*
 * Decompiled with CFR 0.152.
 */
package org.gridkit.jvmtool.hflame.cmd;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.beust.jcommander.ParametersDelegate;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.TimeZone;
import org.gridkit.jvmtool.AbstractThreadDumpSource;
import org.gridkit.jvmtool.cli.CommandLauncher;
import org.gridkit.jvmtool.codec.stacktrace.ThreadSnapshotEvent;
import org.gridkit.jvmtool.event.EventMorpher;
import org.gridkit.jvmtool.hflame.FlameTemplateProcessor;
import org.gridkit.jvmtool.hflame.JsonFlameDataSet;
import org.gridkit.jvmtool.hflame.XmlUtil;
import org.w3c.dom.Document;

public class FlameGraphGeneratorCmd
implements CommandLauncher.CmdRef {
    public String getCommandName() {
        return "flame";
    }

    public Runnable newCommand(CommandLauncher host) {
        return new FlameGen(host);
    }

    static class DumpInput
    extends AbstractThreadDumpSource {
        @Parameter(names={"-f", "--file"}, description="Input files", required=true, variableArity=true)
        private List<String> inputFiles = new ArrayList<String>();

        public DumpInput(CommandLauncher host) {
            super(host);
        }

        @Override
        protected List<String> inputFiles() {
            return this.inputFiles;
        }
    }

    @Parameters(commandDescription="Generates flame graph from stack traces")
    public static class FlameGen
    implements Runnable {
        @ParametersDelegate
        private CommandLauncher host;
        @ParametersDelegate
        private DumpInput input;
        @Parameter(names={"-o", "--output"}, required=true, description="Name of generated report file")
        private String outputFile;
        @Parameter(names={"-tz", "--timezone", "--time-zone"}, required=false, description="Time zone used for timestamps and time ranges")
        private String timeZone = "UTC";
        private int traceCounter;

        public FlameGen(CommandLauncher host) {
            this.host = host;
            this.input = new DumpInput(host);
        }

        @Override
        public void run() {
            try {
                TimeZone tz = TimeZone.getTimeZone(this.timeZone);
                this.input.setTimeZone(tz);
                Document template = XmlUtil.parseFromResource((String)"flame_template.html");
                FlameTemplateProcessor tproc = new FlameTemplateProcessor(template);
                JsonFlameDataSet dataSet = new JsonFlameDataSet();
                dataSet.setWeightCalculator(this.input.getWeightCalculator());
                System.out.println("Input files");
                for (String f : this.input.sourceFiles()) {
                    System.out.println("  " + f);
                }
                System.out.println();
                dataSet.feed((Iterable)this.input.getFilteredReader().morph((EventMorpher)new EventMorpher<ThreadSnapshotEvent, ThreadSnapshotEvent>(){

                    public ThreadSnapshotEvent morph(ThreadSnapshotEvent event) {
                        if (event.stackTrace() != null && !event.stackTrace().isEmpty()) {
                            ++FlameGen.this.traceCounter;
                            return event;
                        }
                        return null;
                    }
                }));
                System.out.println(this.traceCounter + " samples processed");
                if (this.traceCounter == 0) {
                    System.out.println("No data omit report generation");
                }
                tproc.setDataSet("fg1", dataSet);
                OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(this.outputFile), Charset.forName("UTF8"));
                tproc.generate((Writer)writer);
                writer.close();
                System.out.println("Generated " + new File(this.outputFile).getAbsolutePath() + " (" + new File(this.outputFile).length() + " bytes)");
            }
            catch (Exception e) {
                this.host.fail("Unexpected error: " + e.toString(), e);
            }
        }
    }
}

