/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.backend.store.hstore;

import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hugegraph.backend.query.Query;
import org.apache.hugegraph.backend.store.BackendEntry;
import org.apache.hugegraph.backend.store.BackendSession;
import org.apache.hugegraph.backend.store.BackendSessionPool;
import org.apache.hugegraph.config.HugeConfig;
import org.apache.hugegraph.store.HgOwnerKey;
import org.apache.hugegraph.type.define.GraphMode;

public abstract class HstoreSessions
extends BackendSessionPool {
    public HstoreSessions(HugeConfig config, String database, String store) {
        super(config, database + "/" + store);
    }

    public abstract Set<String> openedTables();

    public abstract void createTable(String ... var1);

    public abstract void dropTable(String ... var1);

    public abstract boolean existsTable(String var1);

    public abstract void truncateTable(String var1);

    public abstract void clear();

    public abstract Session session();

    public static abstract class Session
    extends BackendSession.AbstractBackendSession {
        public static final int SCAN_ANY = 128;
        public static final int SCAN_PREFIX_BEGIN = 1;
        public static final int SCAN_PREFIX_END = 2;
        public static final int SCAN_GT_BEGIN = 4;
        public static final int SCAN_GTE_BEGIN = 12;
        public static final int SCAN_LT_END = 16;
        public static final int SCAN_LTE_END = 48;
        public static final int SCAN_KEY_ONLY = 64;
        public static final int SCAN_HASHCODE = 256;
        private HugeConfig conf;
        private String graphName;

        public static boolean matchScanType(int expected, int actual) {
            return (expected & actual) == expected;
        }

        public abstract void createTable(String var1);

        public abstract void dropTable(String var1);

        public abstract boolean existsTable(String var1);

        public abstract void truncateTable(String var1);

        public abstract void deleteGraph();

        public abstract Pair<byte[], byte[]> keyRange(String var1);

        public abstract void put(String var1, byte[] var2, byte[] var3, byte[] var4);

        public abstract void increase(String var1, byte[] var2, byte[] var3, byte[] var4);

        public abstract void delete(String var1, byte[] var2, byte[] var3);

        public abstract void deletePrefix(String var1, byte[] var2, byte[] var3);

        public abstract void deleteRange(String var1, byte[] var2, byte[] var3, byte[] var4, byte[] var5);

        public abstract byte[] get(String var1, byte[] var2);

        public abstract byte[] get(String var1, byte[] var2, byte[] var3);

        public abstract BackendEntry.BackendColumnIterator scan(String var1);

        public abstract BackendEntry.BackendColumnIterator scan(String var1, byte[] var2, byte[] var3);

        public BackendEntry.BackendColumnIterator scan(String table, byte[] ownerKeyFrom, byte[] ownerKeyTo, byte[] keyFrom, byte[] keyTo) {
            return this.scan(table, ownerKeyFrom, ownerKeyTo, keyFrom, keyTo, 16);
        }

        public abstract List<BackendEntry.BackendColumnIterator> scan(String var1, List<HgOwnerKey> var2, int var3, long var4, byte[] var6);

        public abstract BackendEntry.BackendIterator<BackendEntry.BackendColumnIterator> scan(String var1, Iterator<HgOwnerKey> var2, int var3, Query var4, byte[] var5);

        public abstract BackendEntry.BackendColumnIterator scan(String var1, byte[] var2, byte[] var3, byte[] var4, byte[] var5, int var6);

        public abstract BackendEntry.BackendColumnIterator scan(String var1, byte[] var2, byte[] var3, byte[] var4, byte[] var5, int var6, byte[] var7);

        public abstract BackendEntry.BackendColumnIterator scan(String var1, byte[] var2, byte[] var3, byte[] var4, byte[] var5, int var6, byte[] var7, byte[] var8);

        public abstract BackendEntry.BackendColumnIterator scan(String var1, int var2, int var3, int var4, byte[] var5);

        public abstract BackendEntry.BackendColumnIterator scan(String var1, int var2, int var3, int var4, byte[] var5, byte[] var6);

        public abstract BackendEntry.BackendColumnIterator getWithBatch(String var1, List<HgOwnerKey> var2);

        public abstract void merge(String var1, byte[] var2, byte[] var3, byte[] var4);

        public abstract void setMode(GraphMode var1);

        public abstract void truncate() throws Exception;

        public abstract BackendEntry.BackendColumnIterator scan(String var1, byte[] var2);

        public HugeConfig getConf() {
            return this.conf;
        }

        public void setConf(HugeConfig conf) {
            this.conf = conf;
        }

        public String getGraphName() {
            return this.graphName;
        }

        public void setGraphName(String graphName) {
            this.graphName = graphName;
        }

        public abstract void beginTx();

        public abstract int getActiveStoreSize();
    }

    public static interface Countable {
        public long count();
    }
}

